/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.dict.param.DeviceIdParam;
import io.huimu.modules.dict.param.GetDeviceItemPageParam;
import io.huimu.modules.dict.param.UpdateDeviceItemParam;
import io.huimu.modules.dict.service.DictDeviceExamItemService;
import io.huimu.modules.dict.vo.DictDeviceItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deviceItem"})
@Api(tags={"\u8bbe\u5907\u548c\u68c0\u67e5\u9879\u76ee\u5173\u7cfb"})
public class DictDeviceIdItemController {
    @Autowired
    private DictDeviceExamItemService examItemService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetDeviceItemPageParam.class)
    public Result<PageData<DictDeviceItemVO>> page(@RequestBody EncryptedReq<GetDeviceItemPageParam> req) throws IllegalAccessException {
        GetDeviceItemPageParam dto = (GetDeviceItemPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        PageData page = this.examItemService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"saveOrUpdate"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539")
    @LogOperation(value="\u65b0\u589e", module="\u8bbe\u5907\u548c\u68c0\u67e5\u9879\u76ee\u5173\u7cfb", operationType=1)
    @DecryptAndVerify(decryptedClass=UpdateDeviceItemParam.class)
    public Result save(@RequestBody EncryptedReq<UpdateDeviceItemParam> req) {
        UpdateDeviceItemParam dto = (UpdateDeviceItemParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examItemService.saveOrUpdate(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=DeviceIdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<DeviceIdParam> req) {
        DeviceIdParam param = (DeviceIdParam)req.getData();
        DictDeviceItemVO vo = this.examItemService.getInfo(param.getDeviceId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=DeviceIdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u8bbe\u5907\u548c\u68c0\u67e5\u9879\u76ee\u5173\u7cfb", operationType=3)
    public Result delete(@RequestBody EncryptedReq<DeviceIdParam> req) {
        DeviceIdParam dto = (DeviceIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examItemService.delete(dto.getDeviceId());
        return new Result();
    }
}

