/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.IdsParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictDataExtractConfDTO;
import io.huimu.modules.dict.entity.DictDataExtractConfEntity;
import io.huimu.modules.dict.param.GetParentListParam;
import io.huimu.modules.dict.service.DictDataExtractConfService;
import io.huimu.modules.dict.vo.DictDataExtractConfVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/data/extract/conf"})
@Api(tags={"\u6570\u636e\u63d0\u53d6\u914d\u7f6e"})
public class DictDataExtractConfController {
    @Autowired
    private DictDataExtractConfService dictDataExtractConfService;

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        DictDataExtractConfEntity entity = (DictDataExtractConfEntity)this.dictDataExtractConfService.selectById((Serializable)((Object)param.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)entity, DictDataExtractConfDTO.class));
    }

    @PostMapping(value={"getConfInfoByDeviceId"})
    @ApiOperation(value="\u6839\u636e\u8bbe\u5907id\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getConfInfoByDeviceId(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        DictDataExtractConfVO vo = this.dictDataExtractConfService.getExtractConfInfo(param.getId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"getParentList"})
    @ApiOperation(value="\u83b7\u53d6\u7236\u7ea7\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetParentListParam.class)
    public Result getParentList(@RequestBody EncryptedReq<GetParentListParam> req) {
        GetParentListParam param = (GetParentListParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.dictDataExtractConfService.getParentList(param);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getChildrenList"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ea7\u5217\u8868")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getChildrenList(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        List list = this.dictDataExtractConfService.getChildrenList(param.getId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u65b0\u589e", module="\u6570\u636e\u63d0\u53d6\u914d\u7f6e", operationType=1)
    @DecryptAndVerify(decryptedClass=DictDataExtractConfDTO.class)
    public Result save(@RequestBody EncryptedReq<DictDataExtractConfDTO> req) {
        DictDataExtractConfDTO param = (DictDataExtractConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        this.dictDataExtractConfService.save(param);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @DecryptAndVerify(decryptedClass=DictDataExtractConfDTO.class)
    @LogOperation(value="\u4fee\u6539", module="\u6570\u636e\u63d0\u53d6\u914d\u7f6e", operationType=1)
    public Result update(@RequestBody EncryptedReq<DictDataExtractConfDTO> req) {
        DictDataExtractConfDTO param = (DictDataExtractConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.dictDataExtractConfService.update(param);
        return new Result();
    }

    @PostMapping(value={"deleteChildren"})
    @ApiOperation(value="\u5220\u9664\u5b50\u7ea7")
    @DecryptAndVerify(decryptedClass=IdsParam.class)
    @LogOperation(value="\u5220\u9664\u5b50\u7ea7", module="\u6570\u636e\u63d0\u53d6\u914d\u7f6e", operationType=1)
    public Result deleteChildren(@RequestBody EncryptedReq<IdsParam> req) {
        IdsParam param = (IdsParam)req.getData();
        this.dictDataExtractConfService.deleteChildren(param.getId());
        return new Result();
    }

    @PostMapping(value={"deleteParent"})
    @ApiOperation(value="\u5220\u9664\u7236\u7ea7")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664\u7236\u7ea7", module="\u6570\u636e\u63d0\u53d6\u914d\u7f6e", operationType=1)
    public Result deleteParent(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        this.dictDataExtractConfService.deleteParent(param.getId());
        return new Result();
    }
}

