/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dataextract.service;

import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.modules.dataextract.dao.DataExtractDao;
import io.huimu.modules.dataextract.param.DataExtractParam;
import io.huimu.modules.dataextract.param.GetExtractDataParam;
import io.huimu.modules.dataextract.vo.ExtractDataVO;
import io.huimu.modules.dict.service.DictDataExtractConfService;
import io.huimu.modules.dict.vo.DictDataExtractConfVO;
import io.huimu.modules.security.user.SecurityUser;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataExtractService {
    @Autowired
    private DictDataExtractConfService dictDataExtractConfService;
    @Autowired
    private DataExtractDao dataExtractDao;

    @Transactional(rollbackFor={Exception.class})
    public void saveExtractData(DataExtractParam dto) {
        Map dataMap;
        DictDataExtractConfVO extractConfVO = this.dictDataExtractConfService.getExtractConfInfo(dto.getDeviceId());
        if (null == extractConfVO) {
            return;
        }
        if (null != dto.getOdDataMap()) {
            dataMap = dto.getOdDataMap();
            dataMap.put("exam_time", DateUtils.format((Date)dto.getExamTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            dataMap.put("patient_id", dto.getPatientId());
            dataMap.put("hospital_code", dto.getOrgCode());
            if (StringUtils.isNotBlank((CharSequence)dto.getFileSourcePath())) {
                dataMap.put("file_source_path", dto.getFileSourcePath().replace("\\", "/"));
            }
            dataMap.put("file_name", dto.getFileName());
            dataMap.put("file_path", dto.getFilePath());
            dataMap.put("exam_no", dto.getExamNo());
            dataMap.put("exam_item", dto.getExamItem());
            dataMap.put("exam_item_code", dto.getExamItemCode());
            dataMap.put("device_id", dto.getDeviceId());
            dataMap.put("confirm_user_id", SecurityUser.getEmployeeId());
            dataMap.put("confirm_user_name", SecurityUser.getUser().getRealName());
            dataMap.put("is_csv_pdf", dto.getIsCsvPdf().toString());
            this.dataExtractDao.callDataExtractProc(extractConfVO.getDbUser(), extractConfVO.getTableName(), JsonUtils.toJsonString((Object)dataMap));
        }
        if (null != dto.getOsDataMap()) {
            dataMap = dto.getOsDataMap();
            dataMap.put("exam_time", DateUtils.format((Date)dto.getExamTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            dataMap.put("patient_id", dto.getPatientId());
            dataMap.put("hospital_code", dto.getOrgCode());
            if (StringUtils.isNotBlank((CharSequence)dto.getFileSourcePath())) {
                dataMap.put("file_source_path", dto.getFileSourcePath().replace("\\", "/"));
            }
            dataMap.put("file_name", dto.getFileName());
            dataMap.put("file_path", dto.getFilePath());
            dataMap.put("exam_no", dto.getExamNo());
            dataMap.put("exam_item", dto.getExamItem());
            dataMap.put("exam_item_code", dto.getExamItemCode());
            dataMap.put("device_id", dto.getDeviceId());
            dataMap.put("confirm_user_id", SecurityUser.getEmployeeId());
            dataMap.put("confirm_user_name", SecurityUser.getUser().getRealName());
            dataMap.put("is_csv_pdf", dto.getIsCsvPdf().toString());
            this.dataExtractDao.callDataExtractProc(extractConfVO.getDbUser(), extractConfVO.getTableName(), JsonUtils.toJsonString((Object)dataMap));
        }
    }

    public ExtractDataVO getExtractData(GetExtractDataParam dto) {
        Map osMap;
        DictDataExtractConfVO extractConfVO = this.dictDataExtractConfService.getExtractConfInfo(dto.getDeviceId());
        if (null == extractConfVO) {
            return null;
        }
        ExtractDataVO vo = new ExtractDataVO();
        Map odMap = this.dataExtractDao.getExtractData(extractConfVO.getDbUser(), extractConfVO.getTableName(), Integer.valueOf(1), dto.getFileSourcePath().replace("\\", "/"));
        if (null != odMap) {
            vo.setOdDataMap((Map)MapUtils.mapKeyLowerCaseObject((Map)odMap));
        }
        if (null != (osMap = this.dataExtractDao.getExtractData(extractConfVO.getDbUser(), extractConfVO.getTableName(), Integer.valueOf(2), dto.getFileSourcePath().replace("\\", "/")))) {
            vo.setOsDataMap((Map)MapUtils.mapKeyLowerCaseObject((Map)osMap));
        }
        return vo;
    }
}

