/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

/*
 * Exception performing whole class analysis ignored.
 */
public class MachineCodeUtil {
    public static final String LINUX_OS_NAME = "LINUX";
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";

    public static void main(String[] args) throws IOException {
        System.out.println("CPUID:" + MachineCodeUtil.getCpuId());
        System.out.println("BiosUuid:" + MachineCodeUtil.getBiosUuid());
    }

    public static String getThisMachineCode() {
        try {
            return MachineCodeUtil.getCpuId() + MachineCodeUtil.getBiosUuid();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getCpuId() throws IOException {
        String os = System.getProperty("os.name");
        String cpuId = "LINUX".equals(os = os.toUpperCase()) ? MachineCodeUtil.getLinuxDmidecodeInfo((String)"dmidecode -t processor | grep 'ID'", (String)"ID", (String)":") : MachineCodeUtil.getWindowsCpuId();
        return cpuId.toUpperCase().replace(" ", "");
    }

    public static String getLinuxDmidecodeInfo(String cmd, String record, String symbol) throws IOException {
        String[] infos;
        String execResult = MachineCodeUtil.executeLinuxCmd((String)cmd);
        for (String info : infos = execResult.split("\n")) {
            if (!(info = info.trim()).contains(record)) continue;
            info.replace(" ", "");
            String[] sn = info.split(symbol);
            return sn[1];
        }
        return null;
    }

    public static String executeLinuxCmd(String cmd) throws IOException {
        int n;
        Runtime run = Runtime.getRuntime();
        Process process = run.exec(cmd);
        InputStream processInputStream = process.getInputStream();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] b = new byte[8192];
        while ((n = processInputStream.read(b)) != -1) {
            stringBuilder.append(new String(b, 0, n));
        }
        processInputStream.close();
        process.destroy();
        return stringBuilder.toString();
    }

    public static String getWindowsCpuId() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"wmic", "cpu", "get", "ProcessorId"});
        process.getOutputStream().close();
        Scanner sc = new Scanner(process.getInputStream());
        sc.next();
        String serial = sc.next();
        return serial;
    }

    public static String getBiosUuid() throws IOException {
        String os = System.getProperty("os.name");
        String cpuId = "LINUX".equals(os = os.toUpperCase()) ? MachineCodeUtil.getLinuxDmidecodeInfo((String)"dmidecode -t system | grep 'UUID'", (String)"UUID", (String)":") : MachineCodeUtil.getWindowsBiosUUID();
        return cpuId.toUpperCase().replace(" ", "");
    }

    public static String getWindowsBiosUUID() throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"wmic", "path", "win32_computersystemproduct", "get", "uuid"});
        process.getOutputStream().close();
        Scanner sc = new Scanner(process.getInputStream());
        sc.next();
        String serial = sc.next();
        return serial;
    }
}

