/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.utils;

import io.huimu.common.exception.RenException;
import io.huimu.common.utils.DateUtils;
import io.huimu.modules.upload.entity.FileInfoEntity;
import io.huimu.modules.upload.entity.UploadEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    public static final String FILE_PATH_SPLIT = "/";
    private static final int BUFFER_SIZE = 8192;

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static void copyFile(String oldFilePath, String newFilePath, String newFileName) throws IOException {
        File file = new File(oldFilePath);
        if (file.exists()) {
            org.apache.commons.io.FileUtils.copyFile((File)file, (File)new File(newFilePath + "/" + newFileName));
        }
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String[] getYMDStr() {
        Date now = new Date();
        String ymdPath = DateUtils.format((Date)now, (String)"yyyy_MM_dd_HH_mm_ss_SSS");
        return ymdPath.split("_");
    }

    public static UploadEntity upload(MultipartFile file, String ftpPath, String dir) throws IOException {
        String fileType = FileUtils.getExtensionName((String)file.getOriginalFilename());
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)fileType);
        String fileName = FileUtils.getFileNameNoEx((String)file.getOriginalFilename());
        String[] fileNames = fileName.split("@@");
        String fileNewName = fileNames.length > 1 ? fileNames[0] + "@@" + fileInfoEntity.getFileName() : fileName + "@@" + fileInfoEntity.getFileName();
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath + "/" + fileNewName;
        File dest = new File(filePath);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = file.getInputStream();
            os = new FileOutputStream(dest);
            int len = 0;
            byte[] buffer = new byte[0x100000];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            UploadEntity dto = new UploadEntity();
            dto.setFileName(file.getOriginalFilename());
            dto.setFileNewName(fileNewName);
            dto.setFilePath(fileDirPath + "/" + fileNewName);
            dto.setFileDirPath(fileDirPath);
            UploadEntity uploadEntity = dto;
            return uploadEntity;
        }
        catch (Exception ex) {
            throw new RenException(ex.getMessage());
        }
        finally {
            if (null != os) {
                os.close();
                os.flush();
            }
            if (null != is) {
                is.close();
            }
        }
    }

    public static void deleteFiles(List<String> filePathList, String ftpPath) {
        for (String filePath : filePathList) {
            File file = new File(ftpPath + "/" + filePath);
            if (!file.exists() || !file.isFile()) continue;
            file.delete();
        }
    }

    public static void deleteFile(String ftpPath) {
        File file = new File(ftpPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteDir(String path) throws IOException {
        File dest = new File(path);
        org.apache.commons.io.FileUtils.deleteDirectory((File)dest);
    }

    public static void createDir(String path) {
        File dest = new File(path);
        if (!dest.exists()) {
            dest.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadEntity base64ToImg(String base64, String ftpPath, String dir) {
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)"jpg");
        String fileNewName = fileInfoEntity.getFileName();
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath;
        String[] bases = base64.split(",");
        base64 = bases.length == 1 ? bases[0] : bases[1];
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] imageByte = null;
        try {
            imageByte = decoder.decodeBuffer(base64);
            for (int i = 0; i < imageByte.length; ++i) {
                if (imageByte[i] >= 0) continue;
                int n = i;
                imageByte[n] = (byte)(imageByte[n] + 256);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (imageByte.length > 0) {
            try {
                File destfile = new File(filePath);
                if (!destfile.exists()) {
                    destfile.mkdirs();
                }
                File f = new File(destfile.getAbsoluteFile() + "/" + fileNewName);
                ByteArrayInputStream in = new ByteArrayInputStream(imageByte);
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                int length = ((InputStream)in).read(buf, 0, buf.length);
                while (length != -1) {
                    fos.write(buf, 0, length);
                    length = in.read(buf);
                }
                fos.flush();
                fos.close();
                ((InputStream)in).close();
                UploadEntity dto = new UploadEntity();
                dto.setFilePath(fileDirPath + "/" + fileNewName);
                dto.setFileName(fileNewName);
                dto.setFileNewName(fileNewName);
                dto.setFileDirPath(fileDirPath);
                UploadEntity uploadEntity = dto;
                return uploadEntity;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static UploadEntity writeToFile(String content, String ftpPath, String dir, String fileName, String fileType) throws IOException {
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)fileType);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = fileInfoEntity.getFileName();
        }
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath + "/" + fileName;
        File dest = new File(filePath);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8), 8192);){
            writer.write(content);
            writer.flush();
        }
        UploadEntity dto = new UploadEntity();
        dto.setFilePath(fileDirPath + "/" + fileName);
        dto.setFileDirPath(fileDirPath);
        dto.setFileName(fileName);
        dto.setFileNewName(fileName);
        return dto;
    }

    public static String getFileContent(String path, String ftpPath) {
        Path filePath = Paths.get(ftpPath + "/" + path, new String[0]);
        try {
            return new String(Files.readAllBytes(filePath), "UTF-8");
        }
        catch (IOException e) {
            throw new RenException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToBase64(String path) {
        String base64 = null;
        InputStream in = null;
        try {
            File file = new File(path);
            in = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            in.read(bytes);
            base64 = new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return base64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadEntity base64ToFile(String base64, String fileType, String ftpPath, String dir) {
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)fileType);
        String fileNewName = fileInfoEntity.getFileName();
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath;
        String[] bases = base64.split(",");
        base64 = bases.length == 1 ? bases[0] : bases[1];
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] imageByte = null;
        try {
            imageByte = decoder.decodeBuffer(base64);
            for (int i = 0; i < imageByte.length; ++i) {
                if (imageByte[i] >= 0) continue;
                int n = i;
                imageByte[n] = (byte)(imageByte[n] + 256);
            }
            if (imageByte.length > 0) {
                File destfile = new File(filePath);
                if (!destfile.exists()) {
                    destfile.mkdirs();
                }
                File f = new File(destfile.getAbsoluteFile() + "/" + fileNewName);
                ByteArrayInputStream in = new ByteArrayInputStream(imageByte);
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                int length = ((InputStream)in).read(buf, 0, buf.length);
                while (length != -1) {
                    fos.write(buf, 0, length);
                    length = in.read(buf);
                }
                fos.flush();
                fos.close();
                ((InputStream)in).close();
                UploadEntity dto = new UploadEntity();
                dto.setFileDirPath(fileDirPath);
                dto.setFilePath(fileDirPath + "/" + fileNewName);
                dto.setFileName(fileNewName);
                UploadEntity uploadEntity = dto;
                return uploadEntity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void reWriteTxtContent(String ftpPath, String filePath, String content) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(ftpPath + "/" + filePath));){
            writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UploadEntity base64ToZip(String base64, String fileType, String ftpPath, String dir) {
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)fileType);
        String fileNewName = fileInfoEntity.getFileName();
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath;
        String[] bases = base64.split(",");
        base64 = bases.length == 1 ? bases[0] : bases[1];
        File destfile = new File(filePath);
        if (!destfile.exists()) {
            destfile.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(destfile.getAbsoluteFile() + "/" + fileNewName);){
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] decodedBytes = decoder.decodeBuffer(base64);
            fileOutputStream.write(decodedBytes);
            UploadEntity dto = new UploadEntity();
            dto.setFileDirPath(fileDirPath);
            dto.setFilePath(fileDirPath + "/" + fileNewName);
            dto.setFileName(fileNewName);
            UploadEntity uploadEntity = dto;
            return uploadEntity;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FileInfoEntity getFileDirPath(String dir, String fileType) {
        FileInfoEntity fileInfoEntity = new FileInfoEntity();
        String[] ymdPath = FileUtils.getYMDStr();
        fileInfoEntity.setFilePath(ymdPath[0] + "/" + ymdPath[0] + ymdPath[1] + "/" + ymdPath[0] + ymdPath[1] + ymdPath[2] + "/" + dir);
        fileInfoEntity.setFileName(ymdPath[0] + ymdPath[1] + ymdPath[2] + "_" + ymdPath[3] + ymdPath[4] + ymdPath[5] + "_" + ymdPath[6] + "." + fileType);
        return fileInfoEntity;
    }

    public static String getDcmFileDirPath(String modality, String aet, String patientId) {
        String[] ymdPath = FileUtils.getYMDStr();
        return modality + "/" + aet + "/" + ymdPath[0] + "/" + ymdPath[0] + ymdPath[1] + "/" + ymdPath[0] + ymdPath[1] + ymdPath[2] + "/" + patientId;
    }

    public static UploadEntity multiToFile(MultipartFile file, String ftpPath, String dir) throws IOException {
        String fileType = FileUtils.getExtensionName((String)file.getOriginalFilename());
        String fileName = FileUtils.getFileNameNoEx((String)file.getOriginalFilename());
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)fileType);
        String fileNewName = fileName + "@" + fileInfoEntity.getFileName();
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath + "/" + fileNewName;
        File dest = new File(filePath);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = file.getInputStream();
            os = new FileOutputStream(dest);
            int len = 0;
            byte[] buffer = new byte[0x100000];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            UploadEntity dto = new UploadEntity();
            dto.setFileName(file.getOriginalFilename());
            dto.setFileNewName(fileNewName);
            dto.setFilePath(fileDirPath + "/" + fileNewName);
            dto.setFileDirPath(fileDirPath);
            UploadEntity uploadEntity = dto;
            return uploadEntity;
        }
        catch (Exception ex) {
            throw new RenException(ex.getMessage());
        }
        finally {
            if (null != os) {
                os.close();
                os.flush();
            }
            if (null != is) {
                is.close();
            }
        }
    }

    public static UploadEntity uploadEmrPdf(MultipartFile file, String ftpPath, String dir) throws IOException {
        FileInfoEntity fileInfoEntity = FileUtils.getFileDirPath((String)dir, (String)"pdf");
        String fileNewName = fileInfoEntity.getFileName();
        String fileDirPath = fileInfoEntity.getFilePath();
        String filePath = ftpPath + "/" + fileDirPath + "/" + fileNewName;
        File dest = new File(filePath);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = file.getInputStream();
            os = new FileOutputStream(dest);
            int len = 0;
            byte[] buffer = new byte[0x100000];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            UploadEntity dto = new UploadEntity();
            dto.setFileName(fileNewName);
            dto.setFileNewName(fileNewName);
            dto.setFilePath(fileDirPath + "/" + fileNewName);
            dto.setFileDirPath(fileDirPath);
            UploadEntity uploadEntity = dto;
            return uploadEntity;
        }
        catch (Exception ex) {
            throw new RenException(ex.getMessage());
        }
        finally {
            if (null != os) {
                os.close();
                os.flush();
            }
            if (null != is) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToBase64Str(String filePath, String ftpPath) {
        File file = new File(ftpPath + "/" + filePath);
        if (file.exists()) {
            String base64Str = null;
            FileInputStream fin = null;
            BufferedInputStream bin = null;
            ByteArrayOutputStream baos = null;
            FilterOutputStream bout = null;
            try {
                fin = new FileInputStream(file);
                bin = new BufferedInputStream(fin);
                baos = new ByteArrayOutputStream();
                bout = new BufferedOutputStream(baos);
                byte[] buffer = new byte[1024];
                int len = bin.read(buffer);
                while (len != -1) {
                    ((BufferedOutputStream)bout).write(buffer, 0, len);
                    len = bin.read(buffer);
                }
                ((BufferedOutputStream)bout).flush();
                byte[] bytes = baos.toByteArray();
                base64Str = Base64.encodeBase64String((byte[])bytes);
            }
            catch (IOException e) {
                e.getMessage();
            }
            finally {
                try {
                    fin.close();
                    bin.close();
                    bout.close();
                }
                catch (IOException e) {
                    e.getMessage();
                }
            }
            return base64Str;
        }
        return null;
    }

    public static void moveFile(String sourcePath, String targetPath) {
        System.out.println("\u79fb\u52a8\u6587\u4ef6\uff0c" + sourcePath + " =====> " + targetPath);
        File sourceFile = new File(sourcePath);
        File targetFile = new File(targetPath);
        if (!sourceFile.isFile()) {
            System.out.println("\u6e90\u8def\u5f84\u4e0d\u662f\u6587\u4ef6\uff0c" + sourceFile.getPath());
            return;
        }
        if (!sourceFile.exists()) {
            System.out.println("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c" + sourceFile.getPath());
            return;
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        if (sourcePath.equalsIgnoreCase(targetPath)) {
            return;
        }
        try {
            Files.move(Paths.get(sourcePath, new String[0]), Paths.get(targetPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("\u6587\u4ef6\u79fb\u52a8\u6210\u529f\uff01" + sourcePath + " =====> " + targetPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String replaceEx(String fileName, String ex) {
        return fileName.substring(0, fileName.lastIndexOf(46)) + "." + ex;
    }
}

