/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import io.huimu.common.utils.DynamicColumnWidthStyleStrategy;
import io.huimu.modules.dict.vo.DictMenuFieldVO;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.springframework.cglib.beans.BeanMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicExcelUtils {
    public static <T> void export(HttpServletResponse response, String fileName, List<DictMenuFieldVO> fields, List<T> dataList) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        List head = DynamicExcelUtils.buildHead(fields);
        List data = DynamicExcelUtils.buildData(fields, dataList);
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        HorizontalCellStyleStrategy styleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(head)).registerWriteHandler((WriteHandler)styleStrategy)).registerWriteHandler((WriteHandler)new DynamicColumnWidthStyleStrategy())).sheet("\u68c0\u67e5\u9879\u76ee").doWrite(data);
    }

    private static List<List<String>> buildHead(List<DictMenuFieldVO> fields) {
        fields.sort((f1, f2) -> f1.getSortIndex().compareTo(f2.getSortIndex()));
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        for (DictMenuFieldVO field : fields) {
            head.add(Arrays.asList(field.getMessage()));
        }
        return head;
    }

    private static <T> List<List<Object>> buildData(List<DictMenuFieldVO> fields, List<T> dataList) {
        fields.sort((f1, f2) -> f1.getSortIndex().compareTo(f2.getSortIndex()));
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (T item : dataList) {
            ArrayList row = new ArrayList();
            BeanMap beanMap = BeanMap.create(item);
            for (DictMenuFieldVO field : fields) {
                row.add(beanMap.get(field.getFieldName()));
            }
            data.add(row);
        }
        return data;
    }
}

