/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.springframework.web.multipart.MultipartFile;

public class CustomMultipartFile
implements MultipartFile {
    private final File file;
    private final String contentType;

    public CustomMultipartFile(File file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getOriginalFilename() {
        return this.file.getName();
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    public long getSize() {
        return this.file.length();
    }

    public byte[] getBytes() throws IOException {
        return Files.readAllBytes(this.file.toPath());
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        Files.copy(this.file.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

