/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.zeissdcm.service.impl;

import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.register.param.UploadDcmParam;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.zeissdcm.dao.ZeissDcmDao;
import io.huimu.modules.zeissdcm.entity.ZeissDcmEntity;
import io.huimu.modules.zeissdcm.service.ZeissDcmService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ZeissDcmServiceImpl
extends BaseServiceImpl<ZeissDcmDao, ZeissDcmEntity>
implements ZeissDcmService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    @Async
    public void sendZeiss(String ftpPath, String dcmFilePath, UploadDcmParam param) {
        String sendUrl = this.sysSystemConfService.getConfValue("100046", null);
        if (StringUtils.isBlank((CharSequence)sendUrl)) {
            return;
        }
        ZeissDcmEntity entity = new ZeissDcmEntity();
        entity.setDcmZipPath(dcmFilePath);
        entity.setExamNo(param.getExamNo());
        entity.setPatientId(param.getPatientId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("patientId", param.getPatientId());
        params.put("examNo", param.getExamNo());
        params.put("deviceId", param.getDeviceId());
        params.put("fileBase", FileUtils.fileToBase64((String)(ftpPath + "/" + dcmFilePath)));
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity responseResult = null;
        try {
            responseResult = restTemplate.exchange(sendUrl, HttpMethod.POST, httpEntity, Result.class, new Object[0]);
            if (null != responseResult) {
                Result hisResponseEntity = (Result)responseResult.getBody();
                if (null != hisResponseEntity) {
                    int code = hisResponseEntity.getCode();
                    if (code == 0) {
                        entity.setSendFlag(Integer.valueOf(1));
                    } else {
                        entity.setSendFlag(Integer.valueOf(2));
                    }
                } else {
                    entity.setSendFlag(Integer.valueOf(2));
                }
            } else {
                entity.setSendFlag(Integer.valueOf(2));
            }
        }
        catch (Exception e) {
            entity.setSendFlag(Integer.valueOf(2));
            throw new RenException(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ".....\u5c06dcm\u6587\u4ef6\u8f6c\u53d1\u8521\u53f8\u5931\u8d25\uff1a\u4fe1\u606f\uff1a" + e.getMessage());
        }
        finally {
            entity.setSendTime(new Date());
            this.insert((Object)entity);
        }
    }
}

