/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.sys.dao.SysRoleMenuDao;
import io.huimu.modules.sys.entity.SysRoleMenuEntity;
import io.huimu.modules.sys.service.SysRoleMenuService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleMenuServiceImpl
extends BaseServiceImpl<SysRoleMenuDao, SysRoleMenuEntity>
implements SysRoleMenuService {
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(String roleId, List<String> menuIdList) {
        this.deleteByRoleIds(new String[]{roleId});
        if (CollUtil.isEmpty(menuIdList)) {
            return;
        }
        for (String menuId : menuIdList) {
            SysRoleMenuEntity sysRoleMenuEntity = new SysRoleMenuEntity();
            sysRoleMenuEntity.setMenuId(menuId);
            sysRoleMenuEntity.setRoleId(roleId);
            this.insert((Object)sysRoleMenuEntity);
        }
    }

    public List<String> getMenuIdList(String roleId) {
        return ((SysRoleMenuDao)this.baseDao).getMenuIdList(roleId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRoleIds(String[] roleIds) {
        ((SysRoleMenuDao)this.baseDao).deleteByRoleIds(roleIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByMenuId(String menuId) {
        ((SysRoleMenuDao)this.baseDao).deleteByMenuId(menuId);
    }
}

