/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.param.UserPageParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.ExcelUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dto.PasswordDTO;
import io.huimu.modules.sys.dto.SysUserDTO;
import io.huimu.modules.sys.dto.UnLockUserDTO;
import io.huimu.modules.sys.enums.UserStatusEnum;
import io.huimu.modules.sys.excel.SysUserExcel;
import io.huimu.modules.sys.param.GetDoctorParam;
import io.huimu.modules.sys.param.UserSearchParam;
import io.huimu.modules.sys.service.SysRoleUserService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import io.huimu.modules.sys.service.SysUserService;
import io.huimu.modules.sys.vo.DoctorVO;
import io.huimu.modules.sys.vo.SysUserVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/user"})
@Api(tags={"\u7528\u6237\u7ba1\u7406"})
public class SysUserController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRoleUserService sysRoleUserService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private SysUserDeptDataScopeService dataScopeService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=UserPageParam.class)
    public Result<PageData<SysUserVO>> page(@RequestBody EncryptedReq<UserPageParam> req) throws IllegalAccessException {
        PageData page = this.sysUserService.page((UserPageParam)req.getData());
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u5217\u8868--\u4e0d\u5206\u9875")
    @DecryptAndVerify(decryptedClass=UserSearchParam.class)
    public Result<List<SysUserVO>> getList(@RequestBody EncryptedReq<UserSearchParam> req) throws IllegalAccessException {
        List list = this.sysUserService.getList(MapUtils.object2Map((Object)req.getData()));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=UserSearchParam.class)
    public Result<SysUserDTO> getInfo(@RequestBody EncryptedReq<UserSearchParam> req) {
        UserSearchParam dto = (UserSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysUserDTO userDTO = this.sysUserService.getInfo(dto.getId());
        if (null != userDTO) {
            List roleIdList = this.sysRoleUserService.getRoleIdListByUserIdAndOrgCode(userDTO.getId(), dto.getOrgCode());
            userDTO.setRoleIdList(roleIdList);
            userDTO.setDefaultRoleId(this.sysRoleUserService.getDefaultRoleId(userDTO.getId(), dto.getOrgCode()));
            List dataScopeList = this.dataScopeService.getDeptDataScope(dto.getOrgCode(), dto.getId());
            userDTO.setDataScopeList(dataScopeList);
            return new Result().ok(req.getEncode(), (Object)userDTO);
        }
        return new Result();
    }

    @PostMapping(value={"info"})
    @ApiOperation(value="\u767b\u5f55\u7528\u6237\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<SysUserDTO> info(@RequestBody EncryptedReq<NoParam> req) {
        SysUserDTO data = (SysUserDTO)ConvertUtils.sourceToTarget((Object)SecurityUser.getUser(), SysUserDTO.class);
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"password"})
    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @LogOperation(value="\u4fee\u6539\u5bc6\u7801", module="\u7528\u6237\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=PasswordDTO.class)
    public Result password(@RequestBody EncryptedReq<PasswordDTO> req) {
        PasswordDTO dto = (PasswordDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.sysUserService.updatePassword(dto.getEmployeeId(), dto.getNewPassword());
        return new Result();
    }

    @PostMapping(value={"saveUser"})
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237")
    @LogOperation(value="\u65b0\u589e\u7528\u6237", module="\u7528\u6237\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SysUserDTO.class)
    public Result saveUser(@RequestBody EncryptedReq<SysUserDTO> req) {
        SysUserDTO dto = (SysUserDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        SysUserDTO dbUser = this.sysUserService.getByEmployeeId(dto.getEmployeeId());
        if (null != dbUser) {
            return new Result().error(this.sysSystemConfService.getConfValue("100006", "\u8d26\u53f7\u5df2\u5b58\u5728"));
        }
        this.sysUserService.saveUser(dto);
        return new Result();
    }

    @PostMapping(value={"unLockUser"})
    @ApiOperation(value="\u89e3\u9501\u7528\u6237")
    @LogOperation(value="\u89e3\u9501\u7528\u6237", module="\u7528\u6237\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=UnLockUserDTO.class)
    public Result unLockUser(@RequestBody EncryptedReq<UnLockUserDTO> req) {
        UnLockUserDTO dto = (UnLockUserDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysUserService.updatePwdErrorNumAndLockStatus(dto.getId(), Integer.valueOf(0), Integer.valueOf(UserStatusEnum.ENABLED.value()));
        return new Result();
    }

    @PostMapping(value={"updateUser"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237")
    @LogOperation(value="\u4fee\u6539\u7528\u6237", module="\u7528\u6237\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=SysUserDTO.class)
    public Result updateUser(@RequestBody EncryptedReq<SysUserDTO> req) {
        SysUserDTO dto = (SysUserDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        return this.sysUserService.updateUser(dto);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664\u7528\u6237", module="\u7528\u6237\u7ba1\u7406", operationType=3, logType=1)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.sysUserService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }

    @PostMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237")
    @LogOperation(value="\u5bfc\u51fa\u7528\u6237")
    public void export(HttpServletResponse response) throws Exception {
        List list = this.sysUserService.list(new UserPageParam());
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u7528\u6237\u7ba1\u7406", (List)list, SysUserExcel.class);
    }

    @PostMapping(value={"exportTemp"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f")
    @LogOperation(value="\u5bfc\u51fa\u6a21\u677f")
    public void exportTemp(HttpServletResponse response) throws Exception {
        ArrayList<SysUserDTO> list = new ArrayList<SysUserDTO>();
        SysUserDTO dto = new SysUserDTO();
        dto.setEmployeeId("12345");
        dto.setRealName("\u5f20\u4e09");
        dto.setGender("\u7537");
        dto.setEmail("123456@163.com");
        dto.setMobile("13800000000");
        list.add(dto);
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u7528\u6237\u7ba1\u7406", list, SysUserExcel.class);
    }

    @PostMapping(value={"importUserByExcel"})
    @ApiOperation(value="excel\u5bfc\u5165\u7528\u6237")
    @LogOperation(value="excel\u5bfc\u5165\u7528\u6237")
    public Result importUserByExcel(@RequestPart(value="file", required=true) MultipartFile file) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList list = new ArrayList();
        EasyExcel.read((InputStream)file.getInputStream(), SysUserExcel.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).doReadAll();
        return this.sysUserService.importUser(list);
    }

    @PostMapping(value={"getDoctorList"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetDoctorParam.class)
    public Result<List<DoctorVO>> getDoctorList(@RequestBody EncryptedReq<GetDoctorParam> req) {
        GetDoctorParam param = (GetDoctorParam)req.getData();
        AssertUtils.isBlank((String)param.getOrgCode(), (String[])new String[]{"\u673a\u6784code"});
        List resList = this.sysUserService.getDoctorList(param.getType(), param.getOrgCode());
        return new Result().ok((Object)resList);
    }

    @PostMapping(value={"test"})
    @ApiOperation(value="\u6d4b\u8bd5")
    public Result test() {
        String s = this.sysUserService.test();
        return new Result().ok((Object)s);
    }
}

