/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sqlexecute.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.HutoolSm4Utils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.sqlexecute.dto.EncodeOrDecodeDTO;
import io.huimu.modules.sqlexecute.entity.SqlExecuteEntity;
import io.huimu.modules.sqlexecute.param.GetSqlExecutePageParam;
import io.huimu.modules.sqlexecute.service.SqlExecuteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sql/execute"})
@Api(tags={"sql\u6587\u4ef6\u7ba1\u7406"})
public class SqlExecuteController {
    @Autowired
    private SqlExecuteService sqlExecuteService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetSqlExecutePageParam.class)
    public Result<PageData<SqlExecuteEntity>> page(@RequestBody EncryptedReq<GetSqlExecutePageParam> req) throws IllegalAccessException {
        GetSqlExecutePageParam params = (GetSqlExecutePageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.sqlExecuteService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"uploadFile"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20sql\u6587\u4ef6")
    @LogOperation(value="\u4e0a\u4f20sql\u6587\u4ef6", module="sql\u6587\u4ef6\u7ba1\u7406", operationType=1, logType=1)
    public Result uploadFile(@RequestPart(value="file") MultipartFile file) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sqlExecuteService.uploadFile(file);
        return new Result();
    }

    @PostMapping(value={"/executeSqlFile"})
    @ApiOperation(value="\u6267\u884csql\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result executeSqlFile(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.sqlExecuteService.executeSqlFile(dto.getId());
        return new Result();
    }

    @PostMapping(value={"encodeOrDecode"})
    @ApiOperation(value="\u5728\u7ebf\u52a0\u89e3\u5bc6")
    public Result getCaFlag(@RequestBody EncodeOrDecodeDTO dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        if (dto.getFlag() == 1) {
            return new Result().ok((Object)HutoolSm4Utils.decode((String)dto.getStr()));
        }
        if (dto.getFlag() == 2) {
            return new Result().ok((Object)HutoolSm4Utils.encode((String)dto.getStr()));
        }
        return new Result().error("\u53c2\u6570\u9519\u8bef");
    }
}

