/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.register.dto.RegisterTypeDTO;
import io.huimu.modules.register.param.GetRegisterTypeParam;
import io.huimu.modules.register.service.RegisterTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/register/type"})
@Api(tags={"\u767b\u8bb0\u7c7b\u578b\u7ba1\u7406"})
public class RegisterTypeController {
    @Autowired
    private RegisterTypeService registerTypeService;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e\u767b\u8bb0\u7c7b\u578b")
    @LogOperation(value="\u65b0\u589e\u767b\u8bb0\u7c7b\u578b", module="\u767b\u8bb0\u7c7b\u578b\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=RegisterTypeDTO.class)
    public Result save(@RequestBody EncryptedReq<RegisterTypeDTO> req) {
        RegisterTypeDTO dto = (RegisterTypeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.registerTypeService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u767b\u8bb0\u7c7b\u578b")
    @LogOperation(value="\u4fee\u6539\u767b\u8bb0\u7c7b\u578b", module="\u767b\u8bb0\u7c7b\u578b\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=RegisterTypeDTO.class)
    public Result update(@RequestBody EncryptedReq<RegisterTypeDTO> req) {
        RegisterTypeDTO dto = (RegisterTypeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.registerTypeService.update(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        RegisterTypeDTO typeDTO = this.registerTypeService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)typeDTO);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetRegisterTypeParam.class)
    public Result getList(@RequestBody EncryptedReq<GetRegisterTypeParam> req) {
        GetRegisterTypeParam dto = (GetRegisterTypeParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List typeDTO = this.registerTypeService.getList(dto.getTypeFlag(), dto.getTypeName());
        return new Result().ok(req.getEncode(), (Object)typeDTO);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u767b\u8bb0\u7c7b\u578b")
    @LogOperation(value="\u5220\u9664\u767b\u8bb0\u7c7b\u578b", module="\u767b\u8bb0\u7c7b\u578b\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result delete(@RequestBody EncryptedReq<ArraysParam> req) {
        ArraysParam dto = (ArraysParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.registerTypeService.delete(dto.getIds());
        return new Result();
    }
}

