/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.controller;

import com.alibaba.fastjson.JSON;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.register.dto.PauseUploadCjFilesDTO;
import io.huimu.modules.register.dto.PauseUploadVideoFilesDTO;
import io.huimu.modules.register.dto.SaveExamFilesDTO;
import io.huimu.modules.register.dto.UploadCjFilesDTO;
import io.huimu.modules.register.param.DeleteExamFilesParam;
import io.huimu.modules.register.param.GetCreateDcmXmlParam;
import io.huimu.modules.register.param.GetDataExtractPdfFileParam;
import io.huimu.modules.register.param.GetDeviceExamFileParam;
import io.huimu.modules.register.param.GetDevicePatientParam;
import io.huimu.modules.register.param.GetExamFileByExamNoPage;
import io.huimu.modules.register.param.GetExamNoParam;
import io.huimu.modules.register.param.GetRelieveExamFilesParam;
import io.huimu.modules.register.param.RelateDcmFilesParam;
import io.huimu.modules.register.param.RelateExamFilesParam;
import io.huimu.modules.register.param.RelieveDcmParam;
import io.huimu.modules.register.param.RelieveParam;
import io.huimu.modules.register.param.UploadDcmParam;
import io.huimu.modules.register.service.ExamFilesService;
import io.huimu.modules.register.vo.ExamFilesVO;
import io.huimu.modules.register.vo.GetExamNoVO;
import io.huimu.modules.register.vo.PatientInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/exam/file"})
@Api(tags={"\u68c0\u67e5\u62a5\u544a\u7ba1\u7406"})
public class ExamFilesController {
    @Autowired
    private ExamFilesService examFilesService;

    @PostMapping(value={"uploadPdfExamFiles"})
    @ApiOperation(value="\u4e0a\u4f20\u8bbe\u5907\u62a5\u544a")
    public Result uploadPdfExamFiles(@RequestBody SaveExamFilesDTO dto) {
        System.out.println("=============\u4e0a\u4f20\u8bbe\u5907\u62a5\u544a=============,\u8bbe\u5907ID:" + dto.getDeviceId() + ",\u68c0\u67e5\u53f7\uff1a" + dto.getExamNo() + ",\u539f\u59cb\u8def\u5f84" + dto.getFileSourcePath());
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examFilesService.uploadPdfExamFiles(dto);
        return new Result();
    }

    @PostMapping(value={"uploadDcmExamFiles"})
    @ApiOperation(value="\u4e0a\u4f20\u8bbe\u5907\u5f71\u50cf\u6587\u4ef6")
    public Result uploadDcmExamFiles(UploadDcmParam dto) throws IOException {
        System.out.println("=============\u4e0a\u4f20\u8bbe\u5907\u5f71\u50cf\u6587\u4ef6=============,\u8bbe\u5907ID:" + dto.getDeviceId() + ",\u68c0\u67e5\u53f7\uff1a" + dto.getExamNo() + ",\u4e0a\u4f20\u6807\u5fd7\u4f4d\uff1a" + dto.getUploadFlag() + ",\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f" + dto.getZipFile().getSize());
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        System.out.println("\u901a\u8fc7\u53c2\u6570\u6821\u9a8c");
        this.examFilesService.uploadDcmExamFiles(dto);
        return new Result();
    }

    @PostMapping(value={"getExamNo"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u53f7")
    public Result getExamNo(@RequestBody GetExamNoParam dto) {
        System.out.println("=============getExamNo=============" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        GetExamNoVO examNo = this.examFilesService.getExamNo(dto);
        System.out.println("=============getExamNo=============" + JSON.toJSONString((Object)dto) + "\uff0c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)examNo));
        return new Result().ok((Object)examNo);
    }

    @PostMapping(value={"getDevicePatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u60a3\u8005\u57fa\u672c\u4fe1\u606f")
    public Result getDevicePatientInfo(@RequestBody GetDevicePatientParam dto) {
        System.out.println("=============getDevicePatientInfo=============" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        PatientInfoVO vo = this.examFilesService.getDevicePatientInfo(dto);
        return new Result().ok((Object)vo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"getCreateDcmXml"})
    @ApiOperation(value="\u83b7\u53d6\u751f\u6210dcm\u7684xml\u6587\u4ef6")
    public Result getCreateDcmXml(@RequestBody GetCreateDcmXmlParam dto) {
        System.out.println("=============\u83b7\u53d6\u751f\u6210dcm\u7684xml\u6587\u4ef6=============" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        if (StringUtils.isNotBlank((CharSequence)dto.getFileNameIn())) {
            dto.getFileNameIn().replace("\\", "/");
        }
        if (null != dto.getConvertType()) return new Result().ok((Object)this.examFilesService.getCreateDcmXml(dto));
        if (!StringUtils.isNotBlank((CharSequence)dto.getFileNameIn())) throw new RenException("\u8f6c\u6362\u7c7b\u578b\u548c\u8f93\u5165\u6587\u4ef6\u8def\u5f84\u81f3\u5c11\u4f20\u4e00\u4e2a");
        String extensionName = FileUtils.getExtensionName((String)dto.getFileNameIn());
        if (!StringUtils.isNotBlank((CharSequence)extensionName)) throw new RenException("\u8f93\u5165\u6587\u4ef6\u8def\u5f84\u540e\u7f00\u540d\u6709\u8bef");
        if (StringUtils.upperCase((String)extensionName).equalsIgnoreCase("PDF")) {
            dto.setConvertType(Integer.valueOf(2000));
            return new Result().ok((Object)this.examFilesService.getCreateDcmXml(dto));
        } else {
            dto.setConvertType(Integer.valueOf(1000));
        }
        return new Result().ok((Object)this.examFilesService.getCreateDcmXml(dto));
    }

    @PostMapping(value={"getCreateDcmXmlPc"})
    @ApiOperation(value="web\u7aef\uff0c\u83b7\u53d6\u751f\u6210dcm\u7684xml\u6587\u4ef6")
    public Result getCreateDcmXmlPc(@RequestBody EncryptedReq<GetCreateDcmXmlParam> req) {
        GetCreateDcmXmlParam dto = (GetCreateDcmXmlParam)req.getData();
        System.out.println("=============web\u7aef\uff0c\u83b7\u53d6\u751f\u6210dcm\u7684xml\u6587\u4ef6=============" + JSON.toJSONString((Object)dto));
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        if (null == dto.getConvertType()) {
            throw new RenException("\u8f6c\u6362\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new Result().ok(req.getEncode(), (Object)this.examFilesService.getCreateDcmXml(dto));
    }

    @PostMapping(value={"relieve"})
    @ApiOperation(value="\u89e3\u9664\u68c0\u67e5\u6587\u4ef6\u4e0e\u68c0\u67e5\u9879\u76ee\u7684\u5173\u7cfb")
    @DecryptAndVerify(decryptedClass=RelieveParam.class)
    @LogOperation(value="\u89e3\u9664\u68c0\u67e5\u6587\u4ef6\u4e0e\u68c0\u67e5\u9879\u76ee\u7684\u5173\u7cfb", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=3)
    public Result relieve(@RequestBody EncryptedReq<RelieveParam> req) {
        RelieveParam dto = (RelieveParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examFilesService.relieve(dto);
        return new Result();
    }

    @PostMapping(value={"getRelieveExamFiles"})
    @ApiOperation(value="\u83b7\u53d6\u89e3\u9664\u5173\u7cfb\u7684PDF\u68c0\u67e5\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=GetRelieveExamFilesParam.class)
    public Result getRelieveExamFiles(@RequestBody EncryptedReq<GetRelieveExamFilesParam> req) throws IllegalAccessException {
        GetRelieveExamFilesParam dto = (GetRelieveExamFilesParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List examFilesVOList = this.examFilesService.getRelieveExamFiles(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)examFilesVOList);
    }

    @PostMapping(value={"getDeviceExamFileByExamNo"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u53f7\u83b7\u53d6\u8bbe\u5907\u539f\u59cb\u6587\u4ef6--\u62a5\u544a\u5339\u914d\u7528")
    @DecryptAndVerify(decryptedClass=GetDeviceExamFileParam.class)
    public Result getDeviceExamFileByExamNo(@RequestBody EncryptedReq<GetDeviceExamFileParam> req) {
        GetDeviceExamFileParam dto = (GetDeviceExamFileParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List examFilesVOList = this.examFilesService.getDeviceExamFileByExamNo(dto.getExamNo());
        return new Result().ok(req.getEncode(), (Object)examFilesVOList);
    }

    @PostMapping(value={"getRelieveDcmExamFileByExamNo"})
    @ApiOperation(value="\u83b7\u53d6\u89e3\u9664\u5173\u7cfb\u7684DCM--DCM\u5339\u914d\u7528")
    @DecryptAndVerify(decryptedClass=GetRelieveExamFilesParam.class)
    public Result getRelieveDcmExamFileByExamNo(@RequestBody EncryptedReq<GetRelieveExamFilesParam> req) throws IllegalAccessException {
        GetRelieveExamFilesParam dto = (GetRelieveExamFilesParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List examFilesVOList = this.examFilesService.getRelieveDcmExamFileByExamNo(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)examFilesVOList);
    }

    @PostMapping(value={"getDeviceDcmExamFileByExamNo"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u53f7\u83b7\u53d6\u8bbe\u5907\u539f\u59cbDCM\u6587\u4ef6--DCM\u5339\u914d\u7528")
    @DecryptAndVerify(decryptedClass=GetDeviceExamFileParam.class)
    public Result getDeviceDcmExamFileByExamNo(@RequestBody EncryptedReq<GetDeviceExamFileParam> req) {
        GetDeviceExamFileParam dto = (GetDeviceExamFileParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List examFilesVOList = this.examFilesService.getDeviceDcmExamFileByExamNo(dto.getExamNo());
        return new Result().ok(req.getEncode(), (Object)examFilesVOList);
    }

    @PostMapping(value={"relieveDcm"})
    @ApiOperation(value="\u89e3\u9664dcm\u4e0e\u68c0\u67e5\u9879\u76ee\u7684\u5173\u7cfb")
    @DecryptAndVerify(decryptedClass=RelieveDcmParam.class)
    @LogOperation(value="\u89e3\u9664dcm\u4e0e\u68c0\u67e5\u9879\u76ee\u7684\u5173\u7cfb", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=3)
    public Result relieveDcm(@RequestBody EncryptedReq<RelieveDcmParam> req) {
        RelieveDcmParam dto = (RelieveDcmParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examFilesService.relieveDcm(dto);
        return new Result();
    }

    @PostMapping(value={"relateDcmFiles"})
    @ApiOperation(value="\u5173\u8054DCM\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=RelateDcmFilesParam.class)
    @LogOperation(value="\u5173\u8054DCM\u6587\u4ef6", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=2)
    public Result relateDcmFiles(@RequestBody EncryptedReq<RelateDcmFilesParam> req) {
        RelateDcmFilesParam dto = (RelateDcmFilesParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examFilesService.relateDcmFiles(dto);
        return new Result();
    }

    @PostMapping(value={"getExamFileByExamNo"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u53f7\u83b7\u53d6\u539f\u59cb\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    @DecryptAndVerify(decryptedClass=GetExamFileByExamNoPage.class)
    public Result<PageData<List<List<ExamFilesVO>>>> getExamFileByExamNo(@RequestBody EncryptedReq<GetExamFileByExamNoPage> req) {
        GetExamFileByExamNoPage dto = (GetExamFileByExamNoPage)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        PageData examFilesVOList = this.examFilesService.getExamFileByExamNo(dto);
        return new Result().ok(req.getEncode(), (Object)examFilesVOList);
    }

    @PostMapping(value={"relateExamFiles"})
    @ApiOperation(value="\u5173\u8054\u68c0\u67e5\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=RelateExamFilesParam.class)
    @LogOperation(value="\u5173\u8054\u68c0\u67e5\u6587\u4ef6", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=2)
    public Result relateExamFiles(@RequestBody EncryptedReq<RelateExamFilesParam> req) {
        RelateExamFilesParam dto = (RelateExamFilesParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examFilesService.relateExamFiles(dto);
        return new Result();
    }

    @PostMapping(value={"deleteExamFiles"})
    @ApiOperation(value="\u5220\u9664\u68c0\u67e5\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=DeleteExamFilesParam.class)
    @LogOperation(value="\u5220\u9664\u68c0\u67e5\u6587\u4ef6", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=3)
    public Result deleteExamFiles(@RequestBody EncryptedReq<DeleteExamFilesParam> req) {
        DeleteExamFilesParam dto = (DeleteExamFilesParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examFilesService.deleteExamFiles(dto.getRecId());
        return new Result();
    }

    @PostMapping(value={"pauseUploadCjFiles"})
    @ApiOperation(value="\u6682\u5b58\u91c7\u96c6\u7684\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    public Result pauseUploadCjFiles(@RequestBody EncryptedReq<PauseUploadCjFilesDTO> req) {
        PauseUploadCjFilesDTO dto = (PauseUploadCjFilesDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examFilesService.pauseUploadCjFiles(dto);
        return new Result();
    }

    @PostMapping(value={"pauseUploadCjMulti"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u6682\u5b58\u624b\u52a8\u9009\u62e9\u7684\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    public Result pauseUploadCjMulti(@RequestPart(value="file") MultipartFile file, @RequestPart(value="examNo") String examNo, @RequestPart(value="deviceId") String deviceId, @RequestPart(value="orgCode") String orgCode) throws IOException {
        AssertUtils.isNull((Object)file, (String[])new String[]{"\u6587\u4ef6"});
        AssertUtils.isNull((Object)examNo, (String[])new String[]{"\u68c0\u67e5\u53f7"});
        AssertUtils.isNull((Object)deviceId, (String[])new String[]{"\u8bbe\u5907ID"});
        AssertUtils.isNull((Object)orgCode, (String[])new String[]{"\u673a\u6784\u53f7"});
        this.examFilesService.pauseUploadCjMulti(file, examNo, deviceId, orgCode);
        return new Result();
    }

    @PostMapping(value={"pauseUploadVideoFiles"})
    @ApiOperation(value="\u6682\u5b58\u91c7\u96c6\u7684\u89c6\u9891\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    public Result pauseUploadVideoFiles(PauseUploadVideoFilesDTO dto) throws IOException {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examFilesService.pauseUploadVideoFiles(dto);
        return new Result();
    }

    @PostMapping(value={"cancelUploadCjFiles"})
    @ApiOperation(value="\u53d6\u6d88\u4e0a\u4f20\u91c7\u96c6\u7684\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    @DecryptAndVerify(decryptedClass=UploadCjFilesDTO.class)
    @LogOperation(value="\u53d6\u6d88\u4e0a\u4f20\u91c7\u96c6\u7684\u6587\u4ef6", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=2)
    public Result cancelUploadCjFiles(@RequestBody EncryptedReq<UploadCjFilesDTO> req) {
        UploadCjFilesDTO dto = (UploadCjFilesDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examFilesService.cancelUploadCjFiles(dto);
        return new Result();
    }

    @PostMapping(value={"uploadCjFiles"})
    @ApiOperation(value="\u4e0a\u4f20\u91c7\u96c6\u7684\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    @DecryptAndVerify(decryptedClass=UploadCjFilesDTO.class)
    @LogOperation(value="\u4e0a\u4f20\u91c7\u96c6\u7684\u6587\u4ef6", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=1)
    public Result uploadCjFiles(@RequestBody EncryptedReq<UploadCjFilesDTO> req) {
        UploadCjFilesDTO dto = (UploadCjFilesDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.examFilesService.uploadCjFiles(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"deleteCjFiles"})
    @ApiOperation(value="\u5220\u9664\u91c7\u96c6\u7684\u6587\u4ef6--\u4e8c\u6b21\u7f16\u8f91\u7528")
    @DecryptAndVerify(decryptedClass=UploadCjFilesDTO.class)
    @LogOperation(value="\u5220\u9664\u91c7\u96c6\u7684\u6587\u4ef6", module="\u68c0\u67e5\u62a5\u544a\u7ba1\u7406", operationType=3)
    public Result deleteCjFiles(@RequestBody EncryptedReq<UploadCjFilesDTO> req) {
        UploadCjFilesDTO dto = (UploadCjFilesDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examFilesService.deleteCjFiles(dto);
        return new Result();
    }

    @PostMapping(value={"getDataExtractPdfFile"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6838\u67e5pdf\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=GetDataExtractPdfFileParam.class)
    public Result getDataExtractPdfFile(@RequestBody EncryptedReq<GetDataExtractPdfFileParam> req) {
        GetDataExtractPdfFileParam dto = (GetDataExtractPdfFileParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.examFilesService.getDataExtractPdfFile(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getDataExtractDcmFile"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6838\u67e5DCM\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=GetDataExtractPdfFileParam.class)
    public Result getDataExtractDcmFile(@RequestBody EncryptedReq<GetDataExtractPdfFileParam> req) {
        GetDataExtractPdfFileParam dto = (GetDataExtractPdfFileParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.examFilesService.getDataExtractDcmFile(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

