/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patientset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.patientset.dao.PatientSetDao;
import io.huimu.modules.patientset.dto.PatientSetDTO;
import io.huimu.modules.patientset.entity.PatientSetEntity;
import io.huimu.modules.patientset.service.PatientSetService;
import io.huimu.modules.security.user.SecurityUser;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PatientSetServiceImpl
extends BaseServiceImpl<PatientSetDao, PatientSetEntity>
implements PatientSetService {
    public void save(PatientSetDTO dto) {
        PatientSetEntity entity = (PatientSetEntity)ConvertUtils.sourceToTarget((Object)dto, PatientSetEntity.class);
        entity.setCreateDate(new Date());
        entity.setCreateUserName(SecurityUser.getUser().getRealName());
        entity.setUpdateDate(new Date());
        entity.setUpdateUserName(SecurityUser.getUser().getRealName());
        this.insert((Object)entity);
    }

    public void update(PatientSetDTO dto) {
        PatientSetEntity entity = (PatientSetEntity)ConvertUtils.sourceToTarget((Object)dto, PatientSetEntity.class);
        entity.setUpdateDate(new Date());
        entity.setUpdateUserName(SecurityUser.getUser().getRealName());
        this.updateById((Object)entity);
    }

    public PageData<PatientSetDTO> page(Map<String, Object> params) {
        IPage page = ((PatientSetDao)this.baseDao).selectPage(this.getPage(params, "create_date", false), (Wrapper)this.getWrapper(params));
        return this.getPageData(page, PatientSetDTO.class);
    }

    private QueryWrapper<PatientSetEntity> getWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = new QueryWrapper();
        String patientId = (String)params.get("patientId");
        wrapper.eq(StringUtils.isNotBlank((CharSequence)patientId), (Object)"patient_id", (Object)patientId);
        return wrapper;
    }
}

