/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patientcollect.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.patientcollect.dto.PatientCollectDTO;
import io.huimu.modules.patientcollect.dto.PatientCollectTreeDTO;
import io.huimu.modules.patientcollect.param.GetTreeParam;
import io.huimu.modules.patientcollect.service.PatientCollectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patient/collect"})
@Api(tags={"\u60a3\u8005\u6536\u85cf\u7ba1\u7406"})
public class PatientCollectController {
    @Autowired
    private PatientCollectService patientCollectService;

    @PostMapping(value={"/addTree"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u4fee\u6539\u6811\u7ed3\u6784")
    @LogOperation(value="\u6dfb\u52a0\u6216\u4fee\u6539\u6811\u7ed3\u6784", module="\u60a3\u8005\u6536\u85cf\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=PatientCollectTreeDTO.class)
    public Result addTree(@RequestBody EncryptedReq<PatientCollectTreeDTO> req) {
        PatientCollectTreeDTO dto = (PatientCollectTreeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.patientCollectService.addTree(dto);
        return new Result();
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u7ed3\u6784\u6811")
    @DecryptAndVerify(decryptedClass=GetTreeParam.class)
    public Result getTree(@RequestBody EncryptedReq<GetTreeParam> req) {
        GetTreeParam param = (GetTreeParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List resList = this.patientCollectService.getTree(param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"/deleteTree"})
    @ApiOperation(value="\u5220\u9664\u6811\u7ed3\u6784")
    @LogOperation(value="\u5220\u9664\u6811\u7ed3\u6784", module="\u60a3\u8005\u6536\u85cf\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deleteTree(@RequestBody EncryptedReq<IdParam> req) {
        IdParam idParam = (IdParam)req.getData();
        AssertUtils.isBlank((String)idParam.getId(), (String[])new String[]{"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u8282\u70b9"});
        this.patientCollectService.deleteTree(idParam.getId());
        return new Result();
    }

    @PostMapping(value={"/collectPatient"})
    @ApiOperation(value="\u6536\u85cf\u60a3\u8005")
    @LogOperation(value="\u6536\u85cf\u60a3\u8005", module="\u60a3\u8005\u6536\u85cf\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=PatientCollectDTO.class)
    public Result collectPatient(@RequestBody EncryptedReq<PatientCollectDTO> req) {
        PatientCollectDTO dto = (PatientCollectDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.patientCollectService.collectPatient(dto);
        return new Result();
    }

    @PostMapping(value={"/deletePatient"})
    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf\u60a3\u8005")
    @LogOperation(value="\u53d6\u6d88\u6536\u85cf\u60a3\u8005", module="\u60a3\u8005\u6536\u85cf\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deletePatient(@RequestBody EncryptedReq<IdParam> req) {
        IdParam idParam = (IdParam)req.getData();
        AssertUtils.isBlank((String)idParam.getId(), (String[])new String[]{"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u60a3\u8005"});
        this.patientCollectService.deletePatient(idParam.getId());
        return new Result();
    }

    @PostMapping(value={"/getPatientList"})
    @ApiOperation(value="\u83b7\u53d6\u6536\u85cf\u7684\u60a3\u8005\u5217\u8868")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getPatientList(@RequestBody EncryptedReq<IdParam> req) {
        IdParam idParam = (IdParam)req.getData();
        AssertUtils.isBlank((String)idParam.getId(), (String[])new String[]{"\u8bf7\u9009\u62e9\u83b7\u53d6\u60a3\u8005\u7684\u8282\u70b9"});
        List resList = this.patientCollectService.getPatientList(idParam.getId());
        return new Result().ok(req.getEncode(), (Object)resList);
    }
}

