/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.littlecheck.dto.SaveShiLiDTO;
import io.huimu.modules.littlecheck.dto.SaveYanGuangDTO;
import io.huimu.modules.littlecheck.dto.SaveYanYaDTO;
import io.huimu.modules.littlecheck.dto.XjcPatientDTO;
import io.huimu.modules.littlecheck.param.DelExamDataParam;
import io.huimu.modules.littlecheck.param.GetExamDataParam;
import io.huimu.modules.littlecheck.param.GetShiLiByDateParam;
import io.huimu.modules.littlecheck.param.GetYanGuangByDateParam;
import io.huimu.modules.littlecheck.param.GetYanYaByDateParam;
import io.huimu.modules.littlecheck.param.XjcPatientParam;
import io.huimu.modules.littlecheck.service.LittleCheckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/little/check"})
@Api(tags={"\u5e38\u89c4\u68c0\u67e5\u7ba1\u7406"})
public class LittleCheckController {
    @Autowired
    private LittleCheckService littleCheckService;

    @PostMapping(value={"getXjcPatientList"})
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u68c0\u67e5\u60a3\u8005\u5217\u8868")
    @DecryptAndVerify(decryptedClass=XjcPatientParam.class)
    public Result<List<XjcPatientDTO>> getXjcPatientList(@RequestBody EncryptedReq<XjcPatientParam> req) {
        XjcPatientParam dto = (XjcPatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        if (dto.getDataType() == 3 && StringUtils.isBlank((CharSequence)dto.getYgType())) {
            return new Result().error("\u9a8c\u5149\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.littleCheckService.getXjcPatientList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"saveYanYaData"})
    @ApiOperation(value="\u4fdd\u5b58\u773c\u538b\u6570\u636e")
    @LogOperation(value="\u4fdd\u5b58\u773c\u538b\u6570\u636e", module="\u5e38\u89c4\u68c0\u67e5", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveYanYaDTO.class)
    public Result saveYanYaData(@RequestBody EncryptedReq<SaveYanYaDTO> req) throws IllegalAccessException {
        SaveYanYaDTO dto = (SaveYanYaDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.littleCheckService.saveYanYaData(dto);
        return new Result();
    }

    @PostMapping(value={"saveYanGuangData"})
    @ApiOperation(value="\u4fdd\u5b58\u9a8c\u5149\u6570\u636e")
    @LogOperation(value="\u4fdd\u5b58\u9a8c\u5149\u6570\u636e", module="\u5e38\u89c4\u68c0\u67e5", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveYanGuangDTO.class)
    public Result saveYanGuangData(@RequestBody EncryptedReq<SaveYanGuangDTO> req) throws IllegalAccessException {
        SaveYanGuangDTO dto = (SaveYanGuangDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.littleCheckService.saveYanGuangData(dto);
        return new Result();
    }

    @PostMapping(value={"saveShiLiData"})
    @ApiOperation(value="\u4fdd\u5b58\u89c6\u529b\u6570\u636e")
    @LogOperation(value="\u4fdd\u5b58\u89c6\u529b\u6570\u636e", module="\u5e38\u89c4\u68c0\u67e5", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveShiLiDTO.class)
    public Result saveShiLiData(@RequestBody EncryptedReq<SaveShiLiDTO> req) throws IllegalAccessException {
        SaveShiLiDTO dto = (SaveShiLiDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.littleCheckService.saveShiLiData(dto);
        return new Result();
    }

    @PostMapping(value={"getExamDataList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetExamDataParam.class)
    public Result<List<LinkedHashMap<String, String>>> getExamDataList(@RequestBody EncryptedReq<GetExamDataParam> req) {
        GetExamDataParam dto = (GetExamDataParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.littleCheckService.getExamDataList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"delExamData"})
    @ApiOperation(value="\u5220\u9664\u68c0\u67e5\u6570\u636e")
    @DecryptAndVerify(decryptedClass=DelExamDataParam.class)
    @LogOperation(value="\u5220\u9664\u68c0\u67e5\u6570\u636e", module="\u5e38\u89c4\u68c0\u67e5", operationType=3)
    public Result delExamData(@RequestBody EncryptedReq<DelExamDataParam> req) throws IllegalAccessException {
        DelExamDataParam dto = (DelExamDataParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.littleCheckService.delExamData(dto);
    }

    @PostMapping(value={"getShiLiByDate"})
    @ApiOperation(value="\u6839\u636e\u65e5\u671f\u83b7\u53d6\u89c6\u529b\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetShiLiByDateParam.class)
    public Result getShiLiByDate(@RequestBody EncryptedReq<GetShiLiByDateParam> req) {
        GetShiLiByDateParam dto = (GetShiLiByDateParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return new Result().ok(req.getEncode(), (Object)this.littleCheckService.getShiLiByDate(dto));
    }

    @PostMapping(value={"getYanYaByDate"})
    @ApiOperation(value="\u6839\u636e\u65e5\u671f\u83b7\u53d6\u773c\u538b\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetYanYaByDateParam.class)
    public Result getYanYaByDate(@RequestBody EncryptedReq<GetYanYaByDateParam> req) {
        GetYanYaByDateParam dto = (GetYanYaByDateParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return new Result().ok(req.getEncode(), (Object)this.littleCheckService.getYanYaByDate(dto));
    }

    @PostMapping(value={"getYanGuangByDate"})
    @ApiOperation(value="\u6839\u636e\u65e5\u671f\u83b7\u53d6\u9a8c\u5149\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetYanGuangByDateParam.class)
    public Result getYanGuangByDate(@RequestBody EncryptedReq<GetYanGuangByDateParam> req) {
        GetYanGuangByDateParam dto = (GetYanGuangByDateParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return new Result().ok(req.getEncode(), (Object)this.littleCheckService.getYanGuangByDate(dto));
    }
}

