/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.examdatabrowse.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.examdatabrowse.param.GetBrowsePatientParam;
import io.huimu.modules.examdatabrowse.param.GetExamFileParam;
import io.huimu.modules.examdatabrowse.param.GetExamItemParam;
import io.huimu.modules.examdatabrowse.service.ExamDataBrowseService;
import io.huimu.modules.examdatabrowse.vo.BrowsePatientVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exam/data/browse"})
@Api(tags={"\u68c0\u67e5\u6570\u636e\u6d4f\u89c8"})
public class ExamDataBrowseController {
    @Autowired
    private ExamDataBrowseService browseService;

    @PostMapping(value={"getBrowsePatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetBrowsePatientParam.class)
    public Result<BrowsePatientVO> getBrowsePatientInfo(@RequestBody EncryptedReq<GetBrowsePatientParam> req) {
        GetBrowsePatientParam data = (GetBrowsePatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[0]);
        if (StringUtils.isBlank((CharSequence)data.getPatientId()) && StringUtils.isBlank((CharSequence)data.getPatientIdNumber())) {
            throw new RenException("\u75c5\u5386\u53f7\u548c\u8eab\u4efd\u8bc1\u81f3\u5c11\u4f20\u4e00\u4e2a");
        }
        BrowsePatientVO vo = this.browseService.getBrowsePatientInfo(data);
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"getExamItem"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u6811\u5f62\u7ed3\u6784")
    @DecryptAndVerify(decryptedClass=GetExamItemParam.class)
    public Result getExamItem(@RequestBody EncryptedReq<GetExamItemParam> req) {
        GetExamItemParam data = (GetExamItemParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[0]);
        if (StringUtils.isBlank((CharSequence)data.getPatientId()) && StringUtils.isBlank((CharSequence)data.getPatientIdNumber())) {
            throw new RenException("\u75c5\u5386\u53f7\u548c\u8eab\u4efd\u8bc1\u81f3\u5c11\u4f20\u4e00\u4e2a");
        }
        List list = this.browseService.getExamItem(data);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getExamFiles"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u62a5\u544a\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=GetExamFileParam.class)
    public Result getExamFiles(@RequestBody EncryptedReq<GetExamFileParam> req) {
        GetExamFileParam dto = (GetExamFileParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        if (StringUtils.isBlank((CharSequence)dto.getPatientId()) && StringUtils.isBlank((CharSequence)dto.getPatientIdNumber())) {
            throw new RenException("\u75c5\u5386\u53f7\u548c\u8eab\u4efd\u8bc1\u81f3\u5c11\u4f20\u4e00\u4e2a");
        }
        List list = this.browseService.getExamFiles(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

