/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.modules.dict.dao.DictTransmitJarMapper;
import io.huimu.modules.dict.dto.DictTransmitJarDTO;
import io.huimu.modules.dict.entity.DictTransmitJarEntity;
import io.huimu.modules.dict.service.DictTransmitJarService;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictTransmitJarServiceImpl
extends BaseServiceImpl<DictTransmitJarMapper, DictTransmitJarEntity>
implements DictTransmitJarService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public PageData<DictTransmitJarDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"fileName", "jarVersion"});
        String pid = params.get("pid").toString();
        int flag = Integer.parseInt(params.get("flag").toString());
        String jarVersion = (String)params.get("jarVersion");
        String fileName = (String)params.get("fileName");
        IPage page = ((DictTransmitJarMapper)this.baseDao).selectPage(this.getPage(params, null, true), (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)pid)).eq((Object)"flag", (Object)flag)).like(StringUtils.isNotBlank((CharSequence)jarVersion), (Object)"JAR_VERSION", (Object)jarVersion)).like(StringUtils.isNotBlank((CharSequence)fileName), (Object)"FILE_NAME", (Object)fileName)).orderByDesc((Object)"JAR_VERSION"));
        return this.getPageData(page, DictTransmitJarDTO.class);
    }

    public void pushVersion(DictTransmitJarDTO dto) throws IOException {
        DictTransmitJarEntity entity = new DictTransmitJarEntity();
        if (dto.getIsOpen() == 1) {
            entity = new DictTransmitJarEntity();
            entity.setIsOpen(Integer.valueOf(0));
            entity.setFlag(dto.getFlag());
            this.update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)dto.getPid())).eq((Object)"flag", (Object)dto.getFlag()));
        }
        entity = new DictTransmitJarEntity();
        entity.setPid(dto.getPid());
        entity.setCategory(dto.getCategory());
        entity.setFileName(dto.getFileName());
        entity.setFilePath(dto.getFilePath());
        entity.setUpdateTime(new Date());
        entity.setUploadTime(new Date());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setJarVersion(dto.getJarVersion());
        entity.setFlag(dto.getFlag());
        this.insert((Object)entity);
    }

    public void updateVersion(DictTransmitJarDTO dto) {
        DictTransmitJarEntity dbEntity = (DictTransmitJarEntity)((DictTransmitJarMapper)this.baseDao).selectById((Serializable)((Object)dto.getId()));
        if (null != dbEntity) {
            DictTransmitJarEntity entity;
            if (dto.getIsOpen() == 1) {
                entity = new DictTransmitJarEntity();
                entity.setIsOpen(Integer.valueOf(0));
                this.update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)dbEntity.getPid())).eq((Object)"flag", (Object)dto.getFlag()));
            }
            entity = (DictTransmitJarEntity)ConvertUtils.sourceToTarget((Object)dto, DictTransmitJarEntity.class);
            entity.setFilePath(null);
            entity.setFlag(null);
            entity.setUpdateTime(new Date());
            this.updateById((Object)entity);
        }
    }

    public DictTransmitJarDTO getInfo(String id) {
        DictTransmitJarEntity entity = (DictTransmitJarEntity)((DictTransmitJarMapper)this.baseDao).selectById((Serializable)((Object)id));
        return (DictTransmitJarDTO)ConvertUtils.sourceToTarget((Object)entity, DictTransmitJarDTO.class);
    }

    public void changeStatus(ChangeOpenParam data) {
        DictTransmitJarEntity dbEntity = (DictTransmitJarEntity)((DictTransmitJarMapper)this.baseDao).selectById((Serializable)((Object)data.getId()));
        if (null != dbEntity) {
            DictTransmitJarEntity entity = new DictTransmitJarEntity();
            if (data.getIsOpen() == 1) {
                entity = new DictTransmitJarEntity();
                entity.setIsOpen(Integer.valueOf(0));
                this.update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pid", (Object)dbEntity.getPid())).eq((Object)"flag", (Object)data.getFlag()));
            }
            entity = new DictTransmitJarEntity();
            entity.setIsOpen(data.getIsOpen());
            entity.setId(data.getId());
            this.updateById((Object)entity);
        }
    }

    public String getJarContent(String id) {
        DictTransmitJarEntity entity = (DictTransmitJarEntity)((DictTransmitJarMapper)this.baseDao).selectById((Serializable)((Object)id));
        if (entity == null) {
            return null;
        }
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        return FileUtils.fileToBase64((String)(ftpPath + "/" + entity.getFilePath()));
    }

    public List<DictTransmitJarDTO> getJarList(String deviceId, Integer flag, Integer isOpen) {
        return ((DictTransmitJarMapper)this.baseDao).getJarList(deviceId, flag, isOpen);
    }
}

