/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.dict.dao.DictStandardNameDao;
import io.huimu.modules.dict.dto.DictStandardNameDTO;
import io.huimu.modules.dict.entity.DictStandardNameEntity;
import io.huimu.modules.dict.service.DictStandardKnowService;
import io.huimu.modules.dict.service.DictStandardNameService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictStandardNameServiceImpl
extends BaseServiceImpl<DictStandardNameDao, DictStandardNameEntity>
implements DictStandardNameService {
    @Autowired
    private DictStandardKnowService standardKnowService;

    public PageData<DictStandardNameDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"standardName", "knowName"});
        IPage page = this.getPage(params, "", false);
        List list = ((DictStandardNameDao)this.baseDao).getList(params);
        List resList = ConvertUtils.sourceToTarget((Collection)list, DictStandardNameDTO.class);
        for (DictStandardNameDTO dto : resList) {
            if (!StringUtils.isNotBlank((CharSequence)dto.getStandardCode())) continue;
            dto.setKnowNameList(this.standardKnowService.getKnowNames(dto.getStandardCode()));
        }
        return this.getPageData(resList, page.getTotal(), DictStandardNameDTO.class);
    }

    public List<DictStandardNameDTO> getList() {
        List list = ((DictStandardNameDao)this.baseDao).getList(new HashMap());
        return ConvertUtils.sourceToTarget((Collection)list, DictStandardNameDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(DictStandardNameDTO dto) {
        DictStandardNameEntity entity = (DictStandardNameEntity)ConvertUtils.sourceToTarget((Object)dto, DictStandardNameEntity.class);
        this.insert((Object)entity);
        this.standardKnowService.saveOrUpdate(entity.getStandardCode(), dto.getKnowIds());
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(DictStandardNameDTO dto) {
        DictStandardNameEntity entity = (DictStandardNameEntity)ConvertUtils.sourceToTarget((Object)dto, DictStandardNameEntity.class);
        this.update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"STANDARD_CODE", (Object)dto.getStandardCode()));
        this.standardKnowService.saveOrUpdate(entity.getStandardCode(), dto.getKnowIds());
    }

    public DictStandardNameDTO getInfo(String standardCode) {
        DictStandardNameEntity entity = ((DictStandardNameDao)this.baseDao).getInfo(standardCode);
        DictStandardNameDTO dto = (DictStandardNameDTO)ConvertUtils.sourceToTarget((Object)entity, DictStandardNameDTO.class);
        if (null != dto) {
            dto.setKnowIds(this.standardKnowService.getKnowIds(standardCode));
            dto.setKnowNameList(this.standardKnowService.getKnowNames(standardCode));
        }
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDel(String[] ids) {
        ((DictStandardNameDao)this.baseDao).delete((Wrapper)new QueryWrapper().in((Object)"STANDARD_CODE", (Object[])ids));
        this.standardKnowService.batchDelByStandardIds(Arrays.asList(ids));
    }

    public List<String> getExamModalityList() {
        return ((DictStandardNameDao)this.baseDao).getExamModalityList();
    }
}

