/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.dict.dao.DictItemRealAddressDao;
import io.huimu.modules.dict.dto.DictExamAddressDTO;
import io.huimu.modules.dict.entity.DictItemRealAddressEntity;
import io.huimu.modules.dict.service.DictItemRealAddressService;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictItemRealAddressServiceImpl
extends BaseServiceImpl<DictItemRealAddressDao, DictItemRealAddressEntity>
implements DictItemRealAddressService {
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(String orgCode, String examineCode, List<String> examAddressIdList) {
        ((DictItemRealAddressDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"EXAM_CODE", (Object)examineCode));
        if (CollUtil.isNotEmpty(examAddressIdList)) {
            for (String addressId : examAddressIdList) {
                DictItemRealAddressEntity entity = new DictItemRealAddressEntity();
                entity.setAddressId(addressId);
                entity.setExamCode(examineCode);
                entity.setOrgCode(orgCode);
                entity.setCreateDate(new Date());
                this.insert((Object)entity);
            }
        }
    }

    public List<String> getAddressIdList(String orgCode, String examineCode) {
        return ((DictItemRealAddressDao)this.baseDao).getAddressIdList(orgCode, examineCode);
    }

    public void deleteRelation(String orgCode, String examineCode) {
        ((DictItemRealAddressDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"EXAM_CODE", (Object)examineCode));
    }

    public List<DictExamAddressDTO> getAddressList(String orgCode, String examineCode) {
        return ((DictItemRealAddressDao)this.baseDao).getAddressList(orgCode, examineCode);
    }
}

