/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.dict.dto.DictTransmitDto;
import io.huimu.modules.dict.param.GetTransmitInfoParam;
import io.huimu.modules.dict.service.DictTransmitService;
import io.huimu.modules.dict.vo.DictTransmitVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transmit/config"})
@Api(tags={"\u4e00\u952e\u4f20\u8f93\u672c\u5730\u914d\u7f6e"})
public class DictTransmitController {
    @Autowired
    private DictTransmitService transmitService;

    @PostMapping(value={"saveOrUpdate"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539")
    @LogOperation(value="\u65b0\u589e", module="\u4e00\u952e\u4f20\u8f93\u672c\u5730\u914d\u7f6e", operationType=1)
    @DecryptAndVerify(decryptedClass=DictTransmitDto.class)
    public Result save(@RequestBody EncryptedReq<DictTransmitDto> req) {
        DictTransmitDto dto = (DictTransmitDto)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.transmitService.saveOrUpdate(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetTransmitInfoParam.class)
    public Result getInfo(@RequestBody EncryptedReq<GetTransmitInfoParam> req) {
        GetTransmitInfoParam param = (GetTransmitInfoParam)req.getData();
        if (StringUtils.isBlank((CharSequence)param.getDeviceId()) && StringUtils.isBlank((CharSequence)param.getLocalIp())) {
            return new Result().error("\u7f3a\u5c11\u8bbe\u5907id\u6216\u672c\u5730ip\u6761\u4ef6");
        }
        DictTransmitVO vo = this.transmitService.getInfo(param);
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u4e00\u952e\u4f20\u8f93\u672c\u5730\u914d\u7f6e", operationType=3)
    public Result batchDel(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.transmitService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }
}

