/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.dict.entity.DictIcdEntity;
import io.huimu.modules.dict.param.IcdPageParam;
import io.huimu.modules.dict.service.DictIcdService;
import io.huimu.modules.sys.param.ExportIcdParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/icd"})
@Api(tags={"icd\u5b57\u5178"})
public class DictIcdController {
    @Autowired
    private DictIcdService dictIcdService;

    @PostMapping(value={"exportData2Db"})
    @ApiOperation(value="\u8bfb\u53d6excel\u6570\u636e\u5bfc\u5165\u6570\u636e\u5e93")
    @DecryptAndVerify(decryptedClass=ExportIcdParam.class)
    public Result exportData2Db(@RequestBody EncryptedReq<ExportIcdParam> req) {
        ExportIcdParam param = (ExportIcdParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        this.dictIcdService.exportData2Db(param.getFilePath(), param.getFlag());
        return new Result();
    }

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=IcdPageParam.class)
    public Result<PageData<DictIcdEntity>> page(@RequestBody EncryptedReq<IcdPageParam> req) throws IllegalAccessException {
        IcdPageParam dto = (IcdPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        PageData page = this.dictIcdService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }
}

