/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.batchdown.config;

import io.huimu.modules.batchdown.vo.PatientExamFilesVO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;

public class DownLoadThread
implements Runnable {
    private final CountDownLatch countDownLatch;
    private final String filePath;
    private final List<PatientExamFilesVO> examFilesVO;

    public DownLoadThread(CountDownLatch countDownLatch, String filePath, List<PatientExamFilesVO> examFilesVO) {
        this.countDownLatch = countDownLatch;
        this.filePath = filePath;
        this.examFilesVO = examFilesVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            for (int i = 0; i < this.examFilesVO.size(); ++i) {
                PatientExamFilesVO vo = (PatientExamFilesVO)this.examFilesVO.get(i);
                String filePath = this.filePath + vo.getExamDate() + "/" + vo.getExamItemName() + "/";
                File file = new File(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                try {
                    FileUtils.copyURLToFile((URL)new URL(vo.getFilePath()), (File)new File(filePath + vo.getFileName()));
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.countDownLatch.countDown();
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

