/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.common.aspect;

import com.alibaba.fastjson.JSON;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.HutoolSm4Utils;
import io.huimu.modules.sys.service.SysSystemConfService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=0)
public class DecryptAndVerifyAspect {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    @Pointcut(value="@annotation(io.huimu.common.annotation.DecryptAndVerify)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object Around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        if (null != args && args.length != 0) {
            EncryptedReq encryptedReq = null;
            for (Object obj : args) {
                if (!(obj instanceof EncryptedReq)) continue;
                encryptedReq = (EncryptedReq)obj;
                break;
            }
            if (encryptedReq == null) {
                throw new Exception(joinPoint.getSignature().getName() + "\uff0c\u53c2\u6570\u4e2d\u65e0\u5f85\u89e3\u5bc6\u7c7b");
            }
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            DecryptAndVerify annotation = methodSignature.getMethod().getAnnotation(DecryptAndVerify.class);
            if (annotation == null || annotation.decryptedClass() == null) {
                throw new RenException(joinPoint.getSignature().getName() + "\uff0c\u672a\u6307\u5b9a\u89e3\u5bc6\u7c7b\u578b");
            }
            String i = this.sysSystemConfService.getConfValue("100025", "0");
            if (i.equalsIgnoreCase("1")) {
                String decryptedData = this.decodeData(encryptedReq);
                encryptedReq.setData(JSON.parseObject((String)decryptedData, (Class)annotation.decryptedClass()));
            }
        }
        return joinPoint.proceed();
    }

    private String decodeData(EncryptedReq encryptedReq) {
        return HutoolSm4Utils.decode((String)encryptedReq.getEncryptedData());
    }
}

