/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.wx.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.LocalCacheUtil;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.wx.entity.WxPushLogEntity;
import io.huimu.modules.wx.param.WxParam;
import io.huimu.modules.wx.service.WxOpenIdService;
import io.huimu.modules.wx.service.WxPushLogService;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WxService {
    public static final String WEB_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=APPSECRET&code=CODE&grant_type=authorization_code";
    public static final String USERINFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
    public static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
    public static final String SEND_MESSAGE_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=ACCESS_TOKEN";
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private WxPushLogService wxPushLogService;
    @Value(value="${hospitalCode}")
    private String hospitalCode;
    @Autowired
    private WxOpenIdService wxOpenIdService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void sendMessage(String messageId, Map<String, WxParam> paramMap, String patientIdNumber, String detailUrl, Integer sendType, String title, String xjName) {
        String openId = this.wxOpenIdService.getOpenIdByPatientIdNumber(patientIdNumber);
        if (StringUtils.isBlank((CharSequence)openId)) {
            System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + "\uff0c\u5fae\u4fe1\u672a\u53d1\u9001\uff0c\u8eab\u4efd\u8bc1\uff1a" + patientIdNumber + "\uff0copenid\u4e3a\u7a7a");
            return;
        }
        String appid = this.sysSystemConfService.getConfValue("100042", null);
        String appSecret = this.sysSystemConfService.getConfValue("100043", null);
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)appSecret)) {
            throw new RenException("\u5fae\u4fe1\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        JSONObject pushParam = new JSONObject();
        pushParam.put("touser", (Object)openId);
        pushParam.put("template_id", (Object)messageId);
        if (StringUtils.isNotBlank((CharSequence)detailUrl)) {
            pushParam.put("url", (Object)detailUrl);
        }
        pushParam.put("data", paramMap);
        WxPushLogEntity pushLogEntity = new WxPushLogEntity();
        pushLogEntity.setPatientIdNumber(patientIdNumber);
        pushLogEntity.setWxParam(JsonUtils.toJsonString((Object)pushParam));
        pushLogEntity.setSendUrl(detailUrl);
        pushLogEntity.setSendType(sendType);
        pushLogEntity.setPushDate(new Date());
        pushLogEntity.setName(title);
        pushLogEntity.setXjName(xjName);
        String requestUrl = SEND_MESSAGE_URL.replace("ACCESS_TOKEN", this.getToken());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)pushParam, (MultiValueMap)headers);
        ResponseEntity responseResult = null;
        try {
            responseResult = this.getRestTemplate().exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (null != responseResult) {
                String resString = (String)responseResult.getBody();
                if (StringUtils.isNotBlank((CharSequence)resString)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)resString);
                    if (null != jsonObject) {
                        String errcode = jsonObject.getString("errcode");
                        if (errcode.equalsIgnoreCase("0")) {
                            pushLogEntity.setStatus(Integer.valueOf(1));
                            pushLogEntity.setMessage("\u63a8\u9001\u6210\u529f");
                        } else {
                            pushLogEntity.setStatus(Integer.valueOf(2));
                            pushLogEntity.setMessage(jsonObject.getString("errmsg"));
                        }
                    }
                } else {
                    pushLogEntity.setStatus(Integer.valueOf(2));
                    pushLogEntity.setMessage("\u63a8\u9001\u5fae\u4fe1\u6d88\u606f\uff0c\u8fd4\u56de\u4e3a\u7a7a");
                }
            } else {
                pushLogEntity.setStatus(Integer.valueOf(2));
                pushLogEntity.setMessage("\u63a8\u9001\u5fae\u4fe1\u6d88\u606f,\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            pushLogEntity.setStatus(Integer.valueOf(2));
            pushLogEntity.setMessage(e.getMessage());
        }
        finally {
            this.wxPushLogService.insert((Object)pushLogEntity);
        }
    }

    public String getWebAccessTokenAndOpenid(String code) {
        String appid = this.sysSystemConfService.getConfValue("100042", null);
        String appSecret = this.sysSystemConfService.getConfValue("100043", null);
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)appSecret)) {
            throw new RenException("\u5fae\u4fe1\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseResult = null;
        String requestUrl = WEB_ACCESS_TOKEN_URL.replace("APPID", appid).replace("APPSECRET", appSecret).replace("CODE", code);
        try {
            responseResult = this.getRestTemplate().exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (null != responseResult) {
                String resString = (String)responseResult.getBody();
                JSONObject hisResponseEntity = JSON.parseObject((String)resString);
                if (null != hisResponseEntity) {
                    String result = hisResponseEntity.getString("openid");
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        return result;
                    }
                    throw new RenException("\u83b7\u53d6\u7528\u6237openid\u5931\u8d25:" + JsonUtils.toJsonString((Object)hisResponseEntity));
                }
                throw new RenException("\u83b7\u53d6\u7528\u6237openid\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            throw new RenException("\u83b7\u53d6\u7528\u6237openid\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
        }
        catch (Exception e) {
            throw new RenException(e.getMessage());
        }
    }

    public String getToken() {
        String appid = this.sysSystemConfService.getConfValue("100042", null);
        String appSecret = this.sysSystemConfService.getConfValue("100043", null);
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)appSecret)) {
            throw new RenException("\u5fae\u4fe1\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String accessToken = LocalCacheUtil.get((String)"wxAccessToken");
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            System.out.println("\u83b7\u53d6\u5fae\u4fe1accessToken:" + accessToken);
            return this.cstoken(accessToken, appid, appSecret);
        }
        return this.getWxToken(appid, appSecret);
    }

    public String cstoken(String accessToken, String appid, String appSecret) {
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("172.30.201.22", 12001)));
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        String url = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=" + accessToken;
        String response = (String)restTemplate.getForObject(url, String.class, new Object[0]);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.get((Object)"errcode") == null) {
            return accessToken;
        }
        return this.getWxToken(appid, appSecret);
    }

    public String getWxToken(String appid, String appSecret) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "text/plain");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseResult = null;
        String requestUrl = ACCESS_TOKEN_URL.replace("APPID", appid).replace("APPSECRET", appSecret);
        try {
            responseResult = this.getRestTemplate().exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (null != responseResult) {
                JSONObject hisResponseEntity = JSON.parseObject((String)((String)responseResult.getBody()));
                if (null != hisResponseEntity) {
                    String accessToken = hisResponseEntity.getString("access_token");
                    if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                        LocalCacheUtil.put((String)"wxAccessToken", (String)accessToken, (long)6000L);
                        System.out.println("\u83b7\u53d6\u5fae\u4fe1accessToken:" + accessToken);
                        return accessToken;
                    }
                    throw new RenException("\u83b7\u53d6\u5fae\u4fe1token\u5931\u8d25:" + JsonUtils.toJsonString((Object)hisResponseEntity));
                }
                throw new RenException("\u83b7\u53d6\u5fae\u4fe1token\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            throw new RenException("\u83b7\u53d6\u5fae\u4fe1token\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
        }
        catch (Exception e) {
            throw new RenException(e.getMessage());
        }
    }

    public Map<String, WxParam> getSendWxMsgParam(String hospitalName, String patientName, String remark) {
        HashMap<String, WxParam> paramMap = new HashMap<String, WxParam>();
        if (this.hospitalCode.equalsIgnoreCase("LOCAL")) {
            paramMap.put("first", new WxParam("\u533b\u5631\u4fe1\u606f\u63a8\u9001"));
            paramMap.put("keyword1", new WxParam(hospitalName));
            paramMap.put("keyword2", new WxParam(patientName));
            paramMap.put("keyword3", new WxParam(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + (StringUtils.isNotBlank((CharSequence)remark) ? "\uff0c\u5185\u5bb9\uff1a" + remark : "")));
            paramMap.put("remark", new WxParam(remark));
        } else if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
            paramMap.put("first", new WxParam("\u533b\u5631\u4fe1\u606f\u63a8\u9001"));
            paramMap.put("keyword1", new WxParam(hospitalName));
            paramMap.put("keyword2", new WxParam(patientName));
            paramMap.put("keyword3", new WxParam(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + (StringUtils.isNotBlank((CharSequence)remark) ? "\uff0c\u5185\u5bb9\uff1a" + remark : "")));
            paramMap.put("remark", new WxParam(remark));
        }
        return paramMap;
    }

    private RestTemplate getRestTemplate() {
        RestTemplate restTemplate = null;
        if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
            restTemplate = new RestTemplate();
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("172.30.201.22", 12001)));
            restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        } else {
            restTemplate = new RestTemplate();
        }
        return restTemplate;
    }
}

