/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.visit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.visit.dao.VisitDao;
import io.huimu.modules.visit.dto.add.AddVisitDTO;
import io.huimu.modules.visit.dto.update.UpdateVisitDTO;
import io.huimu.modules.visit.entity.VisitEntity;
import io.huimu.modules.visit.service.VisitService;
import io.huimu.modules.visit.vo.VisitInfoVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisitServiceImpl
extends BaseServiceImpl<VisitDao, VisitEntity>
implements VisitService {
    public PageData<VisitInfoVO> page(Map<String, Object> params) {
        IPage page = ((VisitDao)this.baseDao).selectPage(this.getPage(params, "create_date", false), (Wrapper)this.getWrapper(params));
        PageData pageData = this.getPageData(page, VisitInfoVO.class);
        return pageData;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result save(AddVisitDTO dto) {
        VisitEntity entity = (VisitEntity)ConvertUtils.sourceToTarget((Object)dto, VisitEntity.class);
        this.insert((Object)entity);
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public Result update(UpdateVisitDTO dto) {
        VisitEntity entity = (VisitEntity)ConvertUtils.sourceToTarget((Object)dto, VisitEntity.class);
        this.updateById((Object)entity);
        return new Result();
    }

    public VisitInfoVO getInfo(String id) {
        VisitEntity entity = (VisitEntity)this.selectById((Serializable)((Object)id));
        return (VisitInfoVO)ConvertUtils.sourceToTarget((Object)entity, VisitInfoVO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        ((VisitDao)this.baseDao).deleteById((Serializable)((Object)id));
    }

    public List<VisitInfoVO> getList(String orgCode) {
        List list = ((VisitDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)orgCode), (Object)"org_code", (Object)orgCode)).orderByAsc((Object)"create_date"));
        return ConvertUtils.sourceToTarget((Collection)list, VisitInfoVO.class);
    }

    private QueryWrapper<VisitEntity> getWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = new QueryWrapper();
        String orgCode = (String)params.get("orgCode");
        String name = (String)params.get("name");
        wrapper.eq(StringUtils.isNotBlank((CharSequence)orgCode), (Object)"org_code", (Object)orgCode);
        wrapper.like(StringUtils.isNotBlank((CharSequence)name), (Object)"name", (Object)name);
        return wrapper;
    }
}

