/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dao.SysTemplateDao;
import io.huimu.modules.sys.dto.SysTemplateDTO;
import io.huimu.modules.sys.entity.SysTemplateEntity;
import io.huimu.modules.sys.param.GetTemplateListParam;
import io.huimu.modules.sys.service.SysTemplateService;
import io.huimu.modules.sys.vo.SysTemplateVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysTemplateServiceImpl
extends BaseServiceImpl<SysTemplateDao, SysTemplateEntity>
implements SysTemplateService {
    public void saveTemplate(SysTemplateDTO dto) {
        SysTemplateEntity entity = (SysTemplateEntity)ConvertUtils.sourceToTarget((Object)dto, SysTemplateEntity.class);
        entity.setUpdateCode(SecurityUser.getUser().getEmployeeId());
        entity.setUpdateName(SecurityUser.getUser().getRealName());
        entity.setUpdateDate(new Date());
        this.insert((Object)entity);
    }

    public void updateTemplate(SysTemplateDTO dto) {
        SysTemplateEntity entity = (SysTemplateEntity)ConvertUtils.sourceToTarget((Object)dto, SysTemplateEntity.class);
        entity.setUpdateCode(SecurityUser.getUser().getEmployeeId());
        entity.setUpdateName(SecurityUser.getUser().getRealName());
        entity.setUpdateDate(new Date());
        this.updateById((Object)entity);
    }

    public List<SysTemplateVO> getListByType(GetTemplateListParam dto) {
        List list = ((SysTemplateDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE", (Object)dto.getType())).eq((Object)"IS_TITLE", (Object)1)).eq(dto.getType() == 2, (Object)"update_code", (Object)SecurityUser.getEmployeeId())).orderByAsc((Object)"SORT_INDEX")).orderByDesc((Object)"UPDATE_DATE"));
        ConvertUtils.sourceToTarget((Collection)list, SysTemplateDTO.class);
        return TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)list, SysTemplateVO.class));
    }

    @Transactional(rollbackFor={Exception.class})
    public Result delete(String id) {
        this.recursionDelete(Arrays.asList(id));
        return new Result();
    }

    private void recursionDelete(List<String> ids) {
        ((SysTemplateDao)this.baseDao).deleteBatchIds(ids);
        List childrenIds = ((SysTemplateDao)this.baseDao).getChildrenIds(ids);
        if (!CollUtil.isNotEmpty((Collection)childrenIds)) {
            return;
        }
        this.recursionDelete(childrenIds);
    }

    public List<SysTemplateDTO> getListByPid(String pid) {
        List list = ((SysTemplateDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PID", (Object)pid)).eq((Object)"IS_TITLE", (Object)2)).orderByAsc((Object)"SORT_INDEX")).orderByDesc((Object)"UPDATE_DATE"));
        return ConvertUtils.sourceToTarget((Collection)list, SysTemplateDTO.class);
    }

    public List<SysTemplateVO> getListAllByType(Integer type) {
        List patentList = ((SysTemplateDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE", (Object)type)).eq(type == 2, (Object)"UPDATE_CODE", (Object)SecurityUser.getUser().getEmployeeId())).orderByAsc((Object)"SORT_INDEX")).orderByDesc((Object)"UPDATE_DATE"));
        List dtoList = ConvertUtils.sourceToTarget((Collection)patentList, SysTemplateVO.class);
        return TreeUtils.build((List)dtoList);
    }
}

