/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.sys.dao.SysOrganDao;
import io.huimu.modules.sys.dto.SysOrgenDTO;
import io.huimu.modules.sys.entity.SysOrganEntity;
import io.huimu.modules.sys.service.SysDeptService;
import io.huimu.modules.sys.service.SysOrganService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysOrganServiceImpl
extends BaseServiceImpl<SysOrganDao, SysOrganEntity>
implements SysOrganService {
    @Autowired
    private SysDeptService sysDeptService;

    public PageData<SysOrganEntity> page(Map<String, Object> params) {
        IPage page = this.getPage(params, "create_date", false);
        List list = ((SysOrganDao)this.baseDao).page(params);
        return new PageData(list, page.getTotal());
    }

    public SysOrganEntity getOrganById(String id) {
        return (SysOrganEntity)((SysOrganDao)this.baseDao).selectById((Serializable)((Object)id));
    }

    public void saveOrgan(SysOrgenDTO dto) {
        Integer count = ((SysOrganDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)dto.getOrgCode()));
        if (count > 0) {
            throw new RenException("\u673a\u6784code\u5df2\u5b58\u5728");
        }
        SysOrganEntity sysOrganEntity = (SysOrganEntity)ConvertUtils.sourceToTarget((Object)dto, SysOrganEntity.class);
        ((SysOrganDao)this.baseDao).insert((Object)sysOrganEntity);
    }

    public void updateOrgan(SysOrgenDTO dto) {
        SysOrganEntity sysOrganEntity = (SysOrganEntity)ConvertUtils.sourceToTarget((Object)dto, SysOrganEntity.class);
        sysOrganEntity.setOrgCode(null);
        sysOrganEntity.setCreateDate(new Date());
        ((SysOrganDao)this.baseDao).updateById((Object)sysOrganEntity);
    }

    public void deleteOrgan(String id) {
        SysOrganEntity entity = (SysOrganEntity)((SysOrganDao)this.baseDao).selectById((Serializable)((Object)id));
        if (null != entity) {
            Integer count = this.sysDeptService.selectCountByOrgCode(entity.getOrgCode());
            if (count > 0) {
                throw new RenException(10014);
            }
            ((SysOrganDao)this.baseDao).deleteById((Serializable)((Object)id));
        }
    }

    public List<SysOrganEntity> getAllList(Map<String, Object> params) {
        String orgCode = (String)params.get("orgCode");
        return ((SysOrganDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq(StringUtils.isNotBlank((CharSequence)orgCode), (Object)"ORG_CODE", (Object)orgCode)).orderByAsc((Object)"SORT_INDEX"));
    }

    public String getYtCodeByCode(String orgCode) {
        return ((SysOrganDao)this.baseDao).getYtCodeByCode(orgCode);
    }

    public SysOrganEntity getOrganByCode(String orgCode) {
        return (SysOrganEntity)((SysOrganDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)orgCode));
    }
}

