/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.security.user.UserDetail;
import io.huimu.modules.sys.dao.SysMenuDao;
import io.huimu.modules.sys.dao.SysRoleDao;
import io.huimu.modules.sys.dto.SysMenuChildDTO;
import io.huimu.modules.sys.dto.SysMenuDTO;
import io.huimu.modules.sys.entity.SysMenuEntity;
import io.huimu.modules.sys.entity.SysRoleEntity;
import io.huimu.modules.sys.enums.SuperAdminEnum;
import io.huimu.modules.sys.service.SysMenuChildService;
import io.huimu.modules.sys.service.SysMenuService;
import io.huimu.modules.sys.service.SysRoleMenuService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuServiceImpl
extends BaseServiceImpl<SysMenuDao, SysMenuEntity>
implements SysMenuService {
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysRoleDao sysRoleDao;
    @Autowired
    private SysMenuDao sysMenuDao;
    @Autowired
    private SysMenuChildService sysMenuChildService;

    public SysMenuDTO getInfo(String id) {
        SysMenuEntity entity = ((SysMenuDao)this.baseDao).getById(id);
        SysMenuDTO dto = (SysMenuDTO)ConvertUtils.sourceToTarget((Object)entity, SysMenuDTO.class);
        if (null != dto) {
            dto.setMenuChildCodeList(this.sysMenuChildService.getMenuChildCodeList(dto.getId()));
        }
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveMenu(SysMenuDTO dto) {
        SysMenuEntity entity = (SysMenuEntity)ConvertUtils.sourceToTarget((Object)dto, SysMenuEntity.class);
        this.insert((Object)entity);
        this.sysMenuChildService.saveOrUpdate(entity.getId(), dto.getMenuChildCodeList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateMenu(SysMenuDTO dto) {
        SysMenuEntity entity = (SysMenuEntity)ConvertUtils.sourceToTarget((Object)dto, SysMenuEntity.class);
        if (entity.getId().equals(entity.getPid())) {
            throw new RenException(10012);
        }
        this.updateById((Object)entity);
        this.sysMenuChildService.saveOrUpdate(entity.getId(), dto.getMenuChildCodeList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        this.deleteById((Serializable)((Object)id));
        this.sysRoleMenuService.deleteByMenuId(id);
        this.sysMenuChildService.saveOrUpdate(id, null);
    }

    public List<SysMenuDTO> getAllMenuList(Integer type, String roleId) {
        List menuList = SecurityUser.getUser().getSuperAdmin().intValue() == SuperAdminEnum.YES.value() ? ((SysMenuDao)this.baseDao).getMenuList(type) : ((SysMenuDao)this.baseDao).getRoleMenuList(type, roleId);
        List dtoList = ConvertUtils.sourceToTarget((Collection)menuList, SysMenuDTO.class);
        return TreeUtils.build((List)dtoList, (String)"0");
    }

    public List<SysMenuDTO> getRoleMenuList(UserDetail user, Integer type, String roleId) {
        List menuList = user.getSuperAdmin().intValue() == SuperAdminEnum.YES.value() ? ((SysMenuDao)this.baseDao).getMenuList(type) : ((SysMenuDao)this.baseDao).getRoleMenuList(type, roleId);
        List dtoList = ConvertUtils.sourceToTarget((Collection)menuList, SysMenuDTO.class);
        return TreeUtils.build((List)dtoList);
    }

    public Map<String, Object> getDefaultRoleMenuList(UserDetail user, Integer type, String roleId) {
        List menuList;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultUrl", null);
        map.put("defaultMenuId", null);
        if (user.getSuperAdmin().intValue() == SuperAdminEnum.YES.value()) {
            menuList = ((SysMenuDao)this.baseDao).getMenuList(type);
        } else {
            menuList = ((SysMenuDao)this.baseDao).getRoleMenuList(type, roleId);
            SysRoleEntity entity = (SysRoleEntity)this.sysRoleDao.selectById((Serializable)((Object)roleId));
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getDefaultUrl())) {
                SysMenuEntity sysMenu = (SysMenuEntity)this.sysMenuDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"URL", (Object)entity.getDefaultUrl()));
                if (sysMenu != null) {
                    map.put("defaultMenuId", sysMenu.getId());
                }
                map.put("defaultUrl", entity.getDefaultUrl());
            }
        }
        List dtoList = ConvertUtils.sourceToTarget((Collection)menuList, SysMenuDTO.class);
        map.put("menuList", TreeUtils.build((List)dtoList));
        return map;
    }

    public List<SysMenuDTO> getListPid(String pid) {
        List menuList = ((SysMenuDao)this.baseDao).getListPid(pid);
        return ConvertUtils.sourceToTarget((Collection)menuList, SysMenuDTO.class);
    }

    public List<SysMenuDTO> getAllList() {
        List list = ((SysMenuDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"type", (Object)0)).orderByAsc((Object)"SORT"));
        return TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)list, SysMenuDTO.class));
    }

    public List<SysMenuChildDTO> getChildMenuById(String menuId) {
        List result = ((SysMenuDao)this.baseDao).getChildMenuById(menuId);
        return result;
    }
}

