/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.sys.dao.SysMenuChildDao;
import io.huimu.modules.sys.entity.SysMenuChildEntity;
import io.huimu.modules.sys.service.SysMenuChildService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuChildServiceImpl
extends BaseServiceImpl<SysMenuChildDao, SysMenuChildEntity>
implements SysMenuChildService {
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(String pid, List<String> childCodeList) {
        if (CollUtil.isEmpty(childCodeList)) {
            ((SysMenuChildDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"PID", (Object)pid));
            return;
        }
        List dbList = ((SysMenuChildDao)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"PID", (Object)pid));
        if (CollUtil.isEmpty((Collection)dbList)) {
            ArrayList<SysMenuChildEntity> insertList = new ArrayList<SysMenuChildEntity>();
            for (int i = 0; i < childCodeList.size(); ++i) {
                SysMenuChildEntity entity = new SysMenuChildEntity();
                entity.setPid(pid);
                entity.setCode(childCodeList.get(i));
                entity.setSortIndex(Integer.valueOf(i));
                insertList.add(entity);
            }
            if (CollUtil.isNotEmpty(insertList)) {
                this.insertBatch(insertList);
            }
        } else {
            List dbCodeList = dbList.stream().map(SysMenuChildEntity::getCode).collect(Collectors.toList());
            for (String code : dbCodeList) {
                if (childCodeList.contains(code)) continue;
                ((SysMenuChildDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PID", (Object)pid)).eq((Object)"code", (Object)code));
            }
            for (int i = 0; i < childCodeList.size(); ++i) {
                String code;
                if (!dbCodeList.contains(childCodeList.get(i))) {
                    SysMenuChildEntity entity = new SysMenuChildEntity();
                    entity.setPid(pid);
                    entity.setCode(childCodeList.get(i));
                    entity.setSortIndex(Integer.valueOf(i));
                    this.insert((Object)entity);
                    continue;
                }
                code = childCodeList.get(i);
                Optional<SysMenuChildEntity> result = dbList.stream().filter(p -> p.getCode().equalsIgnoreCase(code)).findFirst();
                SysMenuChildEntity entity = result.get();
                entity.setSortIndex(Integer.valueOf(i));
                this.updateById((Object)entity);
            }
        }
    }

    public List<String> getMenuChildCodeList(String pid) {
        return ((SysMenuChildDao)this.baseDao).getMenuChildCodeList(pid);
    }
}

