/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.sys.dao.SysDeptDao;
import io.huimu.modules.sys.dto.SysDeptDTO;
import io.huimu.modules.sys.entity.SysDeptEntity;
import io.huimu.modules.sys.entity.SysOrganEntity;
import io.huimu.modules.sys.service.SysDeptService;
import io.huimu.modules.sys.service.SysOrganService;
import io.huimu.modules.sys.service.SysRoleService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDeptServiceImpl
extends BaseServiceImpl<SysDeptDao, SysDeptEntity>
implements SysDeptService {
    @Autowired
    private SysUserDeptDataScopeService dataScopeService;
    @Autowired
    private SysOrganService sysOrganService;
    @Autowired
    private SysRoleService sysRoleService;

    public List<SysDeptDTO> getList(Map<String, Object> params) {
        List entityList = ((SysDeptDao)this.baseDao).getList(params);
        List dtoList = ConvertUtils.sourceToTarget((Collection)entityList, SysDeptDTO.class);
        dtoList = TreeUtils.build((List)dtoList);
        List organList = this.sysOrganService.getAllList(params);
        if (CollUtil.isNotEmpty((Collection)organList)) {
            ArrayList<SysDeptDTO> resList = new ArrayList<SysDeptDTO>();
            for (SysOrganEntity organEntity : organList) {
                SysDeptDTO deptDTO = new SysDeptDTO();
                deptDTO.setId(organEntity.getOrgCode());
                deptDTO.setIsOrgFlag(Integer.valueOf(1));
                deptDTO.setOrgCode(organEntity.getOrgCode());
                deptDTO.setOrgName(organEntity.getOrgName());
                deptDTO.setDeptCode(organEntity.getOrgCode());
                deptDTO.setName(organEntity.getOrgName());
                for (SysDeptDTO dto : dtoList) {
                    if (!organEntity.getOrgCode().equalsIgnoreCase(dto.getOrgCode())) continue;
                    List child = deptDTO.getChildren();
                    child.add(dto);
                    deptDTO.setChildren(child);
                }
                resList.add(deptDTO);
            }
            return resList;
        }
        return TreeUtils.build((List)dtoList);
    }

    public SysDeptDTO getInfo(String id) {
        if (id == null) {
            return null;
        }
        SysDeptEntity entity = ((SysDeptDao)this.baseDao).getById(id);
        return (SysDeptDTO)ConvertUtils.sourceToTarget((Object)entity, SysDeptDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveDept(SysDeptDTO dto) {
        SysDeptEntity entity = (SysDeptEntity)ConvertUtils.sourceToTarget((Object)dto, SysDeptEntity.class);
        entity.setId(dto.getOrgCode() + "-" + dto.getDeptCode());
        entity.setPids(this.getPidList(entity.getPid(), dto.getOrgCode()));
        this.insert((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDept(SysDeptDTO dto) {
        SysDeptEntity entity = (SysDeptEntity)ConvertUtils.sourceToTarget((Object)dto, SysDeptEntity.class);
        if (entity.getId().equals(entity.getPid())) {
            throw new RenException(10011);
        }
        List subDeptList = this.getSubDeptIdList(entity.getId());
        if (subDeptList.contains(entity.getPid())) {
            throw new RenException(10011);
        }
        entity.setPids(this.getPidList(entity.getPid(), entity.getOrgCode()));
        this.updateById((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        SysDeptEntity deptEntity = (SysDeptEntity)this.selectById((Serializable)((Object)id));
        if (null != deptEntity) {
            List subList = this.getSubDeptIdList(id);
            if (subList.size() > 1) {
                throw new RenException(10014);
            }
            Integer count = this.sysRoleService.getCountByDeptCode(deptEntity.getDeptCode(), deptEntity.getOrgCode());
            if (count > 0) {
                throw new RenException("\u5f53\u524d\u90e8\u95e8\u4e0b\u5b58\u5728\u89d2\u8272\u4fe1\u606f\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            ((SysDeptDao)this.baseDao).deleteById((Serializable)((Object)id));
            this.dataScopeService.deleteByDeptId(id);
        }
    }

    public List<String> getSubDeptIdList(String id) {
        List deptIdList = ((SysDeptDao)this.baseDao).getSubDeptIdList("%" + id + "%");
        deptIdList.add(id);
        return deptIdList;
    }

    private String getPidList(String pid, String orgCode) {
        if ("0".equals(pid)) {
            return "0";
        }
        List deptList = ((SysDeptDao)this.baseDao).getIdAndPidList(orgCode);
        HashMap<String, SysDeptEntity> map = new HashMap<String, SysDeptEntity>(deptList.size());
        for (SysDeptEntity entity : deptList) {
            map.put(entity.getId(), entity);
        }
        ArrayList pidList = new ArrayList();
        this.getPidTree(pid, map, pidList);
        return StringUtils.join(pidList, (String)",");
    }

    private void getPidTree(String pid, Map<String, SysDeptEntity> map, List<String> pidList) {
        if ("0".equals(pid)) {
            return;
        }
        SysDeptEntity parent = map.get(pid);
        if (parent != null) {
            this.getPidTree(parent.getPid(), map, pidList);
        }
        pidList.add(pid);
    }

    public SysDeptEntity getInfoByOrgAndDeptCode(String orgCode, String deptCode) {
        return (SysDeptEntity)((SysDeptDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)orgCode)).eq((Object)"DEPT_CODE", (Object)deptCode));
    }

    public List<SysDeptEntity> getListByDeptIds(List<String> deptIds) {
        if (CollUtil.isNotEmpty(deptIds)) {
            return ((SysDeptDao)this.baseDao).selectList((Wrapper)new QueryWrapper().in((Object)"ID", deptIds));
        }
        return new ArrayList<SysDeptEntity>();
    }

    public Integer selectCountByOrgCode(String orgCode) {
        return ((SysDeptDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)orgCode));
    }

    public String getDeptName(String deptCode, String orgCode) {
        return ((SysDeptDao)this.baseDao).getDeptName(deptCode, orgCode);
    }
}

