/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.SysTemplateDTO;
import io.huimu.modules.sys.entity.SysTemplateEntity;
import io.huimu.modules.sys.param.GetTemplateListParam;
import io.huimu.modules.sys.service.SysTemplateService;
import io.huimu.modules.sys.vo.SysTemplateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/template"})
@Api(tags={"\u7cfb\u7edf\u6a21\u677f"})
public class SysTemplateController {
    @Autowired
    private SysTemplateService sysTemplateService;

    @PostMapping(value={"getListByType"})
    @ApiOperation(value="\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetTemplateListParam.class)
    public Result<List<SysTemplateVO>> getListByType(@RequestBody EncryptedReq<GetTemplateListParam> req) {
        GetTemplateListParam dto = (GetTemplateListParam)req.getData();
        List list = this.sysTemplateService.getListByType(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getListAllByType"})
    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u79d1\u5ba4\u6216\u4e2a\u4eba\u7684\u6a21\u677f\u5217\u8868\u53ca\u6570\u636e")
    public Result getListAllByType(@RequestBody EncryptedReq<GetTemplateListParam> req) {
        GetTemplateListParam dto = (GetTemplateListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        AssertUtils.isNull((Object)dto.getType(), (String[])new String[]{"\u7c7b\u578b"});
        List list = this.sysTemplateService.getListAllByType(dto.getType());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getListByPid"})
    @ApiOperation(value="\u83b7\u5185\u5bb9\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetTemplateListParam.class)
    public Result<List<SysTemplateDTO>> getListByPid(@RequestBody EncryptedReq<GetTemplateListParam> req) {
        GetTemplateListParam dto = (GetTemplateListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        AssertUtils.isBlank((String)dto.getPid(), (String[])new String[]{"\u7236\u7ea7id"});
        List list = this.sysTemplateService.getListByPid(dto.getPid());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u6a21\u677f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664\u6a21\u677f", module="\u6a21\u677f\u7ba1\u7406", operationType=3, logType=1)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        return this.sysTemplateService.delete(dto.getId());
    }

    @PostMapping(value={"saveTemplate"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u677f")
    @LogOperation(value="\u4fdd\u5b58\u6a21\u677f\u5185\u5bb9", module="\u6a21\u677f\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SysTemplateDTO.class)
    public Result saveContent(@RequestBody EncryptedReq<SysTemplateDTO> req) {
        SysTemplateDTO dto = (SysTemplateDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysTemplateService.saveTemplate(dto);
        return new Result();
    }

    @PostMapping(value={"updateTemplate"})
    @ApiOperation(value="\u4fee\u6539\u6a21\u677f")
    @LogOperation(value="\u4fee\u6539\u6a21\u677f\u5185\u5bb9", module="\u6a21\u677f\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=SysTemplateDTO.class)
    public Result updateContent(@RequestBody EncryptedReq<SysTemplateDTO> req) {
        SysTemplateDTO dto = (SysTemplateDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class, UpdateGroup.class});
        this.sysTemplateService.updateTemplate(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u5185\u5bb9")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysTemplateEntity entity = (SysTemplateEntity)this.sysTemplateService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(ConvertUtils.sourceToTarget((Object)entity, SysTemplateDTO.class));
    }
}

