/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.param.SystemConfSearchParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.SysSystemConfDTO;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.vo.SysSystemConfVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/conf"})
@Api(tags={"\u7cfb\u7edf\u914d\u7f6e\u7ba1\u7406"})
public class SysSystemConfController {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=SystemConfSearchParam.class)
    public Result<PageData<SysSystemConfVO>> page(@RequestBody EncryptedReq<SystemConfSearchParam> req) throws IllegalAccessException {
        PageData list = this.sysSystemConfService.page(MapUtils.object2Map((Object)req.getData()));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<SysSystemConfVO> getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysSystemConfVO data = this.sysSystemConfService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"updateMsg"})
    @ApiOperation(value="\u4fee\u6539\u63d0\u793a\u4fe1\u606f")
    @LogOperation(value="\u4fee\u6539\u63d0\u793a\u4fe1\u606f", module="\u7cfb\u7edf\u914d\u7f6e", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=SysSystemConfDTO.class)
    public Result updateMsg(@RequestBody EncryptedReq<SysSystemConfDTO> req) {
        SysSystemConfDTO dto = (SysSystemConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.sysSystemConfService.updateMsg(dto);
        return new Result();
    }

    @PostMapping(value={"saveMsg"})
    @ApiOperation(value="\u65b0\u589e\u63d0\u793a\u4fe1\u606f")
    @LogOperation(value="\u65b0\u589e\u63d0\u793a\u4fe1\u606f", module="\u7cfb\u7edf\u914d\u7f6e", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SysSystemConfDTO.class)
    public Result saveMsg(@RequestBody EncryptedReq<SysSystemConfDTO> req) {
        SysSystemConfDTO dto = (SysSystemConfDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        return this.sysSystemConfService.saveMsg(dto);
    }

    @GetMapping(value={"getEncryption"})
    @ApiOperation(value="\u83b7\u53d6\u52a0\u5bc6\u4fe1\u606f")
    public Result getEncryption() {
        String msg = this.sysSystemConfService.getConfValue("100025", "0");
        return new Result().ok((Object)msg);
    }

    @PostMapping(value={"getCaFlag"})
    @ApiOperation(value="\u83b7\u53d6ca\u5f00\u5173")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getCaFlag(@RequestBody EncryptedReq<NoParam> req) {
        String flag = this.sysSystemConfService.getCaFlag();
        return new Result().ok(req.getEncode(), (Object)flag);
    }
}

