/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.AuthorityQueryDTO;
import io.huimu.modules.sys.dto.SysAuthorityDTO;
import io.huimu.modules.sys.dto.SysRoleDTO;
import io.huimu.modules.sys.param.AuthorityRoleParam;
import io.huimu.modules.sys.param.SetDefaultRoleParam;
import io.huimu.modules.sys.param.SysRolePageParam;
import io.huimu.modules.sys.param.SysRoleSearchParam;
import io.huimu.modules.sys.service.SysRoleService;
import io.huimu.modules.sys.service.SysRoleUserAuthorityService;
import io.huimu.modules.sys.vo.AuthorityInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/role"})
@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
public class SysRoleController {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysRoleUserAuthorityService authorityService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=SysRolePageParam.class)
    public Result<PageData<SysRoleDTO>> page(@RequestBody EncryptedReq<SysRolePageParam> req) throws IllegalAccessException {
        PageData page = this.sysRoleService.page((SysRolePageParam)req.getData());
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u5217\u8868")
    @DecryptAndVerify(decryptedClass=SysRoleSearchParam.class)
    public Result<List<SysRoleDTO>> getList(@RequestBody EncryptedReq<SysRoleSearchParam> req) throws IllegalAccessException {
        List data = this.sysRoleService.getList((SysRoleSearchParam)req.getData());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<SysRoleDTO> getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysRoleDTO data = this.sysRoleService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"saveRole"})
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272")
    @LogOperation(value="\u4fdd\u5b58\u89d2\u8272", module="\u89d2\u8272\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysRoleDTO.class)
    public Result saveRole(@RequestBody EncryptedReq<SysRoleDTO> req) {
        SysRoleDTO dto = (SysRoleDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.sysRoleService.saveRole(dto);
        return new Result();
    }

    @PostMapping(value={"updateRole"})
    @ApiOperation(value="\u4fee\u6539\u89d2\u8272")
    @LogOperation(value="\u4fee\u6539\u89d2\u8272", module="\u89d2\u8272\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=SysRoleDTO.class)
    public Result updateRole(@RequestBody EncryptedReq<SysRoleDTO> req) {
        SysRoleDTO dto = (SysRoleDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.sysRoleService.updateRole(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @LogOperation(value="\u5220\u9664\u89d2\u8272", module="\u89d2\u8272\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    public Result delete(@RequestBody EncryptedReq<ArraysParam> req) {
        ArraysParam reqData = (ArraysParam)req.getData();
        AssertUtils.isArrayEmpty((Object[])reqData.getIds(), (String[])new String[]{"id"});
        this.sysRoleService.delete(reqData.getIds());
        return new Result();
    }

    @PostMapping(value={"/setDefaultRole"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u89d2\u8272")
    @DecryptAndVerify(decryptedClass=SetDefaultRoleParam.class)
    public Result setDefaultRole(@RequestBody EncryptedReq<SetDefaultRoleParam> req) {
        SetDefaultRoleParam dto = (SetDefaultRoleParam)req.getData();
        this.sysRoleService.setDefaultRole(dto);
        return new Result();
    }

    @PostMapping(value={"authorityUser"})
    @ApiOperation(value="\u7ed9\u7528\u6237\u6388\u6743")
    @LogOperation(value="\u7ed9\u7528\u6237\u6388\u6743", module="\u89d2\u8272\u6388\u6743", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SysAuthorityDTO.class)
    public Result authorityUser(@RequestBody EncryptedReq<SysAuthorityDTO> req) {
        SysAuthorityDTO dto = (SysAuthorityDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.authorityService.authorityUser(dto);
    }

    @PostMapping(value={"authorityRoleList"})
    @ApiOperation(value="\u53ef\u6388\u6743\u7684\u89d2\u8272\u5217\u8868")
    @DecryptAndVerify(decryptedClass=AuthorityRoleParam.class)
    public Result authorityRoleList(@RequestBody EncryptedReq<AuthorityRoleParam> req) {
        AuthorityRoleParam dto = (AuthorityRoleParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.authorityService.authorityRoleList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getAuthorityInfoById"})
    @ApiOperation(value="\u83b7\u53d6\u5355\u4e2a\u6388\u6743\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getAuthorityInfoById(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.authorityService.getAuthorityInfoById(dto.getId(), req.getEncode());
    }

    @PostMapping(value={"/authorityInfoPage"})
    @ApiOperation(value="\u7528\u6237\u6388\u6743\u4fe1\u606f\u5217\u8868")
    @DecryptAndVerify(decryptedClass=AuthorityQueryDTO.class)
    public Result<PageData<AuthorityInfoVo>> authorityInfoPage(@RequestBody EncryptedReq<AuthorityQueryDTO> req) {
        AuthorityQueryDTO dto = (AuthorityQueryDTO)req.getData();
        return this.authorityService.authorityInfoPage(dto, req.getEncode());
    }

    @PostMapping(value={"/cancelAuthor"})
    @ApiOperation(value="\u53d6\u6d88\u6388\u6743")
    @LogOperation(value="\u53d6\u6d88\u6388\u6743", module="\u89d2\u8272\u6388\u6743", operationType=2)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result cancelAuthor(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        return this.authorityService.cancelAuthor(dto.getId());
    }
}

