/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.param.SysMenuParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.security.service.ShiroService;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.security.user.UserDetail;
import io.huimu.modules.sys.dto.SysMenuDTO;
import io.huimu.modules.sys.enums.MenuTypeEnum;
import io.huimu.modules.sys.service.SysMenuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/menu"})
@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
public class SysMenuController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;

    @PostMapping(value={"nav"})
    @ApiOperation(value="\u5bfc\u822a")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<Map<String, Object>> nav(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        UserDetail user = SecurityUser.getUser();
        Map map = this.sysMenuService.getDefaultRoleMenuList(user, Integer.valueOf(MenuTypeEnum.MENU.value()), dto.getId());
        return new Result().ok(req.getEncode(), (Object)map);
    }

    @PostMapping(value={"getAllList"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u83dc\u5355\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getAllList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.sysMenuService.getAllList();
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"permissions"})
    @ApiOperation(value="\u6743\u9650\u6807\u8bc6")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<Set<String>> permissions(@RequestBody EncryptedReq<IdParam> req) {
        String roleId = ((IdParam)req.getData()).getId();
        Set set = this.shiroService.getRolePermissionsList(roleId);
        return new Result().ok(req.getEncode(), (Object)set);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @DecryptAndVerify(decryptedClass=SysMenuParam.class)
    public Result<List<SysMenuDTO>> getList(@RequestBody EncryptedReq<SysMenuParam> req) {
        SysMenuParam dto = (SysMenuParam)req.getData();
        List list = this.sysMenuService.getAllMenuList(dto.getType(), dto.getRoleId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<SysMenuDTO> getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysMenuDTO data = this.sysMenuService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"saveMenu"})
    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355")
    @LogOperation(value="\u65b0\u589e\u83dc\u5355", module="\u83dc\u5355\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysMenuDTO.class)
    public Result saveMenu(@RequestBody EncryptedReq<SysMenuDTO> req) {
        SysMenuDTO dto = (SysMenuDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysMenuService.saveMenu(dto);
        return new Result();
    }

    @PostMapping(value={"updateMenu"})
    @ApiOperation(value="\u4fee\u6539\u83dc\u5355")
    @LogOperation(value="\u4fee\u6539\u83dc\u5355", module="\u83dc\u5355\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=SysMenuDTO.class)
    public Result update(@RequestBody EncryptedReq<SysMenuDTO> req) {
        SysMenuDTO dto = (SysMenuDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.sysMenuService.updateMenu(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u83dc\u5355")
    @LogOperation(value="\u5220\u9664\u83dc\u5355", module="\u83dc\u5355\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.sysMenuService.getListPid(dto.getId());
        if (list.size() > 0) {
            return new Result().error(10008);
        }
        this.sysMenuService.delete(dto.getId());
        return new Result();
    }

    @PostMapping(value={"select"})
    @ApiOperation(value="\u89d2\u8272\u83dc\u5355\u6743\u9650")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<List<SysMenuDTO>> select(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        UserDetail user = SecurityUser.getUser();
        List list = this.sysMenuService.getRoleMenuList(user, null, dto.getId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getChildMenuById"})
    @ApiOperation(value="\u6839\u636e\u5de6\u4fa7\u83dc\u5355id\u83b7\u53d6\u5b50\u83dc\u5355")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getChildMenuById(@RequestBody EncryptedReq<IdParam> req) {
        IdParam idParam = (IdParam)req.getData();
        List list = this.sysMenuService.getChildMenuById(idParam.getId());
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

