/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.SysExamTypeDTO;
import io.huimu.modules.sys.entity.SysExamTypeEntity;
import io.huimu.modules.sys.param.DelExamTypeParam;
import io.huimu.modules.sys.param.ExamTypePageParam;
import io.huimu.modules.sys.param.ExamTypeSearchParam;
import io.huimu.modules.sys.param.GetExamTypeParam;
import io.huimu.modules.sys.service.SysExamTypeService;
import io.huimu.modules.sys.vo.SysExamTypeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exam/type"})
@Api(tags={"\u68c0\u67e5\u7c7b\u578b\u7ba1\u7406"})
public class SysExamTypeController {
    @Autowired
    private SysExamTypeService examTypeService;

    @PostMapping(value={"saveType"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u4fdd\u5b58\u68c0\u67e5\u7c7b\u578b", module="\u68c0\u67e5\u7c7b\u578b\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysExamTypeDTO.class)
    public Result saveType(@RequestBody EncryptedReq<SysExamTypeDTO> req) {
        SysExamTypeDTO dto = (SysExamTypeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.examTypeService.saveType(dto);
        return new Result();
    }

    @PostMapping(value={"updateType"})
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539\u68c0\u67e5\u7c7b\u578b", module="\u68c0\u67e5\u7c7b\u578b\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=SysExamTypeDTO.class)
    public Result updateType(@RequestBody EncryptedReq<SysExamTypeDTO> req) {
        SysExamTypeDTO dto = (SysExamTypeDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.examTypeService.updateType(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetExamTypeParam.class)
    public Result getInfo(@RequestBody EncryptedReq<GetExamTypeParam> req) {
        GetExamTypeParam dto = (GetExamTypeParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysExamTypeEntity entity = (SysExamTypeEntity)this.examTypeService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)entity, SysExamTypeDTO.class));
    }

    @PostMapping(value={"getPage"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ExamTypePageParam.class)
    public Result<PageData<SysExamTypeVO>> getPage(@RequestBody EncryptedReq<ExamTypePageParam> req) throws IllegalAccessException {
        ExamTypePageParam dto = (ExamTypePageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.examTypeService.getPage(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"batchDel"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DecryptAndVerify(decryptedClass=DelExamTypeParam.class)
    @LogOperation(value="\u6279\u91cf\u5220\u9664\u77e5\u8bc6\u5e93", module="\u68c0\u67e5\u7c7b\u578b\u7ba1\u7406", operationType=3)
    public Result batchDelKnow(@RequestBody EncryptedReq<DelExamTypeParam> req) {
        DelExamTypeParam dto = (DelExamTypeParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examTypeService.batchDel(dto.getId());
        return new Result();
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ExamTypeSearchParam.class)
    public Result<List<SysExamTypeVO>> getList(@RequestBody EncryptedReq<ExamTypeSearchParam> req) throws IllegalAccessException {
        ExamTypeSearchParam dto = (ExamTypeSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.examTypeService.getList(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

