/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sqwts.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.modules.outside.dto.UploadSqwtsFileDTO;
import io.huimu.modules.sqwts.dao.SqwtsDao;
import io.huimu.modules.sqwts.dto.SqwtsDTO;
import io.huimu.modules.sqwts.entity.SqwtsEntity;
import io.huimu.modules.sqwts.service.SqwtsService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.upload.entity.UploadEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SqwtsServiceImpl
extends BaseServiceImpl<SqwtsDao, SqwtsEntity>
implements SqwtsService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    @Transactional(rollbackFor={Exception.class})
    public void uploadSqwtsFile(UploadSqwtsFileDTO param) {
        UploadEntity uploadEntity;
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        Date today = new Date();
        if (StringUtils.isBlank((CharSequence)ftpPath)) {
            throw new RenException("\u7cfb\u7edf\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        SqwtsEntity entity = new SqwtsEntity();
        entity.setPatientIdNumber(param.getPatientIdNumber());
        entity.setCreateDate(today);
        entity.setUploadDate(DateUtils.format((Date)today, (String)"yyyy-MM-dd"));
        if (StringUtils.isNotBlank((CharSequence)param.getSqwtsFileBase())) {
            uploadEntity = FileUtils.base64ToFile((String)param.getSqwtsFileBase(), (String)"jpg", (String)ftpPath, (String)("sqwts/" + param.getPatientIdNumber()));
            entity.setSqwtsFilePath(uploadEntity.getFileDirPath() + "/" + uploadEntity.getFileName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBwtrSfzBackBase())) {
            uploadEntity = FileUtils.base64ToFile((String)param.getBwtrSfzBackBase(), (String)"jpg", (String)ftpPath, (String)("sqwts/" + param.getPatientIdNumber()));
            entity.setBwtrSfzBackFilePath(uploadEntity.getFileDirPath() + "/" + uploadEntity.getFileName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBwtrSfzFrontBase())) {
            uploadEntity = FileUtils.base64ToFile((String)param.getBwtrSfzFrontBase(), (String)"jpg", (String)ftpPath, (String)("sqwts/" + param.getPatientIdNumber()));
            entity.setBwtrSfzFrontFilePath(uploadEntity.getFileDirPath() + "/" + uploadEntity.getFileName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getWtrSfzBackBase())) {
            uploadEntity = FileUtils.base64ToFile((String)param.getWtrSfzBackBase(), (String)"jpg", (String)ftpPath, (String)("sqwts/" + param.getPatientIdNumber()));
            entity.setWtrSfzBackFilePath(uploadEntity.getFileDirPath() + "/" + uploadEntity.getFileName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getWtrSfzFrontBase())) {
            uploadEntity = FileUtils.base64ToFile((String)param.getWtrSfzFrontBase(), (String)"jpg", (String)ftpPath, (String)("sqwts/" + param.getPatientIdNumber()));
            entity.setWtrSfzFrontFilePath(uploadEntity.getFileDirPath() + "/" + uploadEntity.getFileName());
        }
        ((SqwtsDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id_number", (Object)param.getPatientIdNumber())).eq((Object)"upload_date", (Object)DateUtils.format((Date)today, (String)"yyyy-MM-dd")));
        this.insert((Object)entity);
    }

    public List<SqwtsDTO> getList(String patientIdNumber) {
        List list = ((SqwtsDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id_number", (Object)patientIdNumber)).orderByDesc((Object)"upload_date"));
        return ConvertUtils.sourceToTarget((Collection)list, SqwtsDTO.class);
    }
}

