/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.security.oauth2;

import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.MessageUtils;
import io.huimu.modules.license.service.LicenseService;
import io.huimu.modules.security.entity.SysUserTokenEntity;
import io.huimu.modules.security.oauth2.Oauth2Token;
import io.huimu.modules.security.service.ShiroService;
import io.huimu.modules.security.user.UserDetail;
import io.huimu.modules.sys.entity.SysUserEntity;
import java.util.Date;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Oauth2Realm
extends AuthorizingRealm {
    @Autowired
    private ShiroService shiroService;
    @Autowired
    private LicenseService licenseService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof Oauth2Token;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String accessToken = (String)token.getPrincipal();
        SysUserTokenEntity tokenEntity = this.shiroService.getByToken(accessToken);
        if (tokenEntity == null || tokenEntity.getExpireDate().getTime() < System.currentTimeMillis()) {
            throw new IncorrectCredentialsException(MessageUtils.getMessage((int)10021));
        }
        this.licenseService.checkSysLicense();
        SysUserEntity userEntity = this.shiroService.getUser(tokenEntity.getUserId());
        UserDetail userDetail = (UserDetail)ConvertUtils.sourceToTarget((Object)userEntity, UserDetail.class);
        if (userDetail.getStatus() == 0) {
            throw new LockedAccountException(MessageUtils.getMessage((int)10022));
        }
        if (tokenEntity.getExpireDate().getTime() < DateUtils.addDateMinutes((Date)new Date(), (int)5).getTime()) {
            tokenEntity.setExpireDate(DateUtils.addDateMinutes((Date)new Date(), (int)60));
            this.shiroService.updateTokenExpireDate(tokenEntity);
        }
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)userDetail, (Object)accessToken, this.getName());
        return info;
    }
}

