/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.security.controller;

import cn.hutool.core.collection.CollUtil;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.exception.RenException;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.HutoolSm4Utils;
import io.huimu.common.utils.IpUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.utils.SysConfUtil;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.log.dto.SysLogLoginDTO;
import io.huimu.modules.log.entity.SysLogLoginErrorEntity;
import io.huimu.modules.log.entity.SysLogLoginSuccessEntity;
import io.huimu.modules.log.service.SysLogLoginErrorService;
import io.huimu.modules.log.service.SysLogLoginSuccessService;
import io.huimu.modules.security.dto.JudgeLoginDTO;
import io.huimu.modules.security.dto.LoginDTO;
import io.huimu.modules.security.dto.SwitchUserDTO;
import io.huimu.modules.security.dto.UrlLoginDTO;
import io.huimu.modules.security.service.CaptchaService;
import io.huimu.modules.security.service.SysUserTokenService;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.security.user.UserDetail;
import io.huimu.modules.sys.dto.SysUserDTO;
import io.huimu.modules.sys.enums.SuperAdminEnum;
import io.huimu.modules.sys.enums.UserStatusEnum;
import io.huimu.modules.sys.service.SysRoleUserService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.service.SysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u767b\u5f55\u7ba1\u7406"})
public class LoginController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private CaptchaService captchaService;
    @Autowired
    private SysLogLoginSuccessService successService;
    @Autowired
    private SysLogLoginErrorService loginErrorService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private SysRoleUserService sysRoleUserService;

    @PostMapping(value={"captcha"})
    @ApiOperation(value="\u9a8c\u8bc1\u7801")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result captcha(HttpServletResponse response, @RequestBody EncryptedReq<IdParam> req) throws IOException {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        String base = this.captchaService.create(response, dto.getId());
        return new Result().ok(req.getEncode(), (Object)base);
    }

    @PostMapping(value={"judgeLogin"})
    @ApiOperation(value="\u6821\u9a8c\u767b\u5f55")
    @DecryptAndVerify(decryptedClass=JudgeLoginDTO.class)
    public Result judgeLogin(@RequestBody EncryptedReq<JudgeLoginDTO> req) {
        JudgeLoginDTO login = (JudgeLoginDTO)req.getData();
        ValidatorUtils.validateEntity((Object)login, (Class[])new Class[0]);
        List msgList = this.sysSystemConfService.getList();
        SysUserDTO user = this.sysUserService.getByEmployeeId(login.getEmployeeId());
        if (user == null) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100001", (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            throw new RenException(message);
        }
        if (user.getStatus().intValue() == UserStatusEnum.DISABLE.value()) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new RenException(message);
        }
        String i = this.sysSystemConfService.getConfValue("100009", "0");
        if (i.equalsIgnoreCase("1")) {
            if (StringUtils.isBlank((CharSequence)login.getPassword())) {
                throw new RenException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)login.getPassword())) {
                throw new RenException(SysConfUtil.getMsg((List)msgList, (String)"100010", (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (!HutoolSm4Utils.matches((String)login.getPassword(), (String)user.getPassword())) {
                Integer lockNum = Integer.valueOf(SysConfUtil.getMsg((List)msgList, (String)"100004", (String)"5"));
                if (user.getPwdErrorNum() + 1 >= lockNum) {
                    this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(user.getPwdErrorNum() + 1), Integer.valueOf(UserStatusEnum.DISABLE.value()));
                    throw new RenException(SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                }
                this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(user.getPwdErrorNum() + 1), Integer.valueOf(UserStatusEnum.ENABLED.value()));
                throw new RenException("\u5bc6\u7801\u9519\u8bef,\u8fd8\u6709" + (lockNum - user.getPwdErrorNum() - 1) + "\u6b21\u673a\u4f1a!");
            }
            this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(0), Integer.valueOf(UserStatusEnum.ENABLED.value()));
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", user.getId());
        List resList = this.sysRoleUserService.getAllRoleList(param);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("userName", user.getRealName());
        resMap.put("roleList", resList);
        return new Result().ok(req.getEncode(), resMap);
    }

    @PostMapping(value={"login"})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55")
    @DecryptAndVerify(decryptedClass=LoginDTO.class)
    public Result login(HttpServletRequest request, @RequestBody EncryptedReq<LoginDTO> req) {
        LoginDTO login = (LoginDTO)req.getData();
        ValidatorUtils.validateEntity((Object)login, (Class[])new Class[0]);
        List msgList = this.sysSystemConfService.getList();
        boolean flag = this.captchaService.validate(login.getUuid(), login.getCaptcha());
        if (!flag) {
            return new Result().error(SysConfUtil.getMsg((List)msgList, (String)"100003", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef"));
        }
        SysUserDTO user = this.sysUserService.getByEmployeeId(login.getEmployeeId());
        SysLogLoginDTO log = new SysLogLoginDTO();
        log.setOperation("\u7528\u6237\u767b\u5f55");
        log.setCreateDate(new Date());
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestParams(JsonUtils.toJsonString((Object)login));
        if (user == null) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100001", (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        if (user.getStatus().intValue() == UserStatusEnum.DISABLE.value()) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        if (!HutoolSm4Utils.matches((String)login.getPassword(), (String)user.getPassword())) {
            log.setCreator(user.getId());
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
            log.setErrorMsg("\u5bc6\u7801\u9519\u8bef");
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            Integer lockNum = Integer.valueOf(SysConfUtil.getMsg((List)msgList, (String)"100004", (String)"5"));
            if (user.getPwdErrorNum() + 1 >= lockNum) {
                this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(user.getPwdErrorNum() + 1), Integer.valueOf(UserStatusEnum.DISABLE.value()));
                throw new RenException(SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
            this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(user.getPwdErrorNum() + 1), Integer.valueOf(UserStatusEnum.ENABLED.value()));
            throw new RenException("\u5bc6\u7801\u9519\u8bef,\u8fd8\u6709" + (lockNum - user.getPwdErrorNum() - 1) + "\u6b21\u673a\u4f1a!");
        }
        this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(0), Integer.valueOf(UserStatusEnum.ENABLED.value()));
        if (user.getSuperAdmin().intValue() == SuperAdminEnum.NO.value()) {
            if (StringUtils.isBlank((CharSequence)login.getRoleId())) {
                String massage = SysConfUtil.getMsg((List)msgList, (String)"100012", (String)"\u8bf7\u9009\u62e9\u767b\u5f55\u7684\u89d2\u8272");
                log.setCreator(user.getEmployeeId());
                log.setCreatorName(user.getRealName());
                log.setErrorMsg(massage);
                this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                throw new RenException(massage);
            }
            List roleIds = this.sysRoleUserService.getRoleIdList(user.getId());
            if (CollUtil.isNotEmpty((Collection)roleIds)) {
                if (!roleIds.contains(login.getRoleId())) {
                    String message = SysConfUtil.getMsg((List)msgList, (String)"100013", (String)"\u89d2\u8272\u9009\u62e9\u6709\u8bef");
                    log.setCreator(user.getEmployeeId());
                    log.setCreatorName(user.getRealName());
                    log.setErrorMsg(message);
                    this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                    throw new RenException(message);
                }
            } else {
                String message = SysConfUtil.getMsg((List)msgList, (String)"100014", (String)"\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u89d2\u8272\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                log.setCreator(user.getEmployeeId());
                log.setCreatorName(user.getRealName());
                log.setErrorMsg(message);
                this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                throw new RenException(message);
            }
        }
        log.setCreator(user.getEmployeeId());
        log.setCreatorName(user.getRealName());
        this.successService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginSuccessEntity.class));
        request.getSession().invalidate();
        request.getSession(true);
        return this.sysUserTokenService.createToken(req.getEncode(), user, login.getRoleId());
    }

    @PostMapping(value={"logout"})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    public Result logout(HttpServletRequest request) {
        UserDetail user = SecurityUser.getUser();
        this.sysUserTokenService.logout(user.getId());
        SysLogLoginSuccessEntity log = new SysLogLoginSuccessEntity();
        log.setOperation("\u9000\u51fa\u767b\u5f55");
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setCreator(user.getEmployeeId());
        log.setCreatorName(user.getRealName());
        log.setCreateDate(new Date());
        this.successService.insert((Object)log);
        return new Result();
    }

    @PostMapping(value={"switchUser"})
    @ApiOperation(value="\u5207\u6362\u7528\u6237")
    @LogOperation(value="\u5207\u6362\u7528\u6237", module="\u767b\u5f55", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=SwitchUserDTO.class)
    public Result switchUser(HttpServletRequest request, @RequestBody EncryptedReq<SwitchUserDTO> req) {
        SwitchUserDTO dto = (SwitchUserDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List msgList = this.sysSystemConfService.getList();
        SysUserDTO user = this.sysUserService.getByEmployeeId(dto.getEmployeeId());
        SysLogLoginDTO log = new SysLogLoginDTO();
        log.setOperation("\u5207\u6362\u7528\u6237");
        log.setCreateDate(new Date());
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setRequestParams(JsonUtils.toJsonString((Object)dto));
        if (user == null) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100001", (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        if (dto.getFlag() == 1) {
            String switchStatus = SysConfUtil.getMsg((List)msgList, (String)"100009", null);
            if (StringUtils.isNotBlank((CharSequence)switchStatus)) {
                if (switchStatus.equalsIgnoreCase("1")) {
                    if (StringUtils.isBlank((CharSequence)dto.getPassword())) {
                        throw new RenException(SysConfUtil.getMsg((List)msgList, (String)"100010", (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    }
                    if (!HutoolSm4Utils.matches((String)dto.getPassword(), (String)user.getPassword())) {
                        log.setCreator(user.getEmployeeId());
                        log.setCreatorName(user.getRealName());
                        log.setErrorMsg("\u5bc6\u7801\u9519\u8bef");
                        this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                        Integer lockNum = Integer.valueOf(SysConfUtil.getMsg((List)msgList, (String)"100004", (String)"5"));
                        if (user.getPwdErrorNum() + 1 >= lockNum) {
                            this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(user.getPwdErrorNum() + 1), Integer.valueOf(UserStatusEnum.DISABLE.value()));
                            throw new RenException(SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                        }
                        this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(user.getPwdErrorNum() + 1), Integer.valueOf(UserStatusEnum.ENABLED.value()));
                        throw new RenException(SysConfUtil.getMsg((List)msgList, (String)"100002", (String)"\u5bc6\u7801\u9519\u8bef") + ",\u8fd8\u6709" + (lockNum - user.getPwdErrorNum() - 1) + "\u6b21\u673a\u4f1a!");
                    }
                    this.sysUserService.updatePwdErrorNumAndLockStatus(user.getId(), Integer.valueOf(0), Integer.valueOf(UserStatusEnum.ENABLED.value()));
                }
            } else {
                throw new RenException("\u914d\u7f6e\u662f\u5426\u9700\u8981\u5bc6\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        if (user.getStatus().intValue() == UserStatusEnum.DISABLE.value()) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        if (user.getSuperAdmin().intValue() == SuperAdminEnum.NO.value()) {
            if (StringUtils.isBlank((CharSequence)dto.getRoleId())) {
                String massage = SysConfUtil.getMsg((List)msgList, (String)"100012", (String)"\u8bf7\u9009\u62e9\u767b\u5f55\u7684\u89d2\u8272");
                log.setCreator(user.getId());
                log.setCreatorName(user.getRealName());
                log.setErrorMsg(massage);
                this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                throw new RenException(massage);
            }
            List roleIds = this.sysRoleUserService.getRoleIdList(user.getId());
            if (CollUtil.isNotEmpty((Collection)roleIds)) {
                if (!roleIds.contains(dto.getRoleId())) {
                    String message = SysConfUtil.getMsg((List)msgList, (String)"100013", (String)"\u89d2\u8272\u9009\u62e9\u6709\u8bef");
                    log.setCreator(user.getId());
                    log.setCreatorName(user.getRealName());
                    log.setErrorMsg(message);
                    this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                    throw new RenException(message);
                }
            } else {
                String message = SysConfUtil.getMsg((List)msgList, (String)"100014", (String)"\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u89d2\u8272\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                log.setCreator(user.getId());
                log.setCreatorName(user.getRealName());
                log.setErrorMsg(message);
                this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                throw new RenException(message);
            }
        }
        log.setCreator(user.getEmployeeId());
        log.setCreatorName(user.getRealName());
        this.successService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginSuccessEntity.class));
        return this.sysUserTokenService.createToken(req.getEncode(), user, dto.getRoleId());
    }

    @PostMapping(value={"urlLogin"})
    @ApiOperation(value="url\u767b\u5f55")
    @DecryptAndVerify(decryptedClass=UrlLoginDTO.class)
    public Result urlLogin(HttpServletRequest request, @RequestBody EncryptedReq<UrlLoginDTO> req) {
        UrlLoginDTO login = (UrlLoginDTO)req.getData();
        ValidatorUtils.validateEntity((Object)login, (Class[])new Class[0]);
        List msgList = this.sysSystemConfService.getList();
        SysUserDTO user = this.sysUserService.getByEmployeeId(login.getEmployeeId());
        SysLogLoginDTO log = new SysLogLoginDTO();
        log.setOperation("\u7528\u6237\u767b\u5f55");
        log.setCreateDate(new Date());
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestParams(JsonUtils.toJsonString((Object)login));
        if (user == null) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100001", (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        if (user.getStatus().intValue() == UserStatusEnum.DISABLE.value()) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        String roleId = null;
        if (user.getSuperAdmin().intValue() == SuperAdminEnum.NO.value()) {
            List roleIds = this.sysRoleUserService.getRoleIdList(user.getId());
            if (CollUtil.isNotEmpty((Collection)roleIds)) {
                roleId = (String)roleIds.get(0);
            } else {
                String message = SysConfUtil.getMsg((List)msgList, (String)"100014", (String)"\u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u89d2\u8272\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                log.setCreator(user.getEmployeeId());
                log.setCreatorName(user.getRealName());
                log.setErrorMsg(message);
                this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
                throw new RenException(message);
            }
        }
        log.setCreator(user.getEmployeeId());
        log.setCreatorName(user.getRealName());
        this.successService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginSuccessEntity.class));
        request.getSession().invalidate();
        request.getSession(true);
        return this.sysUserTokenService.createToken(req.getEncode(), user, roleId);
    }

    @PostMapping(value={"getToken"})
    @ApiOperation(value="\u83b7\u53d6token")
    @DecryptAndVerify(decryptedClass=UrlLoginDTO.class)
    public Result getToken(HttpServletRequest request, @RequestBody EncryptedReq<UrlLoginDTO> req) {
        UrlLoginDTO login = (UrlLoginDTO)req.getData();
        ValidatorUtils.validateEntity((Object)login, (Class[])new Class[0]);
        List msgList = this.sysSystemConfService.getList();
        SysUserDTO user = this.sysUserService.getByEmployeeId(login.getEmployeeId());
        SysLogLoginDTO log = new SysLogLoginDTO();
        log.setOperation("\u7528\u6237\u767b\u5f55");
        log.setCreateDate(new Date());
        log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
        log.setUserAgent(request.getHeader("User-Agent"));
        log.setRequestParams(JsonUtils.toJsonString((Object)login));
        if (user == null) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100001", (String)"\u7528\u6237\u4e0d\u5b58\u5728");
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        if (user.getStatus().intValue() == UserStatusEnum.DISABLE.value()) {
            String message = SysConfUtil.getMsg((List)msgList, (String)"100005", (String)"\u8d26\u53f7\u88ab\u9501,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            log.setCreator(user.getEmployeeId());
            log.setCreatorName(user.getRealName());
            log.setErrorMsg(message);
            this.loginErrorService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginErrorEntity.class));
            throw new RenException(message);
        }
        log.setCreator(user.getEmployeeId());
        log.setCreatorName(user.getRealName());
        this.successService.insert(ConvertUtils.sourceToTarget((Object)log, SysLogLoginSuccessEntity.class));
        request.getSession().invalidate();
        request.getSession(true);
        return this.sysUserTokenService.getToken(req.getEncode(), user);
    }
}

