/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.bdform.dto.BdTemplateDTO;
import io.huimu.modules.dict.param.DictExamitemVerifyUserParam;
import io.huimu.modules.dict.service.DictExamitemVerifyUserService;
import io.huimu.modules.dict.service.DictItemRealAddressService;
import io.huimu.modules.dict.service.DictStandardKnowService;
import io.huimu.modules.register.dao.ScProjectDao;
import io.huimu.modules.register.dto.ScProjectDTO;
import io.huimu.modules.register.dto.SwitchProjectZsFlagDTO;
import io.huimu.modules.register.entity.ScProjectEntity;
import io.huimu.modules.register.param.ChangeProjectEnabledParam;
import io.huimu.modules.register.param.GetCheckProjectSearchParam;
import io.huimu.modules.register.service.ProjectRelationBDService;
import io.huimu.modules.register.service.ScProjectPackageService;
import io.huimu.modules.register.service.ScProjectService;
import io.huimu.modules.register.vo.ExamStatusVO;
import io.huimu.modules.register.vo.ScProjectTreeDTO;
import io.huimu.modules.sys.dto.SysKnowledgeDTO;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScProjectServiceImpl
extends BaseServiceImpl<ScProjectDao, ScProjectEntity>
implements ScProjectService {
    @Autowired
    private ScProjectPackageService packageService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private DictStandardKnowService standardKnowService;
    @Autowired
    private ProjectRelationBDService projectRelationBDService;
    @Autowired
    private DictItemRealAddressService dictItemRealAddressService;
    @Autowired
    private DictExamitemVerifyUserService dictExamitemVerifyUserService;

    public PageData<ScProjectDTO> getPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"examineItem", "deptName"});
        IPage page = this.getPage(params, "", false);
        List list = ((ScProjectDao)this.baseDao).getList(params);
        for (ScProjectEntity entity : list) {
            entity.setKnowNames(this.standardKnowService.getKnowNames(entity.getStandardCode()));
            entity.setExamAddressList(this.dictItemRealAddressService.getAddressList(entity.getOrgCode(), entity.getExamineCode()));
            entity.setBdTemplateList(this.projectRelationBDService.getBdTemplateByExamCode(entity.getOrgCode(), entity.getExamineCode()));
            DictExamitemVerifyUserParam param = new DictExamitemVerifyUserParam();
            param.setExamCode(entity.getExamineCode());
            entity.setVerifyUserList(this.dictExamitemVerifyUserService.getList(param));
        }
        return this.getPageData(list, page.getTotal(), ScProjectDTO.class);
    }

    public PageData<ScProjectDTO> getPageByPagId(Map<String, Object> params) {
        IPage page = this.getPage(params, "", false);
        List list = ((ScProjectDao)this.baseDao).getListByPagId(params);
        return this.getPageData(list, page.getTotal(), ScProjectDTO.class);
    }

    public List<ScProjectDTO> getListByPagId(String packageId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("packageId", packageId);
        List list = ((ScProjectDao)this.baseDao).getListByPagId(params);
        return ConvertUtils.sourceToTarget((Collection)list, ScProjectDTO.class);
    }

    public List<ScProjectDTO> getList(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"examineItem"});
        params.put("isEnabled", 1);
        List list = ((ScProjectDao)this.baseDao).getList(params);
        return ConvertUtils.sourceToTarget((Collection)list, ScProjectDTO.class);
    }

    public List<ScProjectTreeDTO> getTreeList(String orgCode) {
        List list = ((ScProjectDao)this.baseDao).getTreeList(orgCode);
        return TreeUtils.build((List)list);
    }

    public void changeProjectEnabled(ChangeProjectEnabledParam param) {
        ScProjectEntity entity = new ScProjectEntity();
        entity.setIdKey(param.getIdKey());
        entity.setIsEnabled(param.getIsEnabled());
        this.update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)param.getIdKey()));
    }

    public Result updateProject(ScProjectDTO dto) {
        ScProjectEntity entity = (ScProjectEntity)ConvertUtils.sourceToTarget((Object)dto, ScProjectEntity.class);
        ((ScProjectDao)this.baseDao).update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
        this.projectRelationBDService.saveOrUpdate(dto.getOrgCode(), dto.getExamineCode(), dto.getBdTemplateCodeList());
        this.dictItemRealAddressService.saveOrUpdate(dto.getOrgCode(), dto.getExamineCode(), dto.getExamAddressIdList());
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public Result saveProject(ScProjectDTO dto) {
        ScProjectEntity entity = (ScProjectEntity)ConvertUtils.sourceToTarget((Object)dto, ScProjectEntity.class);
        entity.setIdKey(entity.getExamineCode());
        this.insert((Object)entity);
        this.projectRelationBDService.saveOrUpdate(dto.getOrgCode(), dto.getExamineCode(), dto.getBdTemplateCodeList());
        this.dictItemRealAddressService.saveOrUpdate(dto.getOrgCode(), dto.getExamineCode(), dto.getExamAddressIdList());
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteProject(String idKey) {
        ScProjectEntity entity = (ScProjectEntity)((ScProjectDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)idKey));
        if (null != entity) {
            Integer count = this.packageService.judgeExist(entity.getOrgCode(), entity.getExamineCode());
            if (count > 0) {
                throw new RenException(this.sysSystemConfService.getConfValue("100017", "\u8be5\u9879\u76ee\u5b58\u5728\u5957\u9910\u4e2d\uff0c\u8bf7\u5148\u89e3\u7ed1"));
            }
            ((ScProjectDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)idKey));
            this.projectRelationBDService.deleteRelation(entity.getOrgCode(), entity.getExamineCode());
            this.dictItemRealAddressService.deleteRelation(entity.getOrgCode(), entity.getExamineCode());
        }
    }

    public ScProjectDTO getInfo(String idKey) {
        ScProjectDTO dto = ((ScProjectDao)this.baseDao).getInfo(idKey);
        if (null != dto) {
            dto.setBdTemplateCodeList(this.projectRelationBDService.getBdTemplateCodeList(dto.getOrgCode(), dto.getExamineCode()));
            dto.setExamAddressIdList(this.dictItemRealAddressService.getAddressIdList(dto.getOrgCode(), dto.getExamineCode()));
        }
        return dto;
    }

    public void switchZsFlag(SwitchProjectZsFlagDTO dto) {
        ScProjectEntity entity = new ScProjectEntity();
        entity.setIdKey(dto.getIdKey());
        entity.setZsFlag(dto.getZsFlag());
        ((ScProjectDao)this.baseDao).update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
    }

    public Integer getCount(String orgCode, String examineCode) {
        return ((ScProjectDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)orgCode)).eq((Object)"EXAMINE_CODE", (Object)examineCode));
    }

    public List<BdTemplateDTO> getRelationBdTemplateList(String orgCode, String examineCode) {
        return this.projectRelationBDService.getBdTemplateByExamCode(orgCode, examineCode);
    }

    public List<SysKnowledgeDTO> getKnowByStandardCode(String standardCode) {
        return this.standardKnowService.getKnowByStandardCode(standardCode);
    }

    public List<ExamStatusVO> getExamItemStatusList() {
        return ((ScProjectDao)this.baseDao).getExamItemStatusList();
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveByExcel(List<ScProjectDTO> list) {
        for (ScProjectDTO dto : list) {
            int count = ((ScProjectDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
            if (count > 0) {
                this.update(ConvertUtils.sourceToTarget((Object)dto, ScProjectEntity.class), (Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
                continue;
            }
            this.insert(ConvertUtils.sourceToTarget((Object)dto, ScProjectEntity.class));
        }
    }

    public List<ScProjectDTO> getCheckProjectList(GetCheckProjectSearchParam param) {
        if (StringUtils.isNotBlank((CharSequence)param.getDeviceId())) {
            return ((ScProjectDao)this.baseDao).getExamItemByDeviceId(param.getDeviceId());
        }
        List list = ((ScProjectDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_Enabled", (Object)1)).eq(StringUtils.isNotBlank((CharSequence)param.getOrgCode()), (Object)"ORG_CODE", (Object)param.getOrgCode()));
        return ConvertUtils.sourceToTarget((Collection)list, ScProjectDTO.class);
    }

    public ScProjectDTO getInfoByExamNo(String examNo, String orgCode) {
        return ((ScProjectDao)this.baseDao).getInfoByExamNo(examNo, orgCode);
    }
}

