/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.IDUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.register.dao.ScProjectPackageDao;
import io.huimu.modules.register.dto.ScProjectPackageDTO;
import io.huimu.modules.register.entity.ScProjectPackageEntity;
import io.huimu.modules.register.service.ScProjectPackageService;
import io.huimu.modules.register.vo.ProjectPackageTreeVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScProjectPackageServiceImpl
extends BaseServiceImpl<ScProjectPackageDao, ScProjectPackageEntity>
implements ScProjectPackageService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    @Transactional(rollbackFor={Exception.class})
    public Result savePackage(ScProjectPackageDTO dto) {
        if (CollUtil.isEmpty((Collection)dto.getPrjCodeList())) {
            String msg = this.sysSystemConfService.getConfValue("100016", "\u8bf7\u9009\u62e9\u5957\u9910\u5185\u5bb9");
            return new Result().error(msg);
        }
        String createId = SecurityUser.getUser().getEmployeeId();
        String createUser = SecurityUser.getUser().getRealName();
        String idKey = IDUtils.generateStringValue();
        ArrayList<ScProjectPackageEntity> list = new ArrayList<ScProjectPackageEntity>();
        for (String code : dto.getPrjCodeList()) {
            ScProjectPackageEntity entity = (ScProjectPackageEntity)ConvertUtils.sourceToTarget((Object)dto, ScProjectPackageEntity.class);
            entity.setCreateUser(createUser);
            entity.setCreateId(createId);
            entity.setCreateTime(new Date());
            entity.setIdKey(idKey);
            entity.setExamineCode(code);
            list.add(entity);
        }
        if (CollUtil.isNotEmpty(list)) {
            this.insertBatch(list, 20);
        }
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updatePackage(ScProjectPackageDTO dto) {
        if (CollUtil.isEmpty((Collection)dto.getPrjCodeList())) {
            String msg = this.sysSystemConfService.getConfValue("100016", "\u8bf7\u9009\u62e9\u5957\u9910\u5185\u5bb9");
            return new Result().error(msg);
        }
        ((ScProjectPackageDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
        String createId = SecurityUser.getUser().getEmployeeId();
        String createUser = SecurityUser.getUser().getRealName();
        ArrayList<ScProjectPackageEntity> list = new ArrayList<ScProjectPackageEntity>();
        for (String code : dto.getPrjCodeList()) {
            ScProjectPackageEntity entity = (ScProjectPackageEntity)ConvertUtils.sourceToTarget((Object)dto, ScProjectPackageEntity.class);
            entity.setCreateUser(createUser);
            entity.setCreateId(createId);
            entity.setIdKey(dto.getIdKey());
            entity.setExamineCode(code);
            list.add(entity);
        }
        if (CollUtil.isNotEmpty(list)) {
            this.insertBatch(list, 20);
        }
        return new Result();
    }

    @Transactional(rollbackFor={Exception.class})
    public void deletePackage(String idKey) {
        ((ScProjectPackageDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)idKey));
    }

    public ScProjectPackageDTO getInfo(String idKey) {
        return ((ScProjectPackageDao)this.baseDao).getInfo(idKey);
    }

    public List<ScProjectPackageDTO> getList(String orgCode, Integer packageType) {
        return ((ScProjectPackageDao)this.baseDao).getList(orgCode, packageType, SecurityUser.getUser().getEmployeeId());
    }

    public Integer judgeExist(String orgCode, String examineCode) {
        return ((ScProjectPackageDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)orgCode)).eq((Object)"EXAMINE_CODE", (Object)examineCode));
    }

    public List<ProjectPackageTreeVO> getListContainProject(String orgCode, Integer packageType) {
        return ((ScProjectPackageDao)this.baseDao).getListContainProject(orgCode, packageType, SecurityUser.getEmployeeId());
    }
}

