/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.status.ExamStatus;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.modules.dict.entity.DictTransmitEntity;
import io.huimu.modules.dict.service.DictTransmitService;
import io.huimu.modules.littlecheck.entity.SysExamDeviceConfEntity;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import io.huimu.modules.outside.param.AsyncZeissFileParam;
import io.huimu.modules.outside.vo.WxExamItemDataVO;
import io.huimu.modules.register.dao.RegisterItemDao;
import io.huimu.modules.register.dto.ExamItemDTO;
import io.huimu.modules.register.entity.ExamFilesEntity;
import io.huimu.modules.register.entity.ExamItemStatusLogEntity;
import io.huimu.modules.register.entity.RegisterItemEntity;
import io.huimu.modules.register.param.DelRegisterParam;
import io.huimu.modules.register.param.UpdateExamStatusParam;
import io.huimu.modules.register.service.ExamFilesService;
import io.huimu.modules.register.service.ExamItemStatusLogService;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.register.vo.CheckCountFormartVO;
import io.huimu.modules.register.vo.OneKeyTansExamVO;
import io.huimu.modules.register.vo.RegisterExamInfoVO;
import io.huimu.modules.register.vo.RegisterItemInfoVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import io.huimu.modules.upload.entity.UploadEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegisterItemServiceImpl
extends BaseServiceImpl<RegisterItemDao, RegisterItemEntity>
implements RegisterItemService {
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private ExamItemStatusLogService statusLogService;
    @Autowired
    private SysUserDeptDataScopeService dataScopeService;
    @Autowired
    private DictTransmitService transmitService;
    @Autowired
    private SysExamDeviceConfService deviceConfService;
    @Autowired
    private ExamFilesService examFilesService;

    public PageData<RegisterExamInfoVO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId", "sqysName", "jcysName", "mzNumber"});
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        String page = (String)params.get("page");
        String limit = (String)params.get("limit");
        PageHelper.startPage((int)Integer.parseInt(page), (int)Integer.parseInt(limit));
        List list = ((RegisterItemDao)this.baseDao).getList(params);
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), RegisterExamInfoVO.class);
    }

    public PageData<RegisterExamInfoVO> getHandCancelPatientList(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber"});
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((RegisterItemDao)this.baseDao).getHandCancelPatientList(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(String patientId, String risNo, String deptCode, String orgCode, List<ExamItemDTO> prjList) {
        ArrayList<RegisterItemEntity> list = new ArrayList<RegisterItemEntity>();
        ArrayList<ExamItemStatusLogEntity> logEntityList = new ArrayList<ExamItemStatusLogEntity>();
        for (int i = 1; i <= prjList.size(); ++i) {
            RegisterItemEntity entity = new RegisterItemEntity();
            ExamItemStatusLogEntity logEntity = new ExamItemStatusLogEntity();
            entity.setPatientId(patientId);
            entity.setRisNo(risNo);
            entity.setHospitalOrgCode(orgCode);
            entity.setExamineItemCode(prjList.get(i - 1).getExamineCode());
            entity.setExamineItem(prjList.get(i - 1).getExamineItem());
            entity.setExamNo(risNo + "_" + i);
            entity.setExamItemNo(String.valueOf(i));
            entity.setRisSubclass(prjList.get(i - 1).getRisSubclass());
            entity.setRisModality(prjList.get(i - 1).getRisModality());
            entity.setExamineRoom(prjList.get(i - 1).getExamineRoom());
            entity.setCreateTime(new Date());
            entity.setCostsNum(prjList.get(i - 1).getCostsNum());
            entity.setOdRisSubclassBz(prjList.get(i - 1).getOdRisSubclassBz());
            entity.setOsRisSubclassBz(prjList.get(i - 1).getOsRisSubclassBz());
            String str = new String();
            if (StringUtils.isNotBlank((CharSequence)entity.getOdRisSubclassBz())) {
                str = "\u53f3\u773c\uff1a" + entity.getOdRisSubclassBz() + " ";
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getOsRisSubclassBz())) {
                str = str + "\u5de6\u773c\uff1a" + entity.getOsRisSubclassBz() + " ";
            }
            entity.setAllRisSubclassBz(str);
            list.add(entity);
            logEntity.setExamNo(entity.getExamNo());
            logEntity.setCreateUserName(SecurityUser.getUser().getRealName());
            logEntity.setCreateUserId(SecurityUser.getEmployeeId());
            logEntity.setDeptCode(deptCode);
            logEntity.setOrgCode(orgCode);
            logEntityList.add(logEntity);
        }
        if (CollUtil.isNotEmpty(list)) {
            this.insertBatch(list, 20);
        }
        if (CollUtil.isNotEmpty(logEntityList)) {
            this.statusLogService.callExamStatusLogDj(logEntityList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByRisNo(DelRegisterParam dto) {
        List examNos = ((RegisterItemDao)this.baseDao).getExamNosByRisNo(dto.getRisNo());
        if (CollUtil.isNotEmpty((Collection)examNos)) {
            for (String examNo : examNos) {
                ((RegisterItemDao)this.baseDao).callExamItemQx(examNo, SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), dto.getDeptCode(), dto.getOrgCode(), dto.getAbortInfo());
            }
        }
    }

    public Integer getExecuteItem(String risNo, Integer finishExam) {
        return ((RegisterItemDao)this.baseDao).getExecuteItem(risNo, finishExam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelExamItem(UpdateExamStatusParam dto) {
        RegisterItemEntity dbEntity = (RegisterItemEntity)((RegisterItemDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EXAM_NO", (Object)dto.getExamNo())).eq((Object)"IS_DELETE", (Object)0));
        if (null == dbEntity) {
            throw new RenException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (dbEntity.getExamStatus().intValue() == ExamStatus.STOP_EXAM.intValue()) {
            throw new RenException("\u6b64\u9879\u76ee\u5df2\u53d6\u6d88");
        }
        if (dbEntity.getExamStatus() > ExamStatus.STOP_EXAM) {
            throw new RenException(this.sysSystemConfService.getConfValue("100021", "\u6b64\u9879\u76ee\u5df2\u68c0\u67e5\uff0c\u65e0\u6cd5\u53d6\u6d88"));
        }
        ((RegisterItemDao)this.baseDao).callExamItemQx(dto.getExamNo(), SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), dto.getDeptCode(), dto.getOrgCode(), dto.getAbortInfo());
    }

    public void finishExamItem(UpdateExamStatusParam dto) {
        RegisterItemEntity dbEntity = (RegisterItemEntity)((RegisterItemDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EXAM_NO", (Object)dto.getExamNo())).eq((Object)"IS_DELETE", (Object)0));
        if (null == dbEntity) {
            throw new RenException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (dbEntity.getExamStatus().intValue() == ExamStatus.STOP_EXAM.intValue()) {
            throw new RenException("\u6b64\u9879\u76ee\u5df2\u53d6\u6d88");
        }
        if (null == dto.getUpdateStatusTime()) {
            dto.setUpdateStatusTime(new Date());
        }
        ((RegisterItemDao)this.baseDao).callExamItemWc(dto.getExamNo(), SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), dto.getDeptCode(), dto.getOrgCode(), dto.getUpdateStatusTime());
    }

    public void callExamItemHj(UpdateExamStatusParam dto) {
        RegisterItemEntity dbEntity = (RegisterItemEntity)((RegisterItemDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"EXAM_NO", (Object)dto.getExamNo())).eq((Object)"IS_DELETE", (Object)0));
        if (null == dbEntity) {
            throw new RenException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (dbEntity.getExamStatus().intValue() == ExamStatus.STOP_EXAM.intValue()) {
            throw new RenException("\u6b64\u9879\u76ee\u5df2\u53d6\u6d88");
        }
        ((RegisterItemDao)this.baseDao).callExamItemHj(dto.getExamNo(), SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), dto.getDeptCode(), dto.getOrgCode());
    }

    public List<RegisterItemInfoVO> getExamItemList(String risNo) {
        return ((RegisterItemDao)this.baseDao).getExamItemList(risNo);
    }

    public List<RegisterItemInfoVO> getExamItemListWithLog(String risNo) {
        return ((RegisterItemDao)this.baseDao).getExamItemListWithLog(risNo);
    }

    public CheckCountFormartVO checkCount(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "sqysName", "jcysName"});
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        List countVOList = ((RegisterItemDao)this.baseDao).checkCount(params);
        CheckCountFormartVO vo = new CheckCountFormartVO();
        vo.setFinishCount(Collections.frequency(countVOList, 1));
        vo.setUnFinishCount(Collections.frequency(countVOList, 0));
        return vo;
    }

    public void updateOneKeyTransStatus(String examNo) {
        RegisterItemEntity entity = new RegisterItemEntity();
        entity.setExamNo(examNo);
        entity.setOneKeyTrans(Integer.valueOf(1));
        entity.setOneKeyTransTime(new Date());
        this.update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"EXAM_NO", (Object)examNo));
    }

    public void updateHandCancelReport(String examNo) {
        ((RegisterItemDao)this.baseDao).callHandCancelReport(examNo);
    }

    public List<WxExamItemDataVO> getWxExamItemList(List<String> pids, String beginDate, String endDate) {
        return ((RegisterItemDao)this.baseDao).getWxExamItemList(pids, beginDate, endDate);
    }

    public RegisterItemEntity selectInfoByExamNo(String examNo) {
        return ((RegisterItemDao)this.baseDao).selectInfoByExamNo(examNo);
    }

    public String getModalityByExamNo(String examNo) {
        return ((RegisterItemDao)this.baseDao).getModalityByExamNo(examNo);
    }

    public List<OneKeyTansExamVO> getAutoMatchPatient(Map<String, Object> params) {
        String deviceId = (String)params.get("deviceId");
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            DictTransmitEntity transmitEntity = this.transmitService.selectByDeviceId(deviceId);
            if (null != transmitEntity && null != transmitEntity.getAutoMateDays()) {
                params.put("endDate", DateUtils.format((Date)new Date()));
                params.put("beginDate", DateUtils.format((Date)DateUtils.addDateDays((Date)new Date(), (int)(0 - transmitEntity.getAutoMateDays()))));
            } else {
                params.put("endDate", DateUtils.format((Date)new Date()));
                params.put("beginDate", DateUtils.format((Date)DateUtils.addDateDays((Date)new Date(), (int)-10)));
            }
        }
        return ((RegisterItemDao)this.baseDao).getAutoMatchPatient(params);
    }

    public PageData<OneKeyTansExamVO> getHandleOperaMatchPatientPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber"});
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((RegisterItemDao)this.baseDao).getHandleOperaMatchPatient(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    public List<OneKeyTansExamVO> getHandleOperaMatchPatientList(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber"});
        String deviceId = (String)params.get("deviceId");
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            DictTransmitEntity transmitEntity = this.transmitService.selectByDeviceId(deviceId);
            if (null != transmitEntity && null != transmitEntity.getAutoMateDays()) {
                params.put("endDate", DateUtils.format((Date)new Date()));
                params.put("beginDate", DateUtils.format((Date)DateUtils.addDateDays((Date)new Date(), (int)(0 - transmitEntity.getAutoMateDays()))));
            } else {
                params.put("endDate", DateUtils.format((Date)new Date()));
                params.put("beginDate", DateUtils.format((Date)DateUtils.addDateDays((Date)new Date(), (int)-10)));
            }
        }
        return ((RegisterItemDao)this.baseDao).getHandleOperaMatchPatient(params);
    }

    public RegisterItemInfoVO getExamItemInfo(String examNo) {
        if (StringUtils.isNotBlank((CharSequence)examNo)) {
            return ((RegisterItemDao)this.baseDao).getExamItemInfo(examNo);
        }
        return null;
    }

    public void asyncZeissFile(AsyncZeissFileParam param) {
        List deviceIds = this.deviceConfService.getDeviceIdListByModel(param.getManufacturerModelName());
        if (CollUtil.isNotEmpty((Collection)deviceIds)) {
            SysExamDeviceConfEntity deviceConfEntity = (SysExamDeviceConfEntity)deviceIds.get(0);
            String year = param.getStudyDate().substring(0, 4);
            String month = param.getStudyDate().substring(4, 6);
            String day = param.getStudyDate().substring(6, 8);
            String hour = param.getStudyTime().substring(0, 2);
            String mi = param.getStudyTime().substring(2, 4);
            String ss = param.getStudyTime().substring(4, 6);
            Date endDate = DateUtils.stringToDate((String)(year + "-" + month + "-" + day), (String)"yyyy-MM-dd");
            Date beginDate = null;
            beginDate = null == deviceConfEntity.getAutoMateDays() ? DateUtils.addDateDays((Date)endDate, (int)-10) : DateUtils.addDateDays((Date)endDate, (int)(0 - deviceConfEntity.getAutoMateDays()));
            List list = ((RegisterItemDao)this.baseDao).getExamNosForZeiss(param.getPatientId(), deviceConfEntity.getIdKey(), DateUtils.format((Date)beginDate, (String)"yyyy-MM-dd"), DateUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            if (CollUtil.isNotEmpty((Collection)list)) {
                RegisterItemEntity entity = (RegisterItemEntity)list.get(0);
                String ftpPath = this.sysSystemConfService.getConfValue("100007", "");
                UploadEntity zeissFile = FileUtils.base64ToFile((String)param.getFileBase(), (String)StringUtils.lowerCase((String)param.getFileType()), (String)ftpPath, (String)"zeiss_file");
                if (null != zeissFile) {
                    Date examTime = DateUtils.stringToDate((String)(year + "-" + month + "-" + day + " " + hour + ":" + mi + ":" + ss), (String)"yyyy-MM-dd HH:mm:ss");
                    ExamFilesEntity filesEntity = new ExamFilesEntity();
                    filesEntity.setExamNo(entity.getExamNo());
                    filesEntity.setFileNo("1");
                    filesEntity.setCreateTime(new Date());
                    filesEntity.setFileType(StringUtils.upperCase((String)param.getFileType()));
                    filesEntity.setHospitalOrgCode(entity.getHospitalOrgCode());
                    filesEntity.setUploadDevice(deviceConfEntity.getIdKey());
                    filesEntity.setUploadTime(examTime);
                    filesEntity.setUploadUserId(deviceConfEntity.getOutLink());
                    filesEntity.setUploadUserName(deviceConfEntity.getOutLink());
                    filesEntity.setFileSource("1");
                    filesEntity.setFileStatus(Integer.valueOf(50));
                    filesEntity.setFilePath(zeissFile.getFileDirPath());
                    filesEntity.setFileName(zeissFile.getFileName());
                    this.examFilesService.insert((Object)filesEntity);
                    UpdateExamStatusParam examStatusParam = new UpdateExamStatusParam();
                    examStatusParam.setExamNo(entity.getExamNo());
                    examStatusParam.setOrgCode(entity.getHospitalOrgCode());
                    examStatusParam.setUpdateStatusTime(examTime);
                    this.finishExamItem(examStatusParam);
                }
            }
        }
    }

    public Integer getItemPushFlagByExamNo(String examNo) {
        return ((RegisterItemDao)this.baseDao).getItemPushFlagByExamNo(examNo);
    }

    public List<RegisterExamInfoVO> getExportItemList(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId", "sqysName", "jcysName", "mzNumber"});
        String orgCode = (String)params.get("orgCode");
        List deptCodes = this.dataScopeService.getDeptCodeDataScope(orgCode, SecurityUser.getUserId());
        if (CollUtil.isNotEmpty((Collection)deptCodes)) {
            params.put("deptCodes", deptCodes);
        }
        return ((RegisterItemDao)this.baseDao).getList(params);
    }
}

