/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.register.dto.ScProjectPackageDTO;
import io.huimu.modules.register.param.DelPackageParam;
import io.huimu.modules.register.param.PackageSearchParam;
import io.huimu.modules.register.param.ScProjectPackSearchParam;
import io.huimu.modules.register.service.ScProjectPackageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sc/project/package"})
@Api(tags={"\u5957\u9910\u7ba1\u7406"})
public class ScProjectPackageController {
    @Autowired
    private ScProjectPackageService packageService;

    @PostMapping(value={"savePackage"})
    @ApiOperation(value="\u65b0\u589e\u5957\u9910")
    @LogOperation(value="\u65b0\u589e\u5957\u9910", module="\u5957\u9910\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=ScProjectPackageDTO.class)
    public Result savePackage(@RequestBody EncryptedReq<ScProjectPackageDTO> req) {
        ScProjectPackageDTO dto = (ScProjectPackageDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.packageService.savePackage(dto);
    }

    @PostMapping(value={"updatePackage"})
    @ApiOperation(value="\u66f4\u65b0\u5957\u9910")
    @LogOperation(value="\u66f4\u65b0\u5957\u9910", module="\u5957\u9910\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=ScProjectPackageDTO.class)
    public Result updatePackage(@RequestBody EncryptedReq<ScProjectPackageDTO> req) {
        ScProjectPackageDTO dto = (ScProjectPackageDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.packageService.updatePackage(dto);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5957\u9910\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ScProjectPackSearchParam.class)
    public Result getList(@RequestBody EncryptedReq<ScProjectPackSearchParam> req) {
        ScProjectPackSearchParam param = (ScProjectPackSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        List list = this.packageService.getList(param.getOrgCode(), param.getPackageType());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getListContainProject"})
    @ApiOperation(value="\u83b7\u53d6\u5957\u9910\u5217\u8868--\u5305\u542b\u9879\u76ee")
    @DecryptAndVerify(decryptedClass=ScProjectPackSearchParam.class)
    public Result getListContainProject(@RequestBody EncryptedReq<ScProjectPackSearchParam> req) {
        ScProjectPackSearchParam param = (ScProjectPackSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        List list = this.packageService.getListContainProject(param.getOrgCode(), param.getPackageType());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5957\u9910\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=PackageSearchParam.class)
    public Result getInfo(@RequestBody EncryptedReq<PackageSearchParam> req) {
        PackageSearchParam param = (PackageSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        ScProjectPackageDTO dto = this.packageService.getInfo(param.getIdKey());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"deletePackage"})
    @ApiOperation(value="\u5220\u9664\u5957\u9910")
    @LogOperation(value="\u5220\u9664\u5957\u9910", module="\u5957\u9910\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=DelPackageParam.class)
    public Result deletePackage(@RequestBody EncryptedReq<DelPackageParam> req) {
        DelPackageParam packageParam = (DelPackageParam)req.getData();
        ValidatorUtils.validateEntity((Object)packageParam, (Class[])new Class[0]);
        this.packageService.deletePackage(packageParam.getIdKey());
        return new Result();
    }
}

