/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.ExcelUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.register.dto.RegisterExamDTO;
import io.huimu.modules.register.dto.UpdateRegisterExamDTO;
import io.huimu.modules.register.excel.RegisterExamExcel;
import io.huimu.modules.register.param.DelRegisterParam;
import io.huimu.modules.register.param.GetExamInfoParam;
import io.huimu.modules.register.param.GetPatientParam;
import io.huimu.modules.register.param.GetRegisterListParam;
import io.huimu.modules.register.param.GetRegisterPageParam;
import io.huimu.modules.register.param.ManualRegisterParam;
import io.huimu.modules.register.param.QueryManualRegister;
import io.huimu.modules.register.service.RegisterExamService;
import io.huimu.modules.register.vo.RegisterExamInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/register/exam"})
@Api(tags={"\u68c0\u67e5\u767b\u8bb0\u7ba1\u7406"})
public class RegisterExamController {
    @Autowired
    private RegisterExamService registerExamService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetRegisterPageParam.class)
    public Result<PageData<RegisterExamInfoVO>> page(@RequestBody EncryptedReq<GetRegisterPageParam> req) throws IllegalAccessException {
        GetRegisterPageParam params = (GetRegisterPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.registerExamService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @GetMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgCode", value="\u673a\u6784code", paramType="query", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="patientId", value="\u75c5\u5386\u53f7", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="szm", value="\u9996\u5b57\u6bcd", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="beginDate", value="\u5f00\u59cb\u65f6\u95f4", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="endDate", value="\u7ed3\u675f\u65e5\u671f", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="examItemCode", value="\u68c0\u67e5\u9879\u76eecode", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="sqksCode", value="\u7533\u8bf7\u79d1\u5ba4code", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="sqysCode", value="\u7533\u8bf7\u533b\u751fcode", paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="patientName", value="\u59d3\u540d", paramType="query", dataTypeClass=String.class)})
    public void export(@ApiIgnore @RequestParam Map<String, Object> params, HttpServletResponse response) throws Exception {
        List list = this.registerExamService.getExcelList(params);
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u767b\u8bb0\u5217\u8868", (List)list, RegisterExamExcel.class);
    }

    @PostMapping(value={"getPatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u6700\u8fd1\u4e00\u6b21\u68c0\u67e5\u767b\u8bb0\u65f6\u60a3\u8005\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=GetPatientParam.class)
    public Result getPatientInfo(@RequestBody EncryptedReq<GetPatientParam> req) throws IllegalAccessException, IOException {
        GetPatientParam dto = (GetPatientParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        if (StringUtils.isBlank((CharSequence)dto.getPatientId()) && StringUtils.isBlank((CharSequence)dto.getPatientIdNumber())) {
            throw new RenException("\u75c5\u5386\u53f7\u548c\u8eab\u4efd\u8bc1\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        RegisterExamInfoVO vo = this.registerExamService.getPatientInfo(dto);
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5f00\u5355\u8bb0\u5f55\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetRegisterListParam.class)
    public Result<List<RegisterExamInfoVO>> getList(@RequestBody EncryptedReq<GetRegisterListParam> req) throws IllegalAccessException {
        GetRegisterListParam params = (GetRegisterListParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        List page = this.registerExamService.getList(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"addExam"})
    @ApiOperation(value="\u4fdd\u5b58\u68c0\u67e5\u767b\u8bb0")
    @LogOperation(value="\u4fdd\u5b58\u68c0\u67e5\u767b\u8bb0", module="\u68c0\u67e5\u767b\u8bb0\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=RegisterExamDTO.class)
    public Result addExam(@RequestBody EncryptedReq<RegisterExamDTO> req) {
        RegisterExamDTO dto = (RegisterExamDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.registerExamService.addExam(dto);
    }

    @PostMapping(value={"updateExam"})
    @ApiOperation(value="\u7f16\u8f91\u68c0\u67e5\u767b\u8bb0")
    @LogOperation(value="\u7f16\u8f91\u68c0\u67e5\u767b\u8bb0", module="\u68c0\u67e5\u767b\u8bb0\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=UpdateRegisterExamDTO.class)
    public Result updateExam(@RequestBody EncryptedReq<UpdateRegisterExamDTO> req) {
        UpdateRegisterExamDTO dto = (UpdateRegisterExamDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class, UpdateGroup.class});
        this.registerExamService.updateExam(dto);
        return new Result();
    }

    @PostMapping(value={"getExamInfo"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u767b\u8bb0\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=GetExamInfoParam.class)
    public Result getExamInfo(@RequestBody EncryptedReq<GetExamInfoParam> req) {
        GetExamInfoParam dto = (GetExamInfoParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        RegisterExamInfoVO vo = this.registerExamService.getExamInfo(dto.getRisNo());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"deleteExam"})
    @ApiOperation(value="\u53d6\u6d88\u68c0\u67e5\u767b\u8bb0")
    @LogOperation(value="\u53d6\u6d88\u68c0\u67e5\u767b\u8bb0", module="\u68c0\u67e5\u767b\u8bb0\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=DelRegisterParam.class)
    public Result deleteExam(@RequestBody EncryptedReq<DelRegisterParam> req) {
        DelRegisterParam dto = (DelRegisterParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.registerExamService.deleteExam(dto);
        return new Result();
    }

    @PostMapping(value={"queryManualRegister"})
    @ApiOperation(value="\u624b\u5de5\u767b\u8bb0\u67e5\u8be2")
    @DecryptAndVerify(decryptedClass=QueryManualRegister.class)
    public Result queryManualRegister(@RequestBody EncryptedReq<QueryManualRegister> req) throws IllegalAccessException {
        QueryManualRegister dto = (QueryManualRegister)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        Object object = this.registerExamService.queryManualRegister(dto);
        return new Result().ok(req.getEncode(), object);
    }

    @PostMapping(value={"manualRegister"})
    @ApiOperation(value="\u4eba\u5de5\u767b\u8bb0")
    @DecryptAndVerify(decryptedClass=ManualRegisterParam.class)
    @LogOperation(value="\u4eba\u5de5\u767b\u8bb0", module="\u68c0\u67e5\u767b\u8bb0\u7ba1\u7406", operationType=1)
    public Result manualRegister(@RequestBody EncryptedReq<ManualRegisterParam> req) {
        ManualRegisterParam dto = (ManualRegisterParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        return this.registerExamService.manualRegister(dto);
    }
}

