/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patient.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.patient.dao.PatientDao;
import io.huimu.modules.patient.dto.PatientDTO;
import io.huimu.modules.patient.entity.PatientEntity;
import io.huimu.modules.patient.service.PatientService;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class PatientServiceImpl
extends BaseServiceImpl<PatientDao, PatientEntity>
implements PatientService {
    public PageData<PatientDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "patientIdNumber"});
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((PatientDao)this.baseDao).getList(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    public PatientDTO getInfo(String patientId, String orgCode) {
        return ((PatientDao)this.baseDao).getInfo(patientId, orgCode);
    }

    public Result updatePatient(PatientDTO dto) {
        int count = ((PatientDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)dto.getPatientId()));
        if (count == 0) {
            return new Result().error("\u75c5\u5386\u53f7\u4e0d\u5b58\u5728");
        }
        PatientEntity entity = (PatientEntity)ConvertUtils.sourceToTarget((Object)dto, PatientEntity.class);
        entity.setHospitalOrgCode(dto.getOrgCode());
        this.updateById((Object)entity);
        return new Result();
    }

    public Result savePatient(PatientDTO dto) {
        int count = ((PatientDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)dto.getPatientId()));
        if (count > 0) {
            return new Result().error("\u75c5\u5386\u53f7\u5df2\u5b58\u5728");
        }
        PatientEntity entity = (PatientEntity)ConvertUtils.sourceToTarget((Object)dto, PatientEntity.class);
        entity.setHospitalOrgCode(dto.getOrgCode());
        this.insert((Object)entity);
        return new Result();
    }

    public Result deletePatient(String patientId, String orgCode) {
        ((PatientDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)patientId)).eq((Object)"org_code", (Object)orgCode));
        return new Result();
    }
}

