/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patient.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.bdform.service.BdFormService;
import io.huimu.modules.patient.dao.PatientArchiveDao;
import io.huimu.modules.patient.dto.PatientArchiveDTO;
import io.huimu.modules.patient.entity.PatientArchiveEntity;
import io.huimu.modules.patient.service.PatientArchiveService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientArchiveServiceImpl
extends BaseServiceImpl<PatientArchiveDao, PatientArchiveEntity>
implements PatientArchiveService {
    @Autowired
    private BdFormService bdFormService;

    public List<PatientArchiveDTO> getList(String patientId, String patientIdNumber) {
        if (StringUtils.isNotBlank((CharSequence)patientIdNumber)) {
            PatientArchiveEntity entity = new PatientArchiveEntity();
            entity.setPatientId(patientId);
            ((PatientArchiveDao)this.baseDao).update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID_NUMBER", (Object)patientIdNumber)).isNull((Object)"PATIENT_ID"));
        }
        List resList = ((PatientArchiveDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)patientId)).orderByDesc((Object)"ARCHIVE_DATE"));
        return ConvertUtils.sourceToTarget((Collection)resList, PatientArchiveDTO.class);
    }

    public Result addArchive(PatientArchiveDTO dto) {
        int count = ((PatientArchiveDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)dto.getPatientId())).eq((Object)"ARCHIVE_DATE", (Object)dto.getArchiveDate()));
        if (count > 0) {
            return new Result().error(dto.getArchiveDate() + "\uff0c\u6863\u6848\u5df2\u5b58\u5728");
        }
        PatientArchiveEntity entity = (PatientArchiveEntity)ConvertUtils.sourceToTarget((Object)dto, PatientArchiveEntity.class);
        this.insert((Object)entity);
        return new Result();
    }

    public Result deleteArchive(String id) {
        Integer count = this.bdFormService.getCountByArchiveId(id);
        if (count > 0) {
            return new Result().error("\u8be5\u6863\u6848\u4e0b\u5b58\u5728\u75c5\u5386\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.deleteById((Serializable)((Object)id));
        return new Result();
    }

    public String getPatientLastArchiveId(String patientId) {
        List resList = ((PatientArchiveDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)patientId)).orderByDesc((Object)"ARCHIVE_DATE"));
        if (CollUtil.isNotEmpty((Collection)resList)) {
            return ((PatientArchiveEntity)resList.get(0)).getId();
        }
        PatientArchiveEntity entity = new PatientArchiveEntity();
        entity.setArchiveDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        entity.setPatientId(patientId);
        entity.setCreateDate(new Date());
        this.insert((Object)entity);
        return entity.getId();
    }

    public String getPatientLastArchiveIdByPatientIdNumber(String patientIdNumber) {
        List resList = ((PatientArchiveDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID_NUMBER", (Object)patientIdNumber)).orderByDesc((Object)"ARCHIVE_DATE"));
        if (CollUtil.isNotEmpty((Collection)resList)) {
            return ((PatientArchiveEntity)resList.get(0)).getId();
        }
        PatientArchiveEntity entity = new PatientArchiveEntity();
        entity.setArchiveDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        entity.setPatientIdNumber(patientIdNumber);
        entity.setCreateDate(new Date());
        this.insert((Object)entity);
        return entity.getId();
    }
}

