/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.outside.service;

import com.alibaba.fastjson.JSON;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.LocalCacheUtil;
import io.huimu.common.utils.MapUtils;
import io.huimu.modules.littlecheck.dto.SaveShiLiDTO;
import io.huimu.modules.littlecheck.dto.YanGuangBaseDTO;
import io.huimu.modules.littlecheck.dto.YanYaBaseDTO;
import io.huimu.modules.log.service.SysLogYtAsyncService;
import io.huimu.modules.outside.dao.YtDao;
import io.huimu.modules.outside.dto.AsyncYtDeleteExamDataDTO;
import io.huimu.modules.outside.dto.AsyncYtDeletePdfDTO;
import io.huimu.modules.outside.dto.AsyncYtPatientDTO;
import io.huimu.modules.outside.dto.AsyncYtPdfDTO;
import io.huimu.modules.outside.dto.AsyncYtShiLiDTO;
import io.huimu.modules.outside.dto.AsyncYtYanGuangBaseDTO;
import io.huimu.modules.outside.dto.AsyncYtYanGuangDTO;
import io.huimu.modules.outside.dto.AsyncYtYanYaDTO;
import io.huimu.modules.outside.response.YtAsyncResponse;
import io.huimu.modules.outside.response.YtPatient;
import io.huimu.modules.outside.response.YtPatientResponse;
import io.huimu.modules.outside.response.YtToken;
import io.huimu.modules.outside.response.YtTokenResponse;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.service.SysOrganService;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class YtService {
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private SysOrganService sysOrganService;
    @Autowired
    private SysLogYtAsyncService sysLogYtAsyncService;
    @Autowired
    private YtDao ytDao;

    @Async
    public void asyncShiLi(String id, SaveShiLiDTO dto, int asyncNum) throws IllegalAccessException {
        String url = this.sysSystemConfService.getConfValue("100028", null);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String ytToken = this.getYtToken();
            String uuid = this.getYtPatient(dto.getPatientIdNumber(), dto.getPatientName(), ytToken, 1);
            if (StringUtils.isBlank((CharSequence)uuid)) {
                return;
            }
            String ytCode = this.sysOrganService.getYtCodeByCode(dto.getOrgCode());
            AsyncYtShiLiDTO param = (AsyncYtShiLiDTO)ConvertUtils.sourceToTarget((Object)dto, AsyncYtShiLiDTO.class);
            param.setUuid(uuid);
            param.setId(id);
            param.setExamDoctorId(SecurityUser.getEmployeeId());
            param.setExamDoctorName(SecurityUser.getUser().getRealName());
            param.setExamTime(DateUtils.format((Date)dto.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            param.setHospitalCode(ytCode);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Accept", "application/json");
            headers.set("token", ytToken);
            HttpEntity httpEntity = new HttpEntity((Object)MapUtils.object2Map((Object)param), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtAsyncResponse.class, new Object[0]);
            YtAsyncResponse ytAsyncResponse = (YtAsyncResponse)responseEntity.getBody();
            if (null == ytAsyncResponse) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u89c6\u529b\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), "\u8fd4\u56de\u5185\u5bb9\u4e3anull");
            } else if (ytAsyncResponse.getCode() == 0) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u89c6\u529b\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(200), ytAsyncResponse.getMessage());
            } else if (ytAsyncResponse.getCode() == 2001) {
                if (asyncNum < 2) {
                    this.asyncShiLi(id, dto, asyncNum + 1);
                }
            } else {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u89c6\u529b\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), ytAsyncResponse.getMessage());
            }
        }
    }

    @Async
    public void asyncYanYa(String id, String patientIdNumber, YanYaBaseDTO dto, int asyncNum) throws IllegalAccessException {
        String url = this.sysSystemConfService.getConfValue("100029", null);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String ytToken = this.getYtToken();
            String uuid = this.getYtPatient(patientIdNumber, dto.getPatientName(), ytToken, 1);
            if (StringUtils.isBlank((CharSequence)uuid)) {
                return;
            }
            String ytCode = this.sysOrganService.getYtCodeByCode(dto.getOrgCode());
            AsyncYtYanYaDTO param = (AsyncYtYanYaDTO)ConvertUtils.sourceToTarget((Object)dto, AsyncYtYanYaDTO.class);
            param.setUuid(uuid);
            param.setPatientIdNumber(patientIdNumber);
            param.setId(id);
            param.setExamDoctorId(SecurityUser.getEmployeeId());
            param.setExamDoctorName(SecurityUser.getUser().getRealName());
            param.setExamTime(DateUtils.format((Date)dto.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            param.setHospitalCode(ytCode);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Accept", "application/json");
            headers.set("token", ytToken);
            HttpEntity httpEntity = new HttpEntity((Object)MapUtils.object2Map((Object)param), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtAsyncResponse.class, new Object[0]);
            YtAsyncResponse ytAsyncResponse = (YtAsyncResponse)responseEntity.getBody();
            if (null == ytAsyncResponse) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u773c\u538b\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), "\u8fd4\u56de\u5185\u5bb9\u4e3anull");
            } else if (ytAsyncResponse.getCode() == 0) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u773c\u538b\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(200), ytAsyncResponse.getMessage());
            } else if (ytAsyncResponse.getCode() == 2001) {
                if (asyncNum < 2) {
                    this.asyncYanYa(id, patientIdNumber, dto, asyncNum + 1);
                }
            } else {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u773c\u538b\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), ytAsyncResponse.getMessage());
            }
        }
    }

    @Async
    public void asyncYanGuang(String odId, String osId, String patientIdNumber, YanGuangBaseDTO dto, int asyncNum) throws IllegalAccessException {
        String url = this.sysSystemConfService.getConfValue("100030", null);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String ytToken = this.getYtToken();
            String uuid = this.getYtPatient(patientIdNumber, dto.getPatientName(), ytToken, 1);
            if (StringUtils.isBlank((CharSequence)uuid)) {
                return;
            }
            String ytCode = this.sysOrganService.getYtCodeByCode(dto.getOrgCode());
            AsyncYtYanGuangDTO param = new AsyncYtYanGuangDTO();
            String examTime = DateUtils.format((Date)dto.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss");
            param.setOdData(this.setOdData(odId, examTime, patientIdNumber, ytCode, dto, uuid));
            param.setOsData(this.setOsData(osId, examTime, patientIdNumber, ytCode, dto, uuid));
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Accept", "application/json");
            headers.set("token", ytToken);
            HttpEntity httpEntity = new HttpEntity((Object)JSON.parseObject((String)JSON.toJSONString((Object)param)), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtAsyncResponse.class, new Object[0]);
            YtAsyncResponse ytAsyncResponse = (YtAsyncResponse)responseEntity.getBody();
            if (null == ytAsyncResponse) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u9a8c\u5149\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), "\u8fd4\u56de\u5185\u5bb9\u4e3anull");
            } else if (ytAsyncResponse.getCode() == 0) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u9a8c\u5149\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(200), ytAsyncResponse.getMessage());
            } else if (ytAsyncResponse.getCode() == 2001) {
                if (asyncNum < 2) {
                    this.asyncYanGuang(odId, osId, patientIdNumber, dto, asyncNum + 1);
                }
            } else {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u9a8c\u5149\u68c0\u67e5\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), ytAsyncResponse.getMessage());
            }
        }
    }

    @Async
    public void asyncDeleteExamData(Integer dataType, String id, String orgCode, int asyncNum) throws IllegalAccessException {
        String url = this.sysSystemConfService.getConfValue("100032", null);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String dataMsg = dataType == 1 ? "\u63a8\u9001\u5220\u9664\u89c6\u529b\u68c0\u67e5\u6570\u636e" : (dataType == 2 ? "\u63a8\u9001\u5220\u9664\u773c\u538b\u68c0\u67e5\u6570\u636e" : "\u63a8\u9001\u5220\u9664\u9a8c\u5149\u68c0\u67e5\u6570\u636e");
            String ytCode = this.sysOrganService.getYtCodeByCode(orgCode);
            AsyncYtDeleteExamDataDTO param = new AsyncYtDeleteExamDataDTO();
            param.setId(id);
            param.setDataType(dataType);
            param.setHospitalCode(ytCode);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Accept", "application/json");
            headers.set("token", this.getYtToken());
            HttpEntity httpEntity = new HttpEntity((Object)MapUtils.object2Map((Object)param), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtAsyncResponse.class, new Object[0]);
            YtAsyncResponse ytAsyncResponse = (YtAsyncResponse)responseEntity.getBody();
            if (null == ytAsyncResponse) {
                this.sysLogYtAsyncService.saveAsyncYt(dataMsg, JSON.toJSONString((Object)param), Integer.valueOf(500), "\u8fd4\u56de\u5185\u5bb9\u4e3anull");
            } else if (ytAsyncResponse.getCode() == 0) {
                this.sysLogYtAsyncService.saveAsyncYt(dataMsg, JSON.toJSONString((Object)param), Integer.valueOf(200), ytAsyncResponse.getMessage());
            } else if (ytAsyncResponse.getCode() == 2001) {
                if (asyncNum < 2) {
                    this.asyncDeleteExamData(dataType, id, orgCode, asyncNum + 1);
                }
            } else {
                this.sysLogYtAsyncService.saveAsyncYt(dataMsg, JSON.toJSONString((Object)param), Integer.valueOf(500), ytAsyncResponse.getMessage());
            }
        }
    }

    private AsyncYtYanGuangBaseDTO setOdData(String odId, String examTime, String patientIdNumber, String hospitalCode, YanGuangBaseDTO dto, String uuid) {
        AsyncYtYanGuangBaseDTO odData = new AsyncYtYanGuangBaseDTO();
        odData.setUuid(uuid);
        odData.setAddXjg(dto.getAddXjgOd());
        odData.setAx(dto.getAxOd());
        odData.setCyl(dto.getCylOd());
        odData.setExamDoctorId(SecurityUser.getEmployeeId());
        odData.setExamDoctorName(SecurityUser.getUser().getRealName());
        odData.setId(odId);
        odData.setExamTime(examTime);
        odData.setHospitalCode(hospitalCode);
        odData.setK1D(dto.getK1DOd());
        odData.setK1R(dto.getK1ROd());
        odData.setK1Ax(dto.getK1AxOd());
        odData.setK2D(dto.getK2DOd());
        odData.setK2R(dto.getK2ROd());
        odData.setK2Ax(dto.getK2AxOd());
        odData.setKCylAx(dto.getkCylAxOd());
        odData.setKCylD(dto.getkCylDOd());
        odData.setKDAvg(dto.getkDAvgOd());
        odData.setKRAvg(dto.getkRAvgOd());
        odData.setPatientIdNumber(patientIdNumber);
        odData.setPd(dto.getPd());
        odData.setPsOd(dto.getPsOd());
        odData.setSe(dto.getSeOd());
        odData.setSph(dto.getSphOd());
        odData.setVa(dto.getVaOd());
        odData.setVd(dto.getVd());
        odData.setWtwOd(dto.getWtwOd());
        odData.setYgType(dto.getYgType());
        return odData;
    }

    private AsyncYtYanGuangBaseDTO setOsData(String osId, String examTime, String patientIdNumber, String hospitalCode, YanGuangBaseDTO dto, String uuid) {
        AsyncYtYanGuangBaseDTO osData = new AsyncYtYanGuangBaseDTO();
        osData.setUuid(uuid);
        osData.setAddXjg(dto.getAddXjgOs());
        osData.setAx(dto.getAxOs());
        osData.setCyl(dto.getCylOs());
        osData.setExamDoctorId(SecurityUser.getEmployeeId());
        osData.setExamDoctorName(SecurityUser.getUser().getRealName());
        osData.setId(osId);
        osData.setExamTime(examTime);
        osData.setHospitalCode(hospitalCode);
        osData.setK1D(dto.getK1DOs());
        osData.setK1R(dto.getK1ROs());
        osData.setK1Ax(dto.getK1AxOs());
        osData.setK2D(dto.getK2DOs());
        osData.setK2R(dto.getK2ROs());
        osData.setK2Ax(dto.getK2AxOs());
        osData.setKCylAx(dto.getkCylAxOs());
        osData.setKCylD(dto.getkCylDOs());
        osData.setKDAvg(dto.getkDAvgOs());
        osData.setKRAvg(dto.getkRAvgOs());
        osData.setPatientIdNumber(patientIdNumber);
        osData.setPd(dto.getPd());
        osData.setPsOs(dto.getPsOs());
        osData.setSe(dto.getSeOs());
        osData.setSph(dto.getSphOs());
        osData.setVa(dto.getVaOs());
        osData.setVd(dto.getVd());
        osData.setWtwOs(dto.getWtwOs());
        osData.setYgType(dto.getYgType());
        return osData;
    }

    private String getYtPatient(String patientIdNumber, String patientName, String ytToken, int queryNum) throws IllegalAccessException {
        block14: {
            String url = this.sysSystemConfService.getConfValue("100034", null);
            AsyncYtPatientDTO param = new AsyncYtPatientDTO();
            param.setPatientIdNumber(patientIdNumber);
            param.setPatientName(patientName);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders headers = new HttpHeaders();
                headers.set("Content-Type", "application/json");
                headers.set("Accept", "application/json");
                headers.set("token", ytToken);
                HttpEntity httpEntity = new HttpEntity((Object)MapUtils.object2Map((Object)param), (MultiValueMap)headers);
                try {
                    ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtPatientResponse.class, new Object[0]);
                    if (null == responseEntity) {
                        System.out.println("\u540c\u6b65\u533b\u77b3\u60a3\u8005uuid\uff0c\u63a5\u53e3\u8fd4\u56denull");
                        break block14;
                    }
                    YtPatientResponse ytPatientResponse = (YtPatientResponse)responseEntity.getBody();
                    if (null != ytPatientResponse) {
                        if (ytPatientResponse.getCode() == 0) {
                            YtPatient ytPatient = ytPatientResponse.getData();
                            if (null != ytPatient) {
                                this.ytDao.deleteYtPatient(patientIdNumber);
                                if (StringUtils.isNotBlank((CharSequence)ytPatient.getUuid())) {
                                    this.ytDao.insertYtPatient(ytPatient);
                                    return ytPatient.getUuid();
                                }
                                System.out.println("\u533b\u77b3\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u9519\u8bef,\u8fd4\u56de\u4fe1\u606f" + MapUtils.object2Map((Object)ytPatientResponse));
                            } else {
                                System.out.println("\u533b\u77b3\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u9519\u8bef,\u8fd4\u56de\u4fe1\u606f" + MapUtils.object2Map((Object)ytPatientResponse));
                            }
                        } else if (ytPatientResponse.getCode() == 2001) {
                            if (queryNum < 2) {
                                this.getYtPatient(patientIdNumber, patientName, ytToken, queryNum + 1);
                            }
                        } else {
                            System.out.println("\u533b\u77b3\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u9519\u8bef,\u8fd4\u56de\u4fe1\u606f" + MapUtils.object2Map((Object)ytPatientResponse));
                        }
                        break block14;
                    }
                    System.out.println("\u533b\u77b3\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u9519\u8bef,\u8fd4\u56de\u4fe1\u606f" + MapUtils.object2Map((Object)ytPatientResponse));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("\u533b\u77b3\u67e5\u8be2\u60a3\u8005\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a");
            }
        }
        return null;
    }

    private String getYtToken() {
        String cacheYtToken = LocalCacheUtil.get((String)"ytToken");
        if (cacheYtToken != null) {
            return cacheYtToken;
        }
        return this.forceGetYtToken();
    }

    public String forceGetYtToken() {
        String account = this.sysSystemConfService.getConfValue("100036", null);
        String pwd = this.sysSystemConfService.getConfValue("100037", null);
        String tokenUrl = this.sysSystemConfService.getConfValue("100035", null);
        if (StringUtils.isNotBlank((CharSequence)account) && StringUtils.isNotBlank((CharSequence)pwd) && StringUtils.isNotBlank((CharSequence)tokenUrl)) {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String signKey = DigestUtils.md5DigestAsHex((byte[])(pwd + timestamp).getBytes()).toLowerCase();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("account", account);
            data.put("sign_key", signKey);
            data.put("timestamp", timestamp);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Accept", "application/json");
            HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.exchange(tokenUrl, HttpMethod.POST, httpEntity, YtTokenResponse.class, new Object[0]);
            if (null == responseEntity) {
                System.out.println("\u83b7\u53d6\u533b\u77b3token\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            } else {
                YtTokenResponse ytTokenResponse = (YtTokenResponse)responseEntity.getBody();
                if (null != ytTokenResponse) {
                    if (ytTokenResponse.getCode() == 0) {
                        YtToken ytToken = ytTokenResponse.getData();
                        if (null != ytToken) {
                            if (StringUtils.isNotBlank((CharSequence)ytToken.getToken())) {
                                LocalCacheUtil.remove((String)"ytToken");
                                LocalCacheUtil.put((String)"ytToken", (String)ytToken.getToken(), (long)ytToken.getToken_expires());
                                return ytToken.getToken();
                            }
                            System.out.println("\u8bf7\u6c42\u533b\u77b3token\u63a5\u53e3\u5931\u8d25\uff0ctoken\u5185\u5bb9\u4e3a\u7a7a");
                        } else {
                            System.out.println("\u8bf7\u6c42\u533b\u77b3token\u63a5\u53e3\u5931\u8d25\uff0cdata\u5185\u5bb9\u4e3a\u7a7a");
                        }
                    } else {
                        System.out.println("\u83b7\u53d6\u533b\u77b3token\u63a5\u53e3\u9519\u8bef\uff0c\u8fd4\u56de\u9519\u8bef\u7f16\u7801\uff1a" + ytTokenResponse.getCode() + ",\u9519\u8bef\u5185\u5bb9\uff1a" + ytTokenResponse.getMsg());
                    }
                } else {
                    System.out.println("\u83b7\u53d6\u533b\u77b3token\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                }
            }
        } else {
            System.out.println("\u83b7\u53d6\u533b\u77b3token\u63a5\u53e3\uff0c\u63a5\u53e3\u5730\u5740\u3001\u8d26\u53f7\u3001\u5bc6\u7801\u4e0d\u5b8c\u6574");
        }
        return null;
    }

    @Async
    public void asyncDelPdf(String id, String patientIdNumber, String patientName, String orgCode, int asyncNum) throws IllegalAccessException {
        String url = this.sysSystemConfService.getConfValue("100033", null);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String ytToken = this.getYtToken();
            String uuid = this.getYtPatient(patientIdNumber, patientName, ytToken, 1);
            if (StringUtils.isBlank((CharSequence)uuid)) {
                return;
            }
            String ytCode = this.sysOrganService.getYtCodeByCode(orgCode);
            AsyncYtDeletePdfDTO param = new AsyncYtDeletePdfDTO();
            param.setId(id);
            param.setHospitalCode(ytCode);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            headers.set("Accept", "application/json");
            headers.set("token", ytToken);
            HttpEntity httpEntity = new HttpEntity((Object)MapUtils.object2Map((Object)param), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtAsyncResponse.class, new Object[0]);
            YtAsyncResponse ytAsyncResponse = (YtAsyncResponse)responseEntity.getBody();
            if (null == ytAsyncResponse) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u5220\u9664\u68c0\u67e5\u62a5\u544a\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), "\u8fd4\u56de\u5185\u5bb9\u4e3anull");
            } else if (ytAsyncResponse.getCode() == 0) {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u5220\u9664\u68c0\u67e5\u62a5\u544a\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(200), ytAsyncResponse.getMessage());
            } else if (ytAsyncResponse.getCode() == 2001) {
                if (asyncNum < 2) {
                    this.asyncDelPdf(id, patientIdNumber, patientName, orgCode, asyncNum + 1);
                }
            } else {
                this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u5220\u9664\u68c0\u67e5\u62a5\u544a\u6570\u636e", JSON.toJSONString((Object)param), Integer.valueOf(500), ytAsyncResponse.getMessage());
            }
        }
    }

    @Async
    public void asyncYtPdf(String fileId, String fileBase, String orgCode, int asyncNum) throws IllegalAccessException {
        String url = this.sysSystemConfService.getConfValue("100031", null);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String ytToken = this.getYtToken();
            AsyncYtPdfDTO pdfDTO = this.ytDao.getAsyncPdfInfo(fileId);
            if (null != pdfDTO) {
                pdfDTO.setFileBase(fileBase);
                String uuid = this.getYtPatient(pdfDTO.getPatientIdNumber(), pdfDTO.getPatientName(), ytToken, 1);
                if (StringUtils.isBlank((CharSequence)uuid)) {
                    return;
                }
                String ytCode = this.sysOrganService.getYtCodeByCode(orgCode);
                pdfDTO.setHospitalCode(ytCode);
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders headers = new HttpHeaders();
                headers.set("Content-Type", "application/json");
                headers.set("Accept", "application/json");
                headers.set("token", ytToken);
                HttpEntity httpEntity = new HttpEntity((Object)pdfDTO, (MultiValueMap)headers);
                ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, YtAsyncResponse.class, new Object[0]);
                YtAsyncResponse ytAsyncResponse = (YtAsyncResponse)responseEntity.getBody();
                if (null == ytAsyncResponse) {
                    this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u68c0\u67e5\u62a5\u544a\u6570\u636e", JSON.toJSONString((Object)pdfDTO), Integer.valueOf(500), "\u8fd4\u56de\u5185\u5bb9\u4e3anull");
                } else if (ytAsyncResponse.getCode() == 0) {
                    this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u68c0\u67e5\u62a5\u544a\u6570\u636e", JSON.toJSONString((Object)pdfDTO), Integer.valueOf(200), ytAsyncResponse.getMessage());
                } else if (ytAsyncResponse.getCode() == 2001) {
                    if (asyncNum < 2) {
                        this.asyncYtPdf(fileId, fileBase, orgCode, asyncNum + 1);
                    }
                } else {
                    this.sysLogYtAsyncService.saveAsyncYt("\u63a8\u9001\u68c0\u67e5\u62a5\u544a\u6570\u636e", JSON.toJSONString((Object)pdfDTO), Integer.valueOf(500), ytAsyncResponse.getMessage());
                }
            }
        }
    }
}

