/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.outside.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.IDUtils;
import io.huimu.common.utils.JsonUtils;
import io.huimu.common.utils.XmlUtils;
import io.huimu.modules.bdform.dao.BdFormDao;
import io.huimu.modules.bdform.dto.BdTemplateDTO;
import io.huimu.modules.bdform.dto.FormKeyValueDTO;
import io.huimu.modules.bdform.entity.BdFormEntity;
import io.huimu.modules.bdform.vo.BdFormVO;
import io.huimu.modules.examdatabrowse.dao.ExamDataBrowseDao;
import io.huimu.modules.examdatabrowse.vo.RegisterPatientVO;
import io.huimu.modules.hisregister.entity.HisRegisterEntity;
import io.huimu.modules.hisregister.service.HisRegisterService;
import io.huimu.modules.outside.dao.WjdcDao;
import io.huimu.modules.outside.dto.SaveWjdcDTO;
import io.huimu.modules.outside.dto.SaveWxFormDTO;
import io.huimu.modules.outside.param.GetPatientExamItemListParam;
import io.huimu.modules.outside.param.GetWjdcCountParam;
import io.huimu.modules.outside.param.GetWxPatientInfoParam;
import io.huimu.modules.outside.service.OutWjdcService;
import io.huimu.modules.outside.vo.WxExamResultVO;
import io.huimu.modules.outside.vo.WxPatientVO;
import io.huimu.modules.patient.dto.PatientDTO;
import io.huimu.modules.patient.service.PatientArchiveService;
import io.huimu.modules.patient.service.PatientService;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.upload.dto.ContentDTO;
import io.huimu.modules.upload.entity.UploadEntity;
import io.huimu.modules.upload.service.UploadService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OutWjdcService {
    @Autowired
    private HisRegisterService hisRegisterService;
    @Autowired
    private PatientArchiveService patientArchiveService;
    @Autowired
    private BdFormDao bdFormDao;
    @Autowired
    private WjdcDao wjdcDao;
    @Autowired
    private ExamDataBrowseDao browseDao;
    @Autowired
    private RegisterItemService registerItemService;
    @Autowired
    private UploadService uploadService;
    @Value(value="${dataBaseType}")
    private String dataBaseType;
    @Autowired
    private PatientService patientService;

    @Transactional(rollbackFor={Exception.class})
    public void saveWjdcInfo(SaveWjdcDTO param) throws IOException {
        StringBuffer valueBuffer;
        StringBuffer fieldBuffer;
        BdTemplateDTO bdTemplateDTO = this.bdFormDao.getTemplateInfo(param.getTemplateCode());
        if (null != bdTemplateDTO) {
            BdFormEntity bdFormEntity;
            String archiveId;
            ContentDTO contentDTO = new ContentDTO();
            contentDTO.setContent(param.getContent());
            contentDTO.setPath(param.getPath());
            UploadEntity uploadEntity = this.uploadService.writeToFile(contentDTO);
            UploadEntity jsonDataFileDTO = FileUtils.writeToFile((String)JsonUtils.toJsonString((Object)param.getDataList()), (String)bdTemplateDTO.getFtpPath(), (String)("jsonData/" + param.getPatientIdNumber()), null, (String)"txt");
            UploadEntity xmlDataFileDTO = FileUtils.writeToFile((String)XmlUtils.createXmlString((List)param.getDataList()), (String)bdTemplateDTO.getFtpPath(), (String)("xmlData/" + param.getPatientIdNumber()), null, (String)"txt");
            String formId = "";
            String dataRecordId = IDUtils.generateStringValue();
            HisRegisterEntity hisRegisterEntity = this.hisRegisterService.selectPatientId(param.getOrgCode(), param.getPatientIdNumber());
            if (null != hisRegisterEntity) {
                archiveId = this.patientArchiveService.getPatientLastArchiveId(hisRegisterEntity.getPatientId());
                bdFormEntity = new BdFormEntity();
                bdFormEntity.setFormDataRecordId(dataRecordId);
                bdFormEntity.setPatientId(hisRegisterEntity.getPatientId());
                bdFormEntity.setPatientIdNumber(param.getPatientIdNumber());
                bdFormEntity.setJzNumber(hisRegisterEntity.getJzNumber());
                bdFormEntity.setArchiveId(archiveId);
                bdFormEntity.setFormDate(DateUtils.format((Date)new Date()));
                bdFormEntity.setTemplateCode(param.getTemplateCode());
                bdFormEntity.setOrgCode(param.getOrgCode());
                bdFormEntity.setFormStatus(Integer.valueOf(10));
                bdFormEntity.setCreateDate(new Date());
                bdFormEntity.setIsDelete(Integer.valueOf(0));
                bdFormEntity.setIsSave(Integer.valueOf(5));
                bdFormEntity.setSaveDate(new Date());
                bdFormEntity.setSaveUserName(param.getPatientName());
                bdFormEntity.setSaveUserCode(param.getPatientIdNumber());
                bdFormEntity.setJsonDataFilePath(jsonDataFileDTO.getFilePath());
                bdFormEntity.setXmlDataFilePath(xmlDataFileDTO.getFilePath());
                bdFormEntity.setHtmlPath(uploadEntity.getFilePath());
                bdFormEntity.setSaveNum(Integer.valueOf(1));
                this.bdFormDao.insert((Object)bdFormEntity);
                formId = bdFormEntity.getId();
            } else {
                archiveId = this.patientArchiveService.getPatientLastArchiveIdByPatientIdNumber(param.getPatientIdNumber());
                bdFormEntity = new BdFormEntity();
                bdFormEntity.setFormDataRecordId(dataRecordId);
                bdFormEntity.setPatientIdNumber(param.getPatientIdNumber());
                bdFormEntity.setArchiveId(archiveId);
                bdFormEntity.setFormDate(DateUtils.format((Date)new Date()));
                bdFormEntity.setTemplateCode(param.getTemplateCode());
                bdFormEntity.setOrgCode(param.getOrgCode());
                bdFormEntity.setFormStatus(Integer.valueOf(10));
                bdFormEntity.setIsSave(Integer.valueOf(5));
                bdFormEntity.setCreateDate(new Date());
                bdFormEntity.setIsDelete(Integer.valueOf(0));
                bdFormEntity.setSaveDate(new Date());
                bdFormEntity.setSaveUserName(param.getPatientName());
                bdFormEntity.setSaveUserCode(param.getPatientIdNumber());
                bdFormEntity.setJsonDataFilePath(jsonDataFileDTO.getFilePath());
                bdFormEntity.setXmlDataFilePath(xmlDataFileDTO.getFilePath());
                bdFormEntity.setHtmlPath(uploadEntity.getFilePath());
                bdFormEntity.setSaveNum(Integer.valueOf(1));
                this.bdFormDao.insert((Object)bdFormEntity);
                formId = bdFormEntity.getId();
            }
            fieldBuffer = new StringBuffer();
            valueBuffer = new StringBuffer();
            fieldBuffer.append("ID,FORM_ID,IS_DELETE,CREATE_DATE,SAVE_USER_CODE,SAVE_USER_NAME,SAVE_DATE,HTML_PATH,PDF_PATH,IS_CA,CA_PDF_PATH,JSON_DATA_FILE_PATH,XML_DATA_FILE_PATH,ORG_CODE,DEPT_CODE");
            valueBuffer.append("'").append(dataRecordId).append("', ").append("'").append(formId).append("', ").append(0).append(", ").append(this.dataBaseType.equalsIgnoreCase("oracle") ? "sysdate " : "sysdate() ").append(", ").append(StringUtils.isBlank((CharSequence)param.getPatientIdNumber()) ? null + "," : "'" + param.getPatientIdNumber() + "', ").append(StringUtils.isBlank((CharSequence)param.getPatientName()) ? null + "," : "'" + param.getPatientName() + "', ").append(this.dataBaseType.equalsIgnoreCase("oracle") ? "sysdate " : "sysdate() ").append(", ").append("'").append("', ").append("'").append("', ").append("0").append(", ").append("null").append(", ").append(StringUtils.isBlank((CharSequence)jsonDataFileDTO.getFilePath()) ? null + "," : "'" + jsonDataFileDTO.getFilePath() + "', ").append(StringUtils.isBlank((CharSequence)xmlDataFileDTO.getFilePath()) ? null + "," : "'" + xmlDataFileDTO.getFilePath() + "', ").append(StringUtils.isBlank((CharSequence)param.getOrgCode()) ? null + "," : "'" + param.getOrgCode() + "', ").append("'").append("' ");
            if (CollUtil.isNotEmpty((Collection)param.getDataList())) {
                1 fieldList = new /* Unavailable Anonymous Inner Class!! */;
                for (FormKeyValueDTO valueDTO : param.getDataList()) {
                    if (valueDTO.getKey().startsWith("SIGN") || valueDTO.getKey().startsWith("EIMG") || valueDTO.getKey().startsWith("IIMG") || fieldList.contains(valueDTO.getKey())) continue;
                    fieldBuffer.append(",").append(valueDTO.getKey());
                    valueBuffer.append(StringUtils.isBlank((CharSequence)valueDTO.getValue()) ? "," + null : ",'" + valueDTO.getValue() + "'");
                    fieldList.add(valueDTO.getKey());
                }
            }
        } else {
            throw new RenException("\u8868\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into ").append(bdTemplateDTO.getBindTableName()).append(" (").append(fieldBuffer).append(" ) values ").append("( ").append(valueBuffer).append(")");
        this.wjdcDao.insertWjdc(sqlBuffer.toString());
        StringBuffer sqlBufferRecord = new StringBuffer();
        sqlBufferRecord.append("insert into ").append(bdTemplateDTO.getBindTableName() + "_RECORD").append(" (").append(fieldBuffer).append(" ) values ").append("( ").append(valueBuffer).append(")");
        this.wjdcDao.insertWjdc(sqlBufferRecord.toString());
    }

    public WxExamResultVO getWxExamItemList(GetPatientExamItemListParam param) {
        List<String> pids = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)param.getPatientIdNumber())) {
            pids = this.browseDao.getPIdsByIdNumber(param.getPatientIdNumber());
        }
        if (null == pids) {
            pids = new ArrayList();
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPatientId())) {
            pids.add(param.getPatientId());
        }
        if (CollUtil.isNotEmpty(pids)) {
            RegisterPatientVO registerPatientVO = this.browseDao.getBrowsePatientInfo(param.getPatientId(), param.getPatientIdNumber());
            WxExamResultVO vo = (WxExamResultVO)ConvertUtils.sourceToTarget((Object)registerPatientVO, WxExamResultVO.class);
            if (null == vo) {
                vo = new WxExamResultVO();
            }
            if (CollUtil.isNotEmpty(pids)) {
                vo.setExamItemList(this.registerItemService.getWxExamItemList(pids, param.getBeginDate(), param.getEndDate()));
            }
            return vo;
        }
        throw new RenException("\u627e\u4e0d\u5230\u60a3\u8005\u4fe1\u606f");
    }

    public String queryTemplateContent(String templateCode) {
        BdTemplateDTO templateDTO = this.bdFormDao.getTemplateInfo(templateCode);
        if (null != templateDTO) {
            if (StringUtils.isNotBlank((CharSequence)templateDTO.getFtpPath()) && StringUtils.isNotBlank((CharSequence)templateDTO.getHtmlPath())) {
                return FileUtils.getFileContent((String)templateDTO.getHtmlPath(), (String)templateDTO.getFtpPath());
            }
            throw new RenException("\u914d\u7f6e\u4fe1\u606f\u7f3a\u5c11FTP\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        throw new RenException("\u6a21\u677f\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    public String queryFormContent(String fromId) {
        BdFormVO formVO = this.bdFormDao.getFormInfoById(fromId);
        if (null != formVO) {
            if (StringUtils.isNotBlank((CharSequence)formVO.getFtpPath()) && StringUtils.isNotBlank((CharSequence)formVO.getHtmlPath())) {
                return FileUtils.getFileContent((String)formVO.getHtmlPath(), (String)formVO.getFtpPath());
            }
            throw new RenException("\u914d\u7f6e\u4fe1\u606f\u7f3a\u5c11FTP\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        throw new RenException("\u5185\u5bb9\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public WxPatientVO getWxPatientInfo(GetWxPatientInfoParam param) {
        return this.browseDao.getWxPatientInfo(param.getPatientIdNumber());
    }

    public void saveWxFormInfo(SaveWxFormDTO param) throws IOException {
        BdFormVO formVO = this.bdFormDao.getFormInfoById(param.getFormId());
        if (null == formVO) {
            throw new RenException("\u672a\u67e5\u8be2\u5230\u8868\u5355");
        }
        if (1 == formVO.getIsDelete()) {
            throw new RenException("\u8868\u5355\u5df2\u88ab[" + formVO.getDelUserName() + "]\u5220\u9664");
        }
        PatientDTO patientDTO = this.patientService.getInfo(formVO.getPatientId(), formVO.getOrgCode());
        if (null == patientDTO) {
            throw new RenException("\u60a3\u8005\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UploadEntity jsonDataFileDTO = FileUtils.writeToFile((String)JsonUtils.toJsonString((Object)param.getDataList()), (String)formVO.getFtpPath(), (String)("jsonData/" + formVO.getPatientId()), null, (String)"txt");
        UploadEntity xmlDataFileDTO = FileUtils.writeToFile((String)XmlUtils.createXmlString((List)param.getDataList()), (String)formVO.getFtpPath(), (String)("xmlData/" + formVO.getPatientId()), null, (String)"txt");
        this.bdFormDao.deleteFormData(formVO.getBindTableName(), param.getFormId());
        List dataList = param.getDataList();
        String dataRecordId = null;
        if (CollUtil.isNotEmpty((Collection)dataList)) {
            dataRecordId = IDUtils.generateStringValue();
            2 fieldList = new /* Unavailable Anonymous Inner Class!! */;
            StringBuffer fieldBuffer = new StringBuffer();
            StringBuffer valueBuffer = new StringBuffer();
            fieldBuffer.append("ID,FORM_ID,IS_DELETE,CREATE_DATE,SAVE_USER_CODE,SAVE_USER_NAME,SAVE_DATE,HTML_PATH,PDF_PATH,IS_CA,CA_PDF_PATH,JSON_DATA_FILE_PATH,XML_DATA_FILE_PATH,ORG_CODE,DEPT_CODE ");
            valueBuffer.append("'").append(dataRecordId).append("', ").append("'").append(param.getFormId()).append("', ").append(0).append(", ").append(this.dataBaseType.equalsIgnoreCase("oracle") ? "sysdate " : "sysdate() ").append(", ").append("'").append(patientDTO.getPatientId()).append("', ").append("'").append(patientDTO.getPatientName()).append("', ").append(this.dataBaseType.equalsIgnoreCase("oracle") ? "sysdate " : "sysdate() ").append(", ").append(StringUtils.isBlank((CharSequence)param.getHtmlPath()) ? null + "," : "'" + param.getHtmlPath() + "', ").append(StringUtils.isBlank((CharSequence)param.getPdfPath()) ? null + "," : "'" + param.getPdfPath() + "', ").append("0,").append(StringUtils.isBlank((CharSequence)param.getPdfPath()) ? null + "," : "'" + param.getPdfPath() + "', ").append(StringUtils.isBlank((CharSequence)jsonDataFileDTO.getFilePath()) ? null + "," : "'" + jsonDataFileDTO.getFilePath() + "', ").append(StringUtils.isBlank((CharSequence)xmlDataFileDTO.getFilePath()) ? null + "," : "'" + xmlDataFileDTO.getFilePath() + "', ").append(StringUtils.isBlank((CharSequence)formVO.getOrgCode()) ? null + "," : "'" + formVO.getOrgCode() + "', ").append(StringUtils.isBlank((CharSequence)formVO.getDeptCode()) ? null + "," : "'" + formVO.getDeptCode() + "' ");
            for (FormKeyValueDTO valueDTO : dataList) {
                if (valueDTO.getKey().startsWith("SIGN") || valueDTO.getKey().startsWith("EIMG") || valueDTO.getKey().startsWith("IIMG") || fieldList.contains(valueDTO.getKey())) continue;
                fieldBuffer.append(",").append(valueDTO.getKey());
                valueBuffer.append(StringUtils.isBlank((CharSequence)valueDTO.getValue()) ? "," + null : ",'" + valueDTO.getValue() + "'");
                fieldList.add(valueDTO.getKey());
            }
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("insert into ").append(formVO.getBindTableName()).append(" (").append(fieldBuffer).append(" ) values ").append("( ").append(valueBuffer).append(")");
            this.bdFormDao.saveFormData(sqlBuffer);
            StringBuffer recordSqlBuffer = new StringBuffer();
            recordSqlBuffer.append("insert into ").append(formVO.getBindTableName()).append("_RECORD").append(" (").append(fieldBuffer).append(" ) values ").append("( ").append(valueBuffer).append(")");
            this.bdFormDao.saveFormData(recordSqlBuffer);
        }
        BdFormEntity entity = new BdFormEntity();
        entity.setId(param.getFormId());
        entity.setIsSave(Integer.valueOf(5));
        entity.setSaveDate(new Date());
        entity.setFormDataRecordId(dataRecordId);
        entity.setIsLock(Integer.valueOf(0));
        entity.setLockUserCode("");
        entity.setLockUserName("");
        entity.setSaveUserCode(formVO.getPatientId());
        entity.setSaveUserName(patientDTO.getPatientName());
        entity.setHtmlPath(param.getHtmlPath());
        entity.setPdfPath(param.getPdfPath());
        entity.setIsCa(Integer.valueOf(0));
        entity.setCaPdfPath(param.getPdfPath());
        entity.setJsonDataFilePath(jsonDataFileDTO.getFilePath());
        entity.setXmlDataFilePath(jsonDataFileDTO.getFilePath());
        entity.setOrgCode(formVO.getOrgCode());
        entity.setDeptCode(formVO.getDeptCode());
        entity.setSaveNum(Integer.valueOf(formVO.getSaveNum() + 1));
        entity.setFormStatus(Integer.valueOf(10));
        this.bdFormDao.updateById((Object)entity);
    }

    public Integer getWjdcCount(GetWjdcCountParam param) {
        Integer count = this.bdFormDao.selectCount((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id_number", (Object)param.getPatientIdNumber())).eq((Object)"template_code", (Object)param.getTemplateCode())).eq((Object)"form_date", (Object)DateUtils.format((Date)new Date()))).eq((Object)"is_delete", (Object)0));
        return count;
    }
}

