/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.outside.controller;

import com.alibaba.fastjson.JSON;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.exception.RenException;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.IDUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.bdform.dto.ChangeFormHcDTO;
import io.huimu.modules.bdform.service.BdFormService;
import io.huimu.modules.dict.service.DictOperaParamService;
import io.huimu.modules.license.dto.DecryptLicenseDTO;
import io.huimu.modules.license.dto.LicenseDTO;
import io.huimu.modules.license.service.LicenseService;
import io.huimu.modules.license.vo.LicenseVO;
import io.huimu.modules.littlecheck.param.GetExamDataParam;
import io.huimu.modules.littlecheck.service.LittleCheckService;
import io.huimu.modules.outside.dto.OcrFileDTO;
import io.huimu.modules.outside.dto.SaveWjdcDTO;
import io.huimu.modules.outside.dto.SaveWxFormDTO;
import io.huimu.modules.outside.dto.UploadSqwtsFileDTO;
import io.huimu.modules.outside.param.AsyncZeissFileParam;
import io.huimu.modules.outside.param.GetPatientExamItemListParam;
import io.huimu.modules.outside.param.GetWjdcCountParam;
import io.huimu.modules.outside.param.GetWxPatientInfoParam;
import io.huimu.modules.outside.param.GetWxXjListParam;
import io.huimu.modules.outside.param.QueryFormContentParam;
import io.huimu.modules.outside.param.QueryTemplateContentParam;
import io.huimu.modules.outside.param.SaveWxInfoParam;
import io.huimu.modules.outside.service.OutWjdcService;
import io.huimu.modules.outside.vo.OperaReturnVO;
import io.huimu.modules.outside.vo.WxExamResultVO;
import io.huimu.modules.outside.vo.WxPatientVO;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.sqwts.service.SqwtsService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.upload.dto.ContentDTO;
import io.huimu.modules.upload.entity.UploadEntity;
import io.huimu.modules.upload.service.UploadService;
import io.huimu.modules.wx.service.WxOpenIdService;
import io.huimu.modules.wx.service.WxService;
import io.huimu.modules.xj.service.XjService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.tess4j.Tesseract;
import net.sourceforge.tess4j.TesseractException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/out/side"})
@Api(tags={"\u5bf9\u5916\u63a5\u53e3\u7ba1\u7406"})
public class OutsideController {
    private static final Logger log = LoggerFactory.getLogger(OutsideController.class);
    @Autowired
    private OutWjdcService outWjdcService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private SqwtsService sqwtsService;
    @Autowired
    private WxService wxService;
    @Autowired
    private WxOpenIdService wxOpenIdService;
    @Autowired
    private RegisterItemService registerItemService;
    @Autowired
    private XjService xjService;
    @Autowired
    private DictOperaParamService dictOperaParamService;
    @Autowired
    private LittleCheckService littleCheckService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private BdFormService bdFormService;

    @PostMapping(value={"saveWjdcInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u95ee\u5377\u8c03\u67e5")
    public Result saveWjdcInfo(@RequestBody SaveWjdcDTO param) throws IOException {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        this.outWjdcService.saveWjdcInfo(param);
        return new Result();
    }

    @PostMapping(value={"getWjdcCount"})
    @ApiOperation(value="\u83b7\u53d6\u95ee\u5377\u8c03\u67e5\u662f\u5426\u5b58\u5728")
    public Result getWjdcCount(@RequestBody GetWjdcCountParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        Integer count = this.outWjdcService.getWjdcCount(param);
        return new Result().ok((Object)count);
    }

    @PostMapping(value={"saveWxFormInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u5fae\u4fe1\u8868\u5355\u4fe1\u606f")
    public Result saveWxFormInfo(@RequestBody SaveWxFormDTO param) throws IOException {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        this.outWjdcService.saveWxFormInfo(param);
        return new Result();
    }

    @PostMapping(value={"queryTemplateContent"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5185\u5bb9")
    public Result queryTemplateContent(@RequestBody QueryTemplateContentParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        String content = this.outWjdcService.queryTemplateContent(param.getTemplateCode());
        return new Result().ok((Object)content);
    }

    @PostMapping(value={"queryFormContent"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u5185\u5bb9")
    public Result queryFormContent(@RequestBody QueryFormContentParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        String content = this.outWjdcService.queryFormContent(param.getFromId());
        return new Result().ok((Object)content);
    }

    @PostMapping(value={"saveWxInfo"})
    @ApiOperation(value="\u4fdd\u5b58\u5fae\u4fe1\u4fe1\u606f")
    public Result saveWxInfo(@RequestBody SaveWxInfoParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        String openid = this.wxService.getWebAccessTokenAndOpenid(param.getCode());
        if (StringUtils.isNotBlank((CharSequence)openid)) {
            this.wxOpenIdService.saveOrUpdate(param.getCode(), param.getPatientIdNumber(), openid);
        }
        return new Result();
    }

    @PostMapping(value={"getWxExamItemList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u5217\u8868")
    public Result getWxExamItemList(@RequestBody GetPatientExamItemListParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        if (StringUtils.isBlank((CharSequence)param.getPatientId()) && StringUtils.isBlank((CharSequence)param.getPatientIdNumber())) {
            throw new RenException("\u75c5\u5386\u53f7\u548c\u8eab\u4efd\u8bc1\u81f3\u5c11\u4f20\u4e00\u4e2a");
        }
        WxExamResultVO dataVO = this.outWjdcService.getWxExamItemList(param);
        return new Result().ok((Object)dataVO);
    }

    @PostMapping(value={"getExamDataList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u6570\u636e")
    public Result<List<LinkedHashMap<String, String>>> getExamDataList(@RequestBody GetExamDataParam req) {
        List list = this.littleCheckService.getExamDataList(req);
        return new Result().ok((Object)list);
    }

    @PostMapping(value={"getWxPatientInfo"})
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u60a3\u8005\u4fe1\u606f")
    public Result getWxPatientInfo(@RequestBody GetWxPatientInfoParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        WxPatientVO dataVO = this.outWjdcService.getWxPatientInfo(param);
        return new Result().ok((Object)dataVO);
    }

    @PostMapping(value={"uploadSqwtsFile"})
    @ApiOperation(value="\u4e0a\u4f20\u6388\u6743\u59d4\u6258\u4e66\u6587\u4ef6")
    public Result uploadSqwtsFile(@RequestBody UploadSqwtsFileDTO param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        this.sqwtsService.uploadSqwtsFile(param);
        return new Result();
    }

    @PostMapping(value={"asyncZeissFile"})
    @ApiOperation(value="\u540c\u6b65\u8521\u53f8\u6587\u4ef6")
    public Result asyncZeissFile(@RequestBody AsyncZeissFileParam param) {
        this.registerItemService.asyncZeissFile(param);
        return new Result();
    }

    @PostMapping(value={"getWxXjList"})
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u5ba3\u6559\u5217\u8868")
    public Result getWxXjList(@RequestBody GetWxXjListParam param) {
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        List list = this.xjService.getWxXjList(param.getPatientIdNumber(), param.getType());
        return new Result().ok((Object)list);
    }

    @ApiOperation(value="ocr\u6587\u4ef6")
    @PostMapping(value={"ocrFile"})
    @DecryptAndVerify(decryptedClass=OcrFileDTO.class)
    public Result ocrImage(@RequestBody EncryptedReq<OcrFileDTO> req) throws IOException, TesseractException {
        OcrFileDTO dto = (OcrFileDTO)req.getData();
        ConvertUtils.sourceToTarget((Object)dto, DefaultGroup.class);
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        String ocrDataPath = this.sysSystemConfService.getConfValue("100041", null);
        String parentDir = IDUtils.generateStringValue();
        Tesseract tesseract = new Tesseract();
        tesseract.setDatapath(ocrDataPath);
        tesseract.setLanguage("eng");
        if (dto.getFileType() == 1) {
            UploadEntity entity = FileUtils.base64ToImg((String)dto.getBase(), (String)ftpPath, (String)("ocr_file/" + parentDir));
            String filePath = ftpPath + "/" + entity.getFilePath();
            File dirfile = new File(filePath);
            BufferedImage image = ImageIO.read(dirfile);
            String result = tesseract.doOCR(image);
            return new Result().ok(req.getEncode(), (Object)result);
        }
        if (dto.getFileType() == 2) {
            UploadEntity entity = FileUtils.base64ToFile((String)dto.getBase(), (String)"pdf", (String)ftpPath, (String)("ocr_file/" + parentDir));
            List images = this.pdf2Image(ftpPath + "/" + entity.getFileDirPath(), ftpPath + "/" + entity.getFilePath());
            StringBuilder stringBuilder = new StringBuilder();
            for (String imagePath : images) {
                File dirfile = new File(imagePath);
                BufferedImage image = ImageIO.read(dirfile);
                stringBuilder.append(tesseract.doOCR(image));
            }
            return new Result().ok(req.getEncode(), (Object)stringBuilder.toString());
        }
        return new Result().error("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
    }

    private List<String> pdf2Image(String parentPath, String filePath) {
        ArrayList<String> imagePaths = new ArrayList<String>();
        try {
            PDDocument document = PDDocument.load((File)new File(filePath));
            PDFRenderer renderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage img = renderer.renderImageWithDPI(i, 300.0f);
                File file = new File(parentPath + "/" + i + ".JPEG");
                ImageIO.write((RenderedImage)img, "JPEG", file);
                imagePaths.add(parentPath + "/" + i + ".JPEG");
            }
            document.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imagePaths;
    }

    @GetMapping(value={"getOperaList"})
    @ApiOperation(value="\u83b7\u53d6\u5c48\u5149\u624b\u672f\u5217\u8868")
    public List<OperaReturnVO> getOperaList() {
        List list = this.dictOperaParamService.getOperaNameList();
        return list;
    }

    @PostMapping(value={"checkLicense"})
    @ApiOperation(value="\u6821\u9a8c\u7cfb\u7edf\u6388\u6743\u7801")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<LicenseVO> checkLicense(@RequestBody EncryptedReq<NoParam> req) throws IOException {
        LicenseVO dto = this.licenseService.checkLicense();
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"saveLicense"})
    @ApiOperation(value="\u4fdd\u5b58\u6388\u6743\u7801")
    public Result saveLicense(@RequestBody EncryptedReq<LicenseDTO> req) {
        LicenseDTO dto = (LicenseDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        LicenseVO vo = this.licenseService.saveLicense(dto);
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"createLicense"})
    @ApiOperation(value="\u751f\u6210\u6388\u6743\u7801")
    public Result createLicense(@RequestBody DecryptLicenseDTO dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        String license = this.licenseService.createLicense(dto);
        return new Result().ok((Object)license);
    }

    @PostMapping(value={"writeToFile"})
    @ApiOperation(value="\u5185\u5bb9\u5199\u5165\u6587\u4ef6")
    public Result writeToFile(@RequestBody ContentDTO dto) throws IOException {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        UploadEntity entity = this.uploadService.writeToFile(dto);
        return new Result().ok((Object)entity);
    }

    @PostMapping(value={"htmlToPdf"})
    @ApiOperation(value="\u75c5\u5386html\u8f6cpdf")
    public Result htmlToPdf(@RequestBody ContentDTO dto) throws IOException {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        UploadEntity uploadEntity = this.uploadService.htmlToPdf(dto);
        return new Result().ok((Object)uploadEntity);
    }

    @PostMapping(value={"changeFormHc"})
    @ApiOperation(value="\u6539\u53d8\u8868\u5355\u6838\u67e5\u72b6\u6001")
    public Result changeFormHc(@RequestBody ChangeFormHcDTO dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        System.out.println("\u6539\u53d8\u6838\u67e5\u72b6\u6001\uff1a" + JSON.toJSONString((Object)dto));
        this.bdFormService.changeFormHc(dto);
        return new Result();
    }
}

