/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.opera.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.MyDateUtils;
import io.huimu.modules.opera.dao.QgNumSourceDao;
import io.huimu.modules.opera.dto.CopyQgNumberSourceDTO;
import io.huimu.modules.opera.dto.CreateQgNumSourceDTO;
import io.huimu.modules.opera.dto.QgNumSourceDTO;
import io.huimu.modules.opera.entity.QgNumSourceEntity;
import io.huimu.modules.opera.param.GetNumSourceListParam;
import io.huimu.modules.opera.service.QgNumSourceService;
import io.huimu.modules.opera.vo.DoctorOperaScheduleVO;
import io.huimu.modules.opera.vo.EveryDayInfoVO;
import io.huimu.modules.opera.vo.QgNumSourceVO;
import io.huimu.modules.opera.vo.WeekInfoVO;
import io.huimu.modules.sys.service.SysUserService;
import io.huimu.modules.sys.vo.DoctorVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QgNumSourceServiceImpl
extends BaseServiceImpl<QgNumSourceDao, QgNumSourceEntity>
implements QgNumSourceService {
    @Autowired
    private SysUserService sysUserService;

    @Transactional(rollbackFor={Exception.class})
    public void saveSource(List<QgNumSourceDTO> body) {
        this.insertBatch((Collection)ConvertUtils.sourceToTarget(body, QgNumSourceEntity.class));
        this.reSortNumSource(body.get(0).getDoctorCode(), body.get(0).getAppointmentDate(), body.get(0).getMorOrAft(), body.get(0).getSourceFlag());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String[] ids) {
        QgNumSourceEntity delEntity = (QgNumSourceEntity)((QgNumSourceDao)this.baseDao).selectById((Serializable)((Object)ids[0]));
        ((QgNumSourceDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"ID", Arrays.asList(ids))).ne((Object)"STATUS", (Object)1));
        this.reSortNumSource(delEntity.getDoctorCode(), delEntity.getAppointmentDate(), delEntity.getMorOrAft(), delEntity.getSourceFlag());
    }

    private void reSortNumSource(String doctorCode, String appointmentDate, Integer morOrAft, Integer sourceFlag) {
        List list = ((QgNumSourceDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DOCTOR_CODE", (Object)doctorCode)).eq((Object)"APPOINTMENT_DATE", (Object)appointmentDate)).eq((Object)"SOURCE_FLAG", (Object)sourceFlag)).eq((Object)"MOR_OR_AFT", (Object)morOrAft)).orderByAsc((Object)"APPOINTMENT_TIME"));
        ArrayList<QgNumSourceEntity> updateList = new ArrayList<QgNumSourceEntity>();
        for (int i = 0; i < list.size(); ++i) {
            QgNumSourceEntity entity = new QgNumSourceEntity();
            entity.setId(((QgNumSourceEntity)list.get(i)).getId());
            entity.setSerialNo(Integer.valueOf(i + 1));
            updateList.add(entity);
        }
        if (CollUtil.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }

    public List<QgNumSourceDTO> createNumSource(CreateQgNumSourceDTO dto) {
        Date baseDate = DateUtils.stringToDate((String)(dto.getAppointmentDate() + " " + dto.getStartTime()), (String)"yyyy-MM-dd HH:mm:ss");
        Integer morOrAft = MyDateUtils.judgeMorningOrAfternoon((Date)baseDate);
        QgNumSourceEntity existNumSource = ((QgNumSourceDao)this.baseDao).getLastNumSource(dto.getDoctorCode(), dto.getAppointmentDate(), dto.getSourceFlag(), morOrAft);
        if (null != existNumSource) {
            int sourceDay;
            if (dto.getStartNum() <= existNumSource.getSerialNo()) {
                throw new RenException("\u8d77\u59cb\u53f7\u9700\u8981\u6392\u5728\u6700\u5927\u6392\u53f0\u53f7\u540e");
            }
            Date existMaxDate = DateUtils.stringToDate((String)(existNumSource.getAppointmentDate() + " " + existNumSource.getAppointmentTime()), (String)"yyyy-MM-dd HH:mm:ss");
            if (baseDate.getTime() <= existMaxDate.getTime()) {
                throw new RenException("\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5df2\u751f\u6210\u7684\u6700\u5927\u9884\u7ea6\u65f6\u95f4");
            }
            Date date = DateUtils.addDateMinutes((Date)DateUtils.stringToDate((String)(dto.getAppointmentDate() + " " + existNumSource.getAppointmentTime()), (String)"yyyy-MM-dd HH:mm:ss"), (int)dto.getInterval());
            int changeDay = Integer.valueOf(DateUtils.format((Date)date, (String)"dd"));
            if (changeDay != (sourceDay = Integer.valueOf(StringUtils.split((String)dto.getAppointmentDate(), (String)"-")[2]).intValue())) {
                throw new RenException("\u751f\u6210\u7684\u9884\u7ea6\u65f6\u95f4\u5df2\u7ecf\u4e0d\u5c5e\u4e8e\u5f53\u5929");
            }
            dto.setStartTime(DateUtils.format((Date)date, (String)"HH:mm:ss"));
        }
        int day = Integer.valueOf(StringUtils.split((String)dto.getAppointmentDate(), (String)"-")[2]);
        ArrayList<QgNumSourceDTO> resList = new ArrayList<QgNumSourceDTO>();
        QgNumSourceDTO dto1 = null;
        for (int i = 0; i < dto.getTotal(); ++i) {
            dto1 = new QgNumSourceDTO();
            Date appointmentDate = DateUtils.addDateMinutes((Date)baseDate, (int)(dto.getInterval() * i));
            int d = Integer.valueOf(DateUtils.format((Date)appointmentDate, (String)"dd"));
            if (day != d) break;
            String appointmentTime = DateUtils.format((Date)appointmentDate, (String)"HH:mm:ss");
            int hour = Integer.valueOf(StringUtils.split((String)appointmentTime, (String)":")[0]);
            if (morOrAft == 1 && hour >= 12 || morOrAft == 2 && hour >= 24) break;
            dto1.setDoctorCode(dto.getDoctorCode());
            dto1.setSerialNo(Integer.valueOf(dto.getStartNum() + i));
            dto1.setAppointmentDate(dto.getAppointmentDate());
            dto1.setAppointmentTime(appointmentTime);
            dto1.setMorOrAft(morOrAft);
            dto1.setOrgCode(dto.getOrgCode());
            Date date = DateUtils.stringToDate((String)(dto.getAppointmentDate() + " " + appointmentTime), (String)"yyyy-MM-dd HH:mm:ss");
            if (date.getTime() < System.currentTimeMillis()) {
                dto1.setStatus(Integer.valueOf(2));
            } else {
                dto1.setStatus(Integer.valueOf(0));
            }
            resList.add(dto1);
            dto1.setSourceFlag(dto.getSourceFlag());
        }
        return resList;
    }

    public List<QgNumSourceVO> getList(GetNumSourceListParam param) {
        List resList = ((QgNumSourceDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)param.getOrgCode())).eq((Object)"DOCTOR_CODE", (Object)param.getDoctorCode())).eq((Object)"APPOINTMENT_DATE", (Object)param.getSearchDate())).eq((Object)"SOURCE_FLAG", (Object)param.getSourceFlag())).eq((Object)"MOR_OR_AFT", (Object)param.getMorOrAft())).orderByAsc((Object)"SERIAL_NO,APPOINTMENT_TIME"));
        for (QgNumSourceEntity entity : resList) {
            Date date = DateUtils.stringToDate((String)(entity.getAppointmentDate() + " " + entity.getAppointmentTime()), (String)"yyyy-MM-dd HH:mm:ss");
            if (date.getTime() >= System.currentTimeMillis() || entity.getStatus() != 0) continue;
            entity.setStatus(Integer.valueOf(2));
        }
        return ConvertUtils.sourceToTarget((Collection)resList, QgNumSourceVO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void copyNumberSource(CopyQgNumberSourceDTO dto) {
        Date paramDate = DateUtils.stringToDate((String)dto.getSearchDate(), (String)"yyyy-MM-dd");
        List oneWeekendList = MyDateUtils.getOneWeekend((Date)paramDate);
        int count = ((QgNumSourceDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)dto.getOrgCode())).eq((Object)"SOURCE_FLAG", (Object)dto.getType())).in((Object)"APPOINTMENT_DATE", (Collection)oneWeekendList));
        if (count > 0) {
            throw new RenException("\u5f53\u524d\u5468\u5df2\u5b58\u5728\u653e\u53f7\u6570\u636e\uff0c\u65e0\u6cd5\u590d\u5236\u4e0a\u5468\u53f7\u6e90\u6570\u636e");
        }
        Date lastDay = DateUtils.addDateDays((Date)paramDate, (int)-7);
        List lastOneWeekendList = MyDateUtils.getOneWeekend((Date)lastDay);
        List lastOneWeekend = ((QgNumSourceDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)dto.getOrgCode())).eq((Object)"SOURCE_FLAG", (Object)dto.getType())).in((Object)"APPOINTMENT_DATE", (Collection)lastOneWeekendList));
        if (null == lastOneWeekend || lastOneWeekend.size() <= 0) {
            throw new RenException("\u4e0a\u5468\u4e0d\u5b58\u5728\u53f7\u6e90\u6570\u636e");
        }
        lastOneWeekend.stream().peek(x -> {
            x.setId(null);
            x.setStatus(Integer.valueOf(0));
            x.setCreateDate(new Date());
            Date date = DateUtils.addDateDays((Date)DateUtils.stringToDate((String)x.getAppointmentDate(), (String)"yyyy-MM-dd"), (int)7);
            x.setAppointmentDate(DateUtils.format((Date)date));
        }).collect(Collectors.toList());
        List parts = ListUtils.partition((List)lastOneWeekend, (int)100);
        parts.stream().forEach(list -> this.insertBatch((Collection)list));
    }

    public List<DoctorOperaScheduleVO> getScheduleList(Map<String, Object> params) {
        String searchDate = (String)params.get("searchDate");
        Integer type = (Integer)params.get("type");
        String orgCode = (String)params.get("orgCode");
        ArrayList<DoctorOperaScheduleVO> resList = new ArrayList<DoctorOperaScheduleVO>();
        List doctorVOList = this.sysUserService.getDoctorList(type, orgCode);
        if (null != doctorVOList && doctorVOList.size() > 0) {
            List numSourceList = ((QgNumSourceDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ORG_CODE", (Object)orgCode)).eq((Object)"SOURCE_FLAG", (Object)type)).in((Object)"APPOINTMENT_DATE", (Collection)MyDateUtils.getOneWeekend((Date)DateUtils.stringToDate((String)(StringUtils.isNotBlank((CharSequence)searchDate) ? searchDate : DateUtils.format((Date)new Date())), (String)"yyyy-MM-dd"))));
            for (DoctorVO vo : doctorVOList) {
                resList.add(this.handleSchedule(searchDate, vo, numSourceList));
            }
        }
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSource(QgNumSourceDTO dto) {
        this.updateById(ConvertUtils.sourceToTarget((Object)dto, QgNumSourceEntity.class));
        this.reSortNumSource(dto.getDoctorCode(), dto.getAppointmentDate(), dto.getMorOrAft(), dto.getSourceFlag());
    }

    public DoctorOperaScheduleVO handleSchedule(String searchDate, DoctorVO doctor, List<QgNumSourceEntity> dataList) {
        DoctorOperaScheduleVO resultVO = new DoctorOperaScheduleVO();
        resultVO.setWeekInfo(this.pretreatmentWeekend(searchDate));
        resultVO.setDoctorCode(doctor.getDoctorCode());
        resultVO.setDoctorName(doctor.getDoctorName());
        for (QgNumSourceEntity vo : dataList) {
            EveryDayInfoVO everyDayInfoVO;
            WeekInfoVO weekInfoVO;
            if (!vo.getDoctorCode().equalsIgnoreCase(doctor.getDoctorCode()) || null == (weekInfoVO = (WeekInfoVO)resultVO.getWeekInfo().stream().filter(s -> Objects.equals(s.getDate(), vo.getAppointmentDate())).findFirst().orElse(null))) continue;
            if (vo.getMorOrAft() == 1) {
                everyDayInfoVO = weekInfoVO.getMorning();
                everyDayInfoVO.setNumSourceTotal(Integer.valueOf(everyDayInfoVO.getNumSourceTotal() + 1));
                if (vo.getStatus() == 1) {
                    everyDayInfoVO.setOrderNum(Integer.valueOf(everyDayInfoVO.getOrderNum() + 1));
                }
                weekInfoVO.setMorning(everyDayInfoVO);
                continue;
            }
            everyDayInfoVO = weekInfoVO.getAfter();
            everyDayInfoVO.setNumSourceTotal(Integer.valueOf(everyDayInfoVO.getNumSourceTotal() + 1));
            if (vo.getStatus() == 1) {
                everyDayInfoVO.setOrderNum(Integer.valueOf(everyDayInfoVO.getOrderNum() + 1));
            }
            weekInfoVO.setAfter(everyDayInfoVO);
        }
        return resultVO;
    }

    public List<WeekInfoVO> pretreatmentWeekend(String searchDate) {
        ArrayList<WeekInfoVO> resList = new ArrayList<WeekInfoVO>();
        List weekendDays = MyDateUtils.getOneWeekend((Date)DateUtils.stringToDate((String)searchDate, (String)"yyyy-MM-dd"));
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        for (String day : weekendDays) {
            WeekInfoVO vo = new WeekInfoVO();
            vo.setDate(day);
            Date date = DateUtils.parse((String)day, (String)"yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int w = cal.get(7) - 1;
            if (w < 0) {
                w = 0;
            }
            vo.setWeekName(weekDays[w]);
            resList.add(vo);
        }
        return resList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateSource(String mainSourceId, String checkSourceId, Integer status) {
        ArrayList<QgNumSourceEntity> numSourceEntities = new ArrayList<QgNumSourceEntity>();
        QgNumSourceEntity sourceEntity = new QgNumSourceEntity();
        if (StringUtils.isNotBlank((CharSequence)mainSourceId)) {
            sourceEntity.setId(mainSourceId);
            sourceEntity.setStatus(status);
            numSourceEntities.add(sourceEntity);
        }
        if (StringUtils.isNotBlank((CharSequence)checkSourceId)) {
            sourceEntity = new QgNumSourceEntity();
            sourceEntity.setId(checkSourceId);
            sourceEntity.setStatus(status);
            numSourceEntities.add(sourceEntity);
        }
        if (CollUtil.isNotEmpty(numSourceEntities)) {
            this.updateBatchById(numSourceEntities);
        }
    }

    public QgNumSourceDTO getInfo(String numSourceId) {
        return ((QgNumSourceDao)this.baseDao).getInfo(numSourceId);
    }
}

